/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.openssl.Rand;
import com.oracle.jipher.internal.spi.CipherAlg;
import com.oracle.jipher.internal.spi.SymmCipher;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;

public abstract class AeadCipher
extends SymmCipher {
    byte[] tag;
    private int fillOffset;

    AeadCipher(CipherAlg cipherAlg) {
        super(cipherAlg);
    }

    @Override
    protected void engineUpdateAAD(byte[] aad, int off, int len) {
        if (this.updateCalled) {
            throw new IllegalStateException("AAD must be supplied before encryption/decryption starts");
        }
        this.checkIfInited();
        this.ctx.updateAad(aad, off, len);
    }

    @Override
    protected void engineUpdateAAD(ByteBuffer byteBuffer) {
        byte[] bout = new byte[byteBuffer.remaining()];
        byteBuffer.get(bout);
        this.engineUpdateAAD(bout, 0, bout.length);
    }

    @Override
    protected int engineUpdate(byte[] input, int inOffset, int inLen, byte[] out, int outOffset) throws ShortBufferException {
        this.checkIfInited();
        this.updateCalled = true;
        if (this.encrypt) {
            return super.engineUpdate(input, inOffset, inLen, out, outOffset);
        }
        if (inOffset < 0 || inLen < 0 || outOffset < 0) {
            throw new IllegalArgumentException("Invalid negative argument");
        }
        if (inLen + this.fillOffset - this.tag.length > out.length - outOffset) {
            throw new ShortBufferException("Not enough space in output array");
        }
        return this.updateTag(input, inOffset, inLen, out, outOffset);
    }

    private int updateTag(byte[] input, int inOffset, int inLen, byte[] out, int outOffset) {
        int outLen;
        if (inLen <= this.tag.length - this.fillOffset) {
            outLen = 0;
            System.arraycopy(input, inOffset, this.tag, this.fillOffset, inLen);
            this.fillOffset += inLen;
        } else if (inLen >= this.tag.length) {
            outLen = this.ctx.update(this.tag, 0, this.fillOffset, out, outOffset);
            outLen += this.ctx.update(input, inOffset, inLen - this.tag.length, out, outOffset + outLen);
            System.arraycopy(input, inOffset + inLen - this.tag.length, this.tag, 0, this.tag.length);
            this.fillOffset = this.tag.length;
        } else {
            int bytesToUpdate = this.fillOffset + inLen - this.tag.length;
            outLen = this.ctx.update(this.tag, 0, bytesToUpdate, out, outOffset);
            this.fillOffset -= bytesToUpdate;
            System.arraycopy(this.tag, bytesToUpdate, this.tag, 0, this.fillOffset);
            System.arraycopy(input, inOffset, this.tag, this.fillOffset, inLen);
            this.fillOffset += inLen;
        }
        return outLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int engineDoFinal(byte[] input, int offset, int inLen, byte[] out, int outOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        this.checkIfInited();
        try {
            int outLen = 0;
            if (inLen > 0) {
                outLen = this.engineUpdate(input, offset, inLen, out, outOffset);
            }
            if (this.encrypt) {
                if (out.length - outOffset < (outLen += this.ctx.doFinal(out, outOffset)) + this.tag.length) {
                    throw new ShortBufferException("Not enough space in output buffer.");
                }
                this.ctx.getAuthTag(out, outOffset + outLen, this.tag.length);
                int n = outLen + this.tag.length;
                return n;
            }
            if (this.fillOffset != this.tag.length) {
                throw new AEADBadTagException("Authentication tag does not match.");
            }
            this.ctx.setAuthTag(this.tag, 0, this.tag.length);
            try {
                outLen += this.ctx.doFinal(out, outOffset + outLen);
            }
            catch (BadPaddingException | IllegalBlockSizeException e) {
                throw new AEADBadTagException("Authentication tag does not match.");
            }
            int n = outLen;
            return n;
        }
        finally {
            this.cleanup();
        }
    }

    @Override
    void cleanup() {
        super.cleanup();
        this.updateCalled = false;
        Util.clearArray(this.tag);
        this.fillOffset = 0;
    }

    static abstract class Gcm
    extends AeadCipher {
        private static final int DEFAULT_TAG_LEN_BYTES = 16;
        private static final int DEFAULT_IV_SIZE_BYTES = 12;

        Gcm(CipherAlg alg) throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(alg);
            this.engineSetMode("GCM");
            this.engineSetPadding("NoPadding");
        }

        @Override
        int getUpdateOutputSize(int inputLen) {
            return inputLen;
        }

        @Override
        int getFinalOutputSize() {
            return 0;
        }

        @Override
        protected int engineGetOutputSize(int inputLen) {
            if (this.encrypt) {
                return inputLen + this.tag.length;
            }
            return inputLen;
        }

        @Override
        String getAlgorithmParametersAlg() {
            return "GCM";
        }

        @Override
        AlgorithmParameterSpec getParamSpec(byte[] iv, AlgorithmParameterSpec spec) {
            if (spec != null) {
                return spec;
            }
            return new GCMParameterSpec(this.tag.length * 8, iv);
        }

        @Override
        byte[] verifyParams(AlgorithmParameterSpec params, boolean encrypt) throws InvalidAlgorithmParameterException {
            if (params instanceof GCMParameterSpec) {
                GCMParameterSpec gcmSpec = (GCMParameterSpec)params;
                byte[] iv = gcmSpec.getIV();
                if (iv.length == 0) {
                    throw new InvalidAlgorithmParameterException("Invalid GCM IV.");
                }
                int tLen = gcmSpec.getTLen();
                if (tLen < 96 || tLen > 128 || tLen % 8 != 0) {
                    throw new InvalidAlgorithmParameterException("GCM tag length must be {128, 120, 112, 104, 96}");
                }
                this.tag = new byte[tLen / 8];
                return iv;
            }
            if (params == null && encrypt) {
                this.tag = new byte[16];
                return Rand.generate(12);
            }
            if (params == null) {
                throw new InvalidAlgorithmParameterException("GCM Parameters required for decryption");
            }
            throw new InvalidAlgorithmParameterException("Invalid GCM Parameters");
        }

        @Override
        Class<? extends AlgorithmParameterSpec> getParameterSpecClass() {
            return GCMParameterSpec.class;
        }
    }

    public static final class Aes256Gcm
    extends Gcm {
        public Aes256Gcm() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.AesGcm(32));
        }
    }

    public static final class Aes192Gcm
    extends Gcm {
        public Aes192Gcm() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.AesGcm(24));
        }
    }

    public static final class Aes128Gcm
    extends Gcm {
        public Aes128Gcm() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.AesGcm(16));
        }
    }

    public static final class AesGcm
    extends Gcm {
        public AesGcm() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.AesGcm());
        }
    }
}

