/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.loader;

import com.oracle.jipher.internal.loader.LibraryLoader;
import com.oracle.jipher.internal.loader.LibraryLoaderContext;
import com.oracle.jipher.internal.openssl.OpenSsl;
import java.nio.file.Path;
import java.nio.file.Paths;

class LibraryPathLoader
extends LibraryLoader {
    public LibraryPathLoader(LibraryLoaderContext cfg) {
        super(cfg);
    }

    @Override
    public OpenSsl load() {
        DEBUG.println("Loading from java.library.path");
        this.loadContext.getSystemLoader().loadLibrary(this.loadContext.getPlatform().getLoadLibName());
        DEBUG.println("Successfully loaded libraries from library path.");
        String dir = this.loadContext.getFipsModuleDir();
        Path cnfFile = Paths.get(dir, this.loadContext.getPlatform().getOpensslCnfFile());
        return this.loadContext.configureOpenssl(dir, cnfFile.toAbsolutePath().toString());
    }
}

