/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.loader;

import com.oracle.jipher.internal.common.Debug;
import com.oracle.jipher.internal.loader.DefaultJarLibLoader;
import com.oracle.jipher.internal.loader.InstallDirLoader;
import com.oracle.jipher.internal.loader.LibraryLoaderContext;
import com.oracle.jipher.internal.loader.LibraryPathLoader;
import com.oracle.jipher.internal.loader.TempLibraryCleaner;
import com.oracle.jipher.internal.openssl.OpenSsl;

public abstract class LibraryLoader {
    static final Debug DEBUG = Debug.getInstance("jipher");
    final LibraryLoaderContext loadContext;

    public static LibraryLoader getInstance(LibraryLoaderContext ctx) {
        if (ctx.isLibInstallDirSpecified()) {
            DEBUG.println("Library install directory specified.");
            return new InstallDirLoader(ctx);
        }
        if (ctx.isJarWithLibraries()) {
            DEBUG.println("Libraries found in classpath JAR, loading from jar.");
            return new DefaultJarLibLoader(ctx);
        }
        return new LibraryPathLoader(ctx);
    }

    LibraryLoader(LibraryLoaderContext ctx) {
        this.loadContext = ctx;
    }

    public void cleanTempDirs() {
        TempLibraryCleaner cleaner = new TempLibraryCleaner(this.loadContext);
        cleaner.cleanupDirs();
    }

    public abstract OpenSsl load();
}

