/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.pecoff.cv;

import com.oracle.objectfile.debugentry.FileEntry;
import com.oracle.objectfile.pecoff.cv.CVDebugInfo;
import com.oracle.objectfile.pecoff.cv.CVSymbolRecord;
import com.oracle.objectfile.pecoff.cv.CVSymbolSectionImpl;
import com.oracle.objectfile.pecoff.cv.CVUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.graalvm.compiler.debug.GraalError;

final class CVFileTableRecord
extends CVSymbolRecord {
    private static final int FILE_TABLE_INITIAL_SIZE = 200;
    private final CVSymbolSectionImpl.CVStringTable strings;
    private int currentOffset = 0;
    private final Map<FileEntry, FileRecord> fileEntryToRecordMap = new LinkedHashMap<FileEntry, FileRecord>(200);

    CVFileTableRecord(CVDebugInfo cvDebugInfo, CVSymbolSectionImpl.CVStringTable strings) {
        super(cvDebugInfo, 244);
        this.strings = strings;
    }

    int addFile(FileEntry entry) {
        if (this.fileEntryToRecordMap.containsKey(entry)) {
            return this.fileEntryToRecordMap.get(entry).getFileTableId();
        }
        int stringTableOffset = this.strings.add(entry.getFullName());
        this.fileEntryToRecordMap.put(entry, new FileRecord(entry, this.currentOffset, stringTableOffset));
        this.currentOffset += 24;
        return this.currentOffset - 24;
    }

    @Override
    public int computeSize(int initialPos) {
        return initialPos + this.fileEntryToRecordMap.size() * 24;
    }

    @Override
    public int computeContents(byte[] buffer, int initialPos) {
        int pos = initialPos;
        for (FileRecord record : this.fileEntryToRecordMap.values()) {
            pos = record.put(buffer, pos);
        }
        return pos;
    }

    @Override
    public String toString() {
        return "CVFileRecord(type=" + this.type + ",pos=" + this.recordStartPosition + ", size=" + this.fileEntryToRecordMap.size() + ")";
    }

    private static final class FileRecord {
        static final int FILE_RECORD_LENGTH = 24;
        private static final byte CB_VALUE = 16;
        private static final int CHECKSUM_LENGTH = 16;
        private static final byte CHECKSUM_NONE = 0;
        private static final byte CHECKSUM_MD5 = 1;
        private static final byte[] EMPTY_CHECKSUM = new byte[16];
        private final FileEntry entry;
        private final int fileTableId;
        private final int stringTableId;

        FileRecord(FileEntry entry, int fileTableId, int stringTableId) {
            this.entry = entry;
            this.fileTableId = fileTableId;
            this.stringTableId = stringTableId;
        }

        private int put(byte[] buffer, int initialPos) {
            String fn = this.entry.getFullName();
            int pos = CVUtil.putInt(this.stringTableId, buffer, initialPos);
            pos = CVUtil.putByte((byte)16, buffer, pos);
            byte[] checksum = FileRecord.calculateMD5Sum(fn);
            if (checksum != null) {
                pos = CVUtil.putByte((byte)1, buffer, pos);
                pos = CVUtil.putBytes(checksum, buffer, pos);
            } else {
                pos = CVUtil.putByte((byte)0, buffer, pos);
                pos = CVUtil.putBytes(EMPTY_CHECKSUM, buffer, pos);
            }
            pos = CVUtil.align4(pos);
            assert (pos == initialPos + 24);
            return pos;
        }

        int getFileTableId() {
            return this.fileTableId;
        }

        private static byte[] calculateMD5Sum(String fn) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(Files.readAllBytes(Paths.get(fn, new String[0])));
                return md.digest();
            }
            catch (IOException e) {
                return null;
            }
            catch (NoSuchAlgorithmException e) {
                throw GraalError.shouldNotReachHere((Throwable)e);
            }
        }
    }
}

