/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry;

import com.oracle.objectfile.debugentry.DebugInfoBase;
import com.oracle.objectfile.debugentry.TypeEntry;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import org.graalvm.compiler.debug.DebugContext;

public class PrimitiveTypeEntry
extends TypeEntry {
    private char typeChar = (char)35;
    private int flags = 0;
    private int bitCount = 0;

    public PrimitiveTypeEntry(String typeName, int size) {
        super(typeName, size);
    }

    @Override
    public DebugInfoProvider.DebugTypeInfo.DebugTypeKind typeKind() {
        return DebugInfoProvider.DebugTypeInfo.DebugTypeKind.PRIMITIVE;
    }

    @Override
    public void addDebugInfo(DebugInfoBase debugInfoBase, DebugInfoProvider.DebugTypeInfo debugTypeInfo, DebugContext debugContext) {
        super.addDebugInfo(debugInfoBase, debugTypeInfo, debugContext);
        DebugInfoProvider.DebugPrimitiveTypeInfo debugPrimitiveTypeInfo = (DebugInfoProvider.DebugPrimitiveTypeInfo)debugTypeInfo;
        this.flags = debugPrimitiveTypeInfo.flags();
        this.typeChar = debugPrimitiveTypeInfo.typeChar();
        this.bitCount = debugPrimitiveTypeInfo.bitCount();
        if (debugContext.isLogEnabled()) {
            debugContext.log("typename %s %s (%d bits)%n", (Object)this.typeName, (Object)this.decodeFlags(), (Object)this.bitCount);
        }
    }

    private String decodeFlags() {
        StringBuilder builder = new StringBuilder();
        if ((this.flags & 1) != 0) {
            if ((this.flags & 2) != 0) {
                if ((this.flags & 4) != 0) {
                    builder.append("SIGNED ");
                } else {
                    builder.append("UNSIGNED ");
                }
                builder.append("INTEGRAL");
            } else {
                builder.append("FLOATING");
            }
        } else if (this.bitCount > 0) {
            builder.append("LOGICAL");
        } else {
            builder.append("VOID");
        }
        return builder.toString();
    }

    public char getTypeChar() {
        return this.typeChar;
    }

    public int getBitCount() {
        return this.bitCount;
    }

    public int getFlags() {
        return this.flags;
    }
}

