/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure;

import com.oracle.svm.configure.ConfigurationUsageException;
import com.oracle.svm.configure.command.ConfigurationCommand;
import com.oracle.svm.configure.command.ConfigurationCommandFileCommand;
import com.oracle.svm.configure.command.ConfigurationGenerateCommand;
import com.oracle.svm.configure.command.ConfigurationGenerateConditionalsCommand;
import com.oracle.svm.configure.command.ConfigurationGenerateFiltersCommand;
import com.oracle.svm.configure.command.ConfigurationHelpCommand;
import com.oracle.svm.configure.command.ConfigurationProcessTraceCommand;
import com.oracle.svm.configure.command.ConfigurationUnknownCommand;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ConfigurationTool {
    private static final int USAGE_ERROR_CODE = 2;
    private static final int INTERNAL_ERROR_CODE = 1;
    protected static final Map<String, ConfigurationCommand> commands = new HashMap<String, ConfigurationCommand>();
    private static final ConfigurationUnknownCommand unknownCommand = new ConfigurationUnknownCommand();
    private static final ConfigurationCommandFileCommand commandFileCommand = new ConfigurationCommandFileCommand();

    public static Collection<ConfigurationCommand> getCommands() {
        return commands.values();
    }

    public static void main(String[] arguments) {
        try {
            if (arguments.length == 0) {
                throw new ConfigurationUsageException("No arguments provided.");
            }
            Iterator<String> argumentsIterator = Arrays.asList(arguments).iterator();
            String command = argumentsIterator.next();
            if (command.equals(commandFileCommand.getName())) {
                if (!(argumentsIterator = ConfigurationCommandFileCommand.handleCommandFile(argumentsIterator)).hasNext()) {
                    throw new ConfigurationUsageException("No arguments provided in the command file.");
                }
                command = argumentsIterator.next();
            }
            commands.getOrDefault(command, unknownCommand).apply(argumentsIterator);
        }
        catch (ConfigurationUsageException e) {
            System.err.println(e.getMessage() + System.lineSeparator() + "Use 'native-image-configure help' for usage.");
            System.exit(2);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    static {
        ConfigurationHelpCommand helpCommand = new ConfigurationHelpCommand();
        ConfigurationGenerateCommand generateCommand = new ConfigurationGenerateCommand();
        ConfigurationProcessTraceCommand processTraceCommand = new ConfigurationProcessTraceCommand();
        ConfigurationGenerateFiltersCommand generateFiltersCommand = new ConfigurationGenerateFiltersCommand();
        ConfigurationGenerateConditionalsCommand conditionalsCommand = new ConfigurationGenerateConditionalsCommand();
        commands.put(((ConfigurationCommand)helpCommand).getName(), helpCommand);
        commands.put(((ConfigurationCommand)generateCommand).getName(), generateCommand);
        commands.put(commandFileCommand.getName(), commandFileCommand);
        commands.put(((ConfigurationCommand)processTraceCommand).getName(), processTraceCommand);
        commands.put(((ConfigurationCommand)conditionalsCommand).getName(), conditionalsCommand);
        commands.put(((ConfigurationCommand)generateFiltersCommand).getName(), generateFiltersCommand);
    }
}

