/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.driver;

import com.oracle.svm.driver.NativeImage;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

class ArgFilesOptionPreprocessor {
    private static final String DISABLE_AT_FILES_OPTION = "--disable-@files";
    private boolean disableAtFiles = false;

    ArgFilesOptionPreprocessor() {
    }

    public List<String> process(String currentArg) {
        switch (currentArg) {
            case "--disable-@files": {
                this.disableAtFiles = true;
                return List.of();
            }
        }
        if (!this.disableAtFiles && currentArg.startsWith("@")) {
            Path argFile = Paths.get(currentArg.substring(1), new String[0]);
            return this.readArgFile(argFile);
        }
        return List.of(currentArg);
    }

    private List<String> readArgFile(Path file) {
        ArrayList<String> arguments = new ArrayList<String>();
        String options = null;
        try {
            options = new String(Files.readAllBytes(file), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            NativeImage.showError("Cannot read argument file '" + String.valueOf(file) + "'");
        }
        CTX_ARGS ctx = new CTX_ARGS();
        ctx.state = PARSER_STATE.FIND_NEXT;
        ctx.parts = new ArrayList<String>(4);
        ctx.quoteChar = (char)34;
        ctx.cptr = 0;
        ctx.eob = options.length();
        ctx.options = options;
        String token = ArgFilesOptionPreprocessor.nextToken(ctx);
        while (token != null) {
            this.addArg(arguments, token);
            token = ArgFilesOptionPreprocessor.nextToken(ctx);
        }
        if ((ctx.state == PARSER_STATE.IN_TOKEN || ctx.state == PARSER_STATE.IN_QUOTE) && ctx.parts.size() != 0) {
            token = String.join((CharSequence)"", ctx.parts);
            this.addArg(arguments, token);
        }
        return arguments;
    }

    private void addArg(List<String> args, String arg) {
        Objects.requireNonNull(arg);
        if (DISABLE_AT_FILES_OPTION.equals(arg)) {
            this.disableAtFiles = true;
        } else {
            args.add(arg);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String nextToken(CTX_ARGS ctx) {
        int nextc = ctx.cptr;
        int eob = ctx.eob;
        int anchor = nextc;
        while (true) {
            block33: {
                char ch;
                block35: {
                    block34: {
                        block31: {
                            block30: {
                                block32: {
                                    if (nextc >= eob) break block30;
                                    ch = ctx.options.charAt(nextc);
                                    if (ctx.state == PARSER_STATE.FIND_NEXT || ctx.state == PARSER_STATE.SKIP_LEAD_WS) break block31;
                                    if (ctx.state != PARSER_STATE.IN_ESCAPE) break block32;
                                    if (ch == '\n' || ch == '\r') {
                                        ctx.state = PARSER_STATE.SKIP_LEAD_WS;
                                    } else {
                                        ctx.parts.add(switch (ch) {
                                            case 'n' -> "\n";
                                            case 'r' -> "\r";
                                            case 't' -> "\t";
                                            case 'f' -> "\f";
                                            default -> String.valueOf(ch);
                                        });
                                        ctx.state = PARSER_STATE.IN_QUOTE;
                                    }
                                    anchor = nextc + 1;
                                    break block33;
                                }
                                if (ctx.state != PARSER_STATE.IN_COMMENT) break block34;
                                break block35;
                            }
                            assert (nextc == eob);
                            if ((ctx.state == PARSER_STATE.IN_TOKEN || ctx.state == PARSER_STATE.IN_QUOTE) && anchor < nextc) {
                                ctx.parts.add(ctx.options.substring(anchor, nextc));
                            }
                            return null;
                        }
                        while (ch == ' ' || ch == '\n' || ch == '\r' || ch == '\t' || ch == '\f') {
                            if (++nextc >= eob) {
                                return null;
                            }
                            ch = ctx.options.charAt(nextc);
                        }
                        ctx.state = ctx.state == PARSER_STATE.FIND_NEXT ? PARSER_STATE.IN_TOKEN : PARSER_STATE.IN_QUOTE;
                        anchor = nextc;
                    }
                    assert (ctx.state != PARSER_STATE.IN_ESCAPE);
                    assert (ctx.state != PARSER_STATE.FIND_NEXT);
                    assert (ctx.state != PARSER_STATE.SKIP_LEAD_WS);
                    assert (ctx.state != PARSER_STATE.IN_COMMENT);
                    switch (ch) {
                        case '\t': 
                        case '\f': 
                        case ' ': {
                            if (ctx.state == PARSER_STATE.IN_QUOTE) break;
                        }
                        case '\n': 
                        case '\r': {
                            String token;
                            if (ctx.parts.size() == 0) {
                                token = ctx.options.substring(anchor, nextc);
                            } else {
                                ctx.parts.add(ctx.options.substring(anchor, nextc));
                                token = String.join((CharSequence)"", ctx.parts);
                                ctx.parts = new ArrayList<String>();
                            }
                            ctx.cptr = nextc + 1;
                            ctx.state = PARSER_STATE.FIND_NEXT;
                            return token;
                        }
                        case '#': {
                            if (ctx.state == PARSER_STATE.IN_QUOTE) break;
                            ctx.state = PARSER_STATE.IN_COMMENT;
                            anchor = nextc + 1;
                            break;
                        }
                        case '\\': {
                            if (ctx.state != PARSER_STATE.IN_QUOTE) break;
                            ctx.parts.add(ctx.options.substring(anchor, nextc));
                            ctx.state = PARSER_STATE.IN_ESCAPE;
                            anchor = nextc + 1;
                            break;
                        }
                        case '\"': 
                        case '\'': {
                            if (ctx.state == PARSER_STATE.IN_QUOTE && ctx.quoteChar != ch) break;
                            if (anchor != nextc) {
                                ctx.parts.add(ctx.options.substring(anchor, nextc));
                            }
                            anchor = nextc + 1;
                            if (ctx.state == PARSER_STATE.IN_TOKEN) {
                                ctx.quoteChar = ch;
                                ctx.state = PARSER_STATE.IN_QUOTE;
                                break;
                            }
                            ctx.state = PARSER_STATE.IN_TOKEN;
                            break;
                        }
                    }
                    break block33;
                }
                while (ch != '\n' && ch != '\r') {
                    if (++nextc >= eob) {
                        return null;
                    }
                    ch = ctx.options.charAt(nextc);
                }
                anchor = nextc + 1;
                ctx.state = PARSER_STATE.FIND_NEXT;
            }
            ++nextc;
        }
    }

    private static class CTX_ARGS {
        PARSER_STATE state;
        int cptr;
        int eob;
        char quoteChar;
        List<String> parts;
        String options;

        private CTX_ARGS() {
        }
    }

    private static enum PARSER_STATE {
        FIND_NEXT,
        IN_COMMENT,
        IN_QUOTE,
        IN_ESCAPE,
        SKIP_LEAD_WS,
        IN_TOKEN;

    }
}

