/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.pki.x509;

import com.oracle.jipher.tools.asn1.Asn1;
import com.oracle.jipher.tools.asn1.Asn1BerValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;

public final class X500Util {
    private static final Map<String, String> KEYWORD_OID_MAP = X500Util.loadKeywordMap();

    private X500Util() {
    }

    public static String getAttributeValue(X500Principal dn, String attributeType) {
        Asn1BerValue oid;
        String oidStr = KEYWORD_OID_MAP.get(attributeType.toUpperCase());
        if (oidStr == null) {
            oidStr = attributeType.toUpperCase().startsWith("OID.") ? attributeType.substring(4) : attributeType;
        }
        try {
            oid = Asn1.newOid(oidStr);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid attribute type, keyword or OID expected.");
        }
        List<Asn1BerValue> rdns = Asn1.decodeOne(dn.getEncoded()).sequence();
        for (Asn1BerValue rdn : rdns) {
            List<Asn1BerValue> atvs = rdn.set();
            for (Asn1BerValue atv : atvs) {
                List<Asn1BerValue> typeAndVal = atv.sequence();
                Asn1BerValue typeOid = typeAndVal.get(0);
                if (!oid.equals(typeOid)) continue;
                return typeAndVal.get(1).getRcs();
            }
        }
        return null;
    }

    private static Map<String, String> loadKeywordMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("CN", "2.5.4.3");
        map.put("SURNAME", "2.5.4.4");
        map.put("SERIALNUMBER", "2.5.4.5");
        map.put("C", "2.5.4.6");
        map.put("L", "2.5.4.7");
        map.put("ST", "2.5.4.8");
        map.put("STREET", "2.5.4.9");
        map.put("O", "2.5.4.10");
        map.put("OU", "2.5.4.11");
        map.put("T", "2.5.4.12");
        map.put("GIVENNAME", "2.5.4.42");
        map.put("INITIALS", "2.5.4.43");
        map.put("GENERATION", "2.5.4.44");
        map.put("DNQ", "2.5.4.46");
        map.put("DNQUALIFIER", "2.5.4.46");
        map.put("DC", "0.9.2342.19200300.100.1.25");
        map.put("UID", "0.9.2342.19200300.100.1.1");
        map.put("EMAILADDRESS", "1.2.840.113549.1.9.1");
        return map;
    }
}

