/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.pki.x509;

import com.oracle.jipher.pki.x509.DistributionPoint;
import com.oracle.jipher.pki.x509.GeneralName;
import com.oracle.jipher.pki.x509.X509ExtnValue;
import com.oracle.jipher.tools.asn1.Asn1;
import com.oracle.jipher.tools.asn1.Asn1BerValue;
import com.oracle.jipher.tools.asn1.Asn1Exception;
import com.oracle.jipher.tools.asn1.UniversalTag;
import java.security.cert.CRLReason;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import javax.security.auth.x500.X500Principal;

public class CrlDistributionPoints
implements X509ExtnValue {
    private static final String OID = "2.5.29.31";
    private byte[] encoding;
    private List<DistributionPoint> dps;

    private CrlDistributionPoints(byte[] encoding, List<DistributionPoint> points) {
        this.encoding = encoding;
        this.dps = points;
    }

    @Override
    public byte[] getEncoded() {
        return (byte[])this.encoding.clone();
    }

    public List<DistributionPoint> getAll() {
        return Collections.unmodifiableList(this.dps);
    }

    public String toString() {
        return "CRLDistributionPoints:=" + this.dps.toString();
    }

    public static CrlDistributionPoints decode(X509Extension extnObject) {
        byte[] extBytes = extnObject.getExtensionValue(OID);
        if (extBytes == null) {
            return null;
        }
        ArrayList<DistributionPoint> dpList = new ArrayList<DistributionPoint>();
        try {
            byte[] extVal = Asn1.decodeOne(extBytes).tag(UniversalTag.OCTET_STRING).getOctetString();
            List<Asn1BerValue> dps = Asn1.decodeOne(extVal).tag(UniversalTag.SEQUENCE).sequence();
            for (Asn1BerValue dp : dps) {
                dpList.add(CrlDistributionPoints.dp(dp));
            }
            return new CrlDistributionPoints(extVal, dpList);
        }
        catch (Asn1Exception e) {
            throw new IllegalArgumentException("Invalid CRL Distribution Points encoding.", e);
        }
    }

    private static DistributionPoint dp(Asn1BerValue dp) {
        List<Asn1BerValue> dpContents = dp.tag(UniversalTag.SEQUENCE).count(1, 3).sequence();
        ArrayList<GeneralName> fullName = null;
        ArrayList<GeneralName> crlIssuer = null;
        X500Principal relativeName = null;
        ArrayList<CRLReason> reasons = null;
        for (Asn1BerValue val : dpContents) {
            if (val.hasTag(0)) {
                Asn1BerValue dpName = val.tag(0).explicit();
                if (dpName.hasTag(0)) {
                    List<Asn1BerValue> fullNameGns = dpName.tag(0).sequence();
                    fullName = new ArrayList<GeneralName>();
                    for (Asn1BerValue nameGn : fullNameGns) {
                        fullName.add(GeneralName.decode(nameGn.encodeDerOctets()));
                    }
                    continue;
                }
                if (dpName.hasTag(1)) {
                    List<Asn1BerValue> rdns = dpName.tag(1).set();
                    byte[] rdnDer = Asn1.newSequence(Asn1.newSet(rdns)).encodeDerOctets();
                    relativeName = new X500Principal(rdnDer);
                    continue;
                }
                throw new Asn1Exception("Unexpected tag for distributionPoint");
            }
            if (val.hasTag(1)) {
                reasons = new ArrayList<CRLReason>();
                BitSet bitString = val.getBitString();
                for (int i = 0; i < bitString.size(); ++i) {
                    if (!bitString.get(i)) continue;
                    reasons.add(CrlDistributionPoints.getReason(i));
                }
                continue;
            }
            if (val.hasTag(2)) {
                List<Asn1BerValue> fullNameGns = val.tag(2).sequence();
                crlIssuer = new ArrayList<GeneralName>();
                for (Asn1BerValue nameGn : fullNameGns) {
                    crlIssuer.add(GeneralName.decode(nameGn.encodeDerOctets()));
                }
                continue;
            }
            throw new Asn1Exception("Unexpected context specific tag value.");
        }
        return new DistributionPoint(fullName, relativeName, reasons, crlIssuer);
    }

    private static CRLReason getReason(int i) {
        if (i <= 6) {
            return CRLReason.values()[i];
        }
        if (i == 7) {
            return CRLReason.PRIVILEGE_WITHDRAWN;
        }
        if (i == 8) {
            return CRLReason.AA_COMPROMISE;
        }
        throw new Asn1Exception("Unknown CRL Reason");
    }
}

