/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.pki.ocsp;

import com.oracle.jipher.pki.internal.AlgIdException;
import com.oracle.jipher.pki.internal.AlgorithmId;
import com.oracle.jipher.pki.internal.Util;
import com.oracle.jipher.tools.asn1.Asn1;
import com.oracle.jipher.tools.asn1.Asn1BerValue;
import com.oracle.jipher.tools.asn1.UniversalTag;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;

class CertId {
    AlgorithmId hashAlg;
    private byte[] issuerNameHash;
    private byte[] issuerKeyHash;
    private BigInteger serialNumber;

    private CertId(AlgorithmId id, byte[] nameHash, byte[] keyHash, BigInteger serial) {
        this.hashAlg = id;
        this.issuerNameHash = nameHash;
        this.issuerKeyHash = keyHash;
        this.serialNumber = serial;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CertId)) {
            return false;
        }
        CertId other = (CertId)obj;
        return this.hashAlg.getAlg().equals(other.hashAlg.getAlg()) && Arrays.equals(this.issuerKeyHash, other.issuerKeyHash) && Arrays.equals(this.issuerNameHash, other.issuerNameHash) && this.serialNumber.equals(other.serialNumber);
    }

    public int hashCode() {
        return this.hashAlg.getAlg().hashCode() + new BigInteger(this.issuerKeyHash).hashCode() + new BigInteger(this.issuerNameHash).hashCode() + this.serialNumber.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.hashAlg.getAlg()).append(",serial=").append(this.serialNumber);
        sb.append(",nameHash=").append(Util.toHex(this.issuerNameHash));
        sb.append(",keyHash=").append(Util.toHex(this.issuerKeyHash));
        return sb.toString();
    }

    Asn1BerValue toAsn1BerValue() throws AlgIdException {
        return Asn1.newSequence(this.hashAlg.toAsn1Value(), Asn1.newOctetString(this.issuerNameHash), Asn1.newOctetString(this.issuerKeyHash), Asn1.newInteger(this.serialNumber));
    }

    static CertId create(AlgorithmId hashAlgId, X509Certificate cert, X509Certificate issuer) throws NoSuchAlgorithmException {
        return new CertId(hashAlgId, CertId.hash(hashAlgId.getAlg(), cert.getIssuerX500Principal().getEncoded()), CertId.getIssuerKeyHash(hashAlgId.getAlg(), issuer.getPublicKey()), cert.getSerialNumber());
    }

    static CertId decode(Asn1BerValue value) throws AlgIdException {
        List<Asn1BerValue> certIdContents = value.tag(UniversalTag.SEQUENCE).count(4).sequence();
        AlgorithmId algId = AlgorithmId.decode(certIdContents.get(0));
        byte[] iNameHash = certIdContents.get(1).tag(UniversalTag.OCTET_STRING).getOctetString();
        byte[] iKeyHash = certIdContents.get(2).tag(UniversalTag.OCTET_STRING).getOctetString();
        BigInteger serial = certIdContents.get(3).tag(UniversalTag.INTEGER).getInteger();
        return new CertId(algId, iNameHash, iKeyHash, serial);
    }

    private static byte[] hash(String alg, byte[] tbh) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(alg);
        return md.digest(tbh);
    }

    private static byte[] getIssuerKeyHash(String hashAlg, PublicKey issuerKey) throws NoSuchAlgorithmException {
        Asn1BerValue subjectKeyInfo = Asn1.decodeOne(issuerKey.getEncoded());
        ByteBuffer subKeyContent = subjectKeyInfo.sequence().get(1).content();
        subKeyContent.get();
        byte[] toBeHashed = new byte[subKeyContent.remaining()];
        subKeyContent.get(toBeHashed);
        return CertId.hash(hashAlg, toBeHashed);
    }
}

