/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.pki.internal;

import com.oracle.jipher.pki.internal.Util;
import com.oracle.jipher.pki.x509.GeneralName;
import com.oracle.jipher.tools.asn1.Asn1;
import com.oracle.jipher.tools.asn1.Asn1BerValue;
import com.oracle.jipher.tools.asn1.UniversalTag;
import java.util.Arrays;
import java.util.List;
import javax.security.auth.x500.X500Principal;

public abstract class GeneralNameValue {
    String str;

    public static GeneralNameValue create(GeneralName.Type type, String str) {
        if (type == null || str == null) {
            throw new IllegalArgumentException("Inputs cannot be null");
        }
        switch (type) {
            case RFC822_NAME: {
                return new Rfc822(str);
            }
            case DNS_NAME: {
                return new DnsName(str);
            }
            case DIRECTORY_NAME: {
                return new DirName(new X500Principal(str));
            }
            case REGISTERED_ID: {
                return new RegisteredId(str);
            }
            case IP_ADDRESS: {
                return new IpAddress(str);
            }
            case URI: {
                return new Uri(str);
            }
        }
        throw new UnsupportedOperationException("Creation of " + (Object)((Object)type) + " not supported");
    }

    public static GeneralNameValue decode(GeneralName.Type type, Asn1BerValue value) {
        switch (type) {
            case OTHER_NAME: {
                return new OtherName(value);
            }
            case RFC822_NAME: {
                return new Rfc822(value);
            }
            case DNS_NAME: {
                return new DnsName(value);
            }
            case DIRECTORY_NAME: {
                return new DirName(value);
            }
            case X400_ADDRESS: {
                return new OrAddress(value);
            }
            case EDI_PARTY_NAME: {
                return new EdiPartyName(value);
            }
            case REGISTERED_ID: {
                return new RegisteredId(value);
            }
            case IP_ADDRESS: {
                return new IpAddress(value);
            }
            case URI: {
                return new Uri(value);
            }
        }
        throw new IllegalArgumentException("Invalid type");
    }

    public String toString() {
        return this.str;
    }

    static String stringRepn(Asn1BerValue ber) {
        if (ber.constructed) {
            return "#" + Util.toHex(ber.encodeDerOctets());
        }
        return ber.toString();
    }

    public abstract Asn1BerValue toAsn1BerValue();

    public byte[] getEncoded() {
        return this.toAsn1BerValue().encodeDerOctets();
    }

    public static class Rfc822
    extends GeneralNameValue {
        Rfc822(String str) {
            this.str = str;
        }

        Rfc822(Asn1BerValue val) {
            this(val.getRcs(UniversalTag.IA5String));
        }

        @Override
        public Asn1BerValue toAsn1BerValue() {
            return Asn1.newRcs(this.str, UniversalTag.IA5String);
        }
    }

    public static class DnsName
    extends GeneralNameValue {
        DnsName(String str) {
            this.str = str;
        }

        DnsName(Asn1BerValue val) {
            this(val.getRcs(UniversalTag.IA5String));
        }

        @Override
        public Asn1BerValue toAsn1BerValue() {
            return Asn1.newRcs(this.str, UniversalTag.IA5String);
        }
    }

    public static class DirName
    extends GeneralNameValue {
        X500Principal dir;

        public DirName(X500Principal p) {
            this.dir = p;
            this.str = this.dir.getName();
        }

        DirName(Asn1BerValue val) {
            this(new X500Principal(val.encodeDerOctets()));
        }

        @Override
        public Asn1BerValue toAsn1BerValue() {
            return Asn1.decodeOne(this.dir.getEncoded());
        }
    }

    public static class RegisteredId
    extends GeneralNameValue {
        RegisteredId(String str) {
            this.str = str;
        }

        RegisteredId(Asn1BerValue val) {
            this(val.getOid());
        }

        @Override
        public Asn1BerValue toAsn1BerValue() {
            return Asn1.newOid(this.str);
        }
    }

    public static class IpAddress
    extends GeneralNameValue {
        byte[] bytes;

        private IpAddress(byte[] octets) {
            this.bytes = octets;
            this.str = IpAddress.toIpStr(this.bytes);
        }

        IpAddress(String str) {
            this(IpAddress.ipAddressToBytes(str));
        }

        IpAddress(Asn1BerValue val) {
            this(val.getOctetString());
        }

        private static String toIpStr(byte[] octets) {
            if (octets.length == 4 || octets.length == 8) {
                String str = IpAddress.toIpV4(octets);
                if (octets.length == 8) {
                    str = str + "/" + IpAddress.toIpV4(Arrays.copyOfRange(octets, 4, 8));
                }
                return str;
            }
            if (octets.length == 16 || octets.length == 32) {
                String str = IpAddress.toIpV6(octets);
                if (octets.length == 32) {
                    str = str + "/" + IpAddress.toIpV6(Arrays.copyOfRange(octets, 16, 32));
                }
                return str;
            }
            throw new IllegalArgumentException("Invalid IP Address");
        }

        private static String toIpV4(byte[] src) {
            return (src[0] & 0xFF) + "." + (src[1] & 0xFF) + "." + (src[2] & 0xFF) + "." + (src[3] & 0xFF);
        }

        private static String toIpV6(byte[] src) {
            StringBuilder sb = new StringBuilder(39);
            for (int i = 0; i < 8; ++i) {
                sb.append(Integer.toHexString(src[i << 1] << 8 & 0xFF00 | src[(i << 1) + 1] & 0xFF));
                if (i >= 7) continue;
                sb.append(":");
            }
            return sb.toString();
        }

        @Override
        public Asn1BerValue toAsn1BerValue() {
            return Asn1.newOctetString(IpAddress.ipAddressToBytes(this.str));
        }

        private static byte[] ipV4ToBytes(String ipAddress) {
            String[] ss = ipAddress.split("\\.");
            if (ss.length != 4) {
                throw new IllegalArgumentException("Invalid IP v4 Address");
            }
            byte[] bb = new byte[4];
            for (int i = 0; i < 4; ++i) {
                try {
                    int num = Integer.parseInt(ss[i]);
                    if (num < 0 || num > 255) {
                        throw new IllegalArgumentException("Invalid IP Address");
                    }
                    bb[i] = (byte)num;
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid IP Address");
                }
            }
            return bb;
        }

        private static byte[] ipV6ToBytes(String ipAddress) {
            if (!ipAddress.matches("[a-fA-F0-9:]+")) {
                throw new IllegalArgumentException("Invalid IPV6 address");
            }
            String[] ss = ipAddress.split(":");
            if (ss.length != 8) {
                throw new IllegalArgumentException("Invalid IPV6 address");
            }
            byte[] ret = new byte[16];
            for (int i = 0; i < ss.length; ++i) {
                String hex4 = "";
                if (ss[i].length() > 4) {
                    throw new IllegalArgumentException("Invalid IPV6 Address");
                }
                for (int j = 0; j < 4 - ss[i].length(); ++j) {
                    hex4 = hex4 + "0";
                }
                hex4 = hex4 + ss[i];
                ret[2 * i] = (byte)Integer.parseInt(hex4.substring(0, 2), 16);
                ret[2 * i + 1] = (byte)Integer.parseInt(hex4.substring(2, 4), 16);
            }
            return ret;
        }

        private static byte[] ipAddressToBytes(String ipAddress) {
            if (ipAddress.contains(".")) {
                return IpAddress.ipV4ToBytes(ipAddress);
            }
            return IpAddress.ipV6ToBytes(ipAddress);
        }
    }

    public static class Uri
    extends GeneralNameValue {
        Uri(String str) {
            this.str = str;
        }

        Uri(Asn1BerValue val) {
            this(val.getRcs(UniversalTag.IA5String));
        }

        @Override
        public Asn1BerValue toAsn1BerValue() {
            return Asn1.newRcs(this.str, UniversalTag.IA5String);
        }
    }

    public static class OtherName
    extends GeneralNameValue {
        Asn1BerValue value;

        OtherName(Asn1BerValue inVal) {
            List<Asn1BerValue> typeVal = inVal.count(2).sequence();
            this.str = typeVal.get(0).tag(UniversalTag.OBJECT_IDENTIFIER).getOid();
            this.str = this.str + ": " + OtherName.stringRepn(typeVal.get(1).tag(0).explicit());
            this.value = Asn1.newSequence(typeVal);
        }

        @Override
        public Asn1BerValue toAsn1BerValue() {
            return this.value;
        }
    }

    public static class OrAddress
    extends GeneralNameValue {
        Asn1BerValue value;

        OrAddress(Asn1BerValue inVal) {
            this.value = Asn1.newSequence(inVal.sequence());
            this.str = OrAddress.stringRepn(this.value);
        }

        @Override
        public Asn1BerValue toAsn1BerValue() {
            return this.value;
        }
    }

    public static class EdiPartyName
    extends GeneralNameValue {
        private Asn1BerValue value;

        EdiPartyName(Asn1BerValue value) {
            List<Asn1BerValue> assignerParty = value.tag(5).count(1, 2).sequence();
            StringBuilder sb = new StringBuilder();
            if (assignerParty.size() == 1) {
                sb.append("party=").append(assignerParty.get(0).tag(1).explicit().toString());
            } else {
                sb.append("assigner=").append(assignerParty.get(0).tag(0).explicit().toString());
                sb.append(",party=").append(assignerParty.get(1).tag(1).explicit().toString());
            }
            this.value = Asn1.newSequence(assignerParty);
            this.str = sb.toString();
        }

        @Override
        public Asn1BerValue toAsn1BerValue() {
            return this.value;
        }
    }
}

