/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.nfi;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.handles.PrimitiveArrayView;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.nodes.CFunctionEpilogueNode;
import com.oracle.svm.core.nodes.CFunctionPrologueNode;
import com.oracle.svm.truffle.nfi.ErrnoMirror;
import com.oracle.svm.truffle.nfi.LocalNativeScope;
import com.oracle.svm.truffle.nfi.NFIInitialization;
import com.oracle.svm.truffle.nfi.NativeAPI;
import com.oracle.svm.truffle.nfi.NativeClosure;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_backend_libffi_LibFFIType;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_backend_libffi_NativeArgumentBuffer_TypeTag;
import com.oracle.svm.truffle.nfi.TruffleObjectHandle;
import com.oracle.svm.truffle.nfi.libffi.LibFFI;
import com.oracle.svm.truffle.nfi.libffi.LibFFIHeaderDirectives;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.struct.CFieldAddress;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

final class NativeSignature {
    NativeSignature() {
    }

    private static <E extends Throwable> RuntimeException rethrow(Throwable ex) throws E {
        throw ex;
    }

    static class ExecuteHelper {
        ExecuteHelper() {
        }

        static int alignUp(int index, int alignment) {
            int mask = alignment - 1;
            assert ((alignment & mask) == 0) : "not a power of 2";
            return index + mask & ~mask;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void execute(NativeAPI.NativeTruffleContext ctx, LibFFI.ffi_cif cif, PointerBase ret, long functionPointer, byte[] primArgs, int patchCount, int[] patchOffsets, Object[] objArgs, LocalNativeScope scope) {
            int nargs = cif.nargs();
            WordPointer argPtrs = (WordPointer)UnmanagedMemory.malloc((int)(nargs * SizeOf.get(WordPointer.class)));
            NativeAPI.NativeTruffleEnv env = (NativeAPI.NativeTruffleEnv)UnsafeStackValue.get(NativeAPI.NativeTruffleEnv.class);
            NFIInitialization.initializeEnv(env, ctx);
            try (PrimitiveArrayView primBuffer = PrimitiveArrayView.createForReading((Object)primArgs);){
                int i;
                Pointer prim = (Pointer)primBuffer.addressOfArrayElement(0);
                int primIdx = 0;
                for (i = 0; i < nargs; ++i) {
                    LibFFI.ffi_type type = cif.arg_types().read(i);
                    primIdx = ExecuteHelper.alignUp(primIdx, type.alignment());
                    argPtrs.write(i, (WordBase)prim.add(primIdx));
                    primIdx += (int)type.size().rawValue();
                }
                for (i = 0; i < patchCount; ++i) {
                    Target_com_oracle_truffle_nfi_backend_libffi_NativeArgumentBuffer_TypeTag tag = Target_com_oracle_truffle_nfi_backend_libffi_NativeArgumentBuffer_TypeTag.getTag(patchOffsets[i]);
                    int offset = Target_com_oracle_truffle_nfi_backend_libffi_NativeArgumentBuffer_TypeTag.getOffset(patchOffsets[i]);
                    Object obj = objArgs[i];
                    if (tag == Target_com_oracle_truffle_nfi_backend_libffi_NativeArgumentBuffer_TypeTag.OBJECT) {
                        TruffleObjectHandle handle = scope.createLocalHandle(obj);
                        prim.writeWord(offset, (WordBase)handle);
                        continue;
                    }
                    if (tag == Target_com_oracle_truffle_nfi_backend_libffi_NativeArgumentBuffer_TypeTag.STRING) {
                        PointerBase strPtr = scope.refString((String)obj);
                        prim.writeWord(offset, (WordBase)strPtr);
                        continue;
                    }
                    if (tag == Target_com_oracle_truffle_nfi_backend_libffi_NativeArgumentBuffer_TypeTag.KEEPALIVE) continue;
                    if (tag == Target_com_oracle_truffle_nfi_backend_libffi_NativeArgumentBuffer_TypeTag.ENV) {
                        prim.writeWord(offset, (WordBase)env);
                        continue;
                    }
                    PointerBase arrPtr = scope.refArray(obj);
                    prim.writeWord(offset, (WordBase)arrPtr);
                }
                ExecuteHelper.ffiCall(cif, WordFactory.pointer((long)functionPointer), ret, argPtrs, (CIntPointer)ErrnoMirror.errnoMirror.getAddress());
                Throwable pending = (Throwable)NativeClosure.pendingException.get();
                if (pending != null) {
                    NativeClosure.pendingException.set(null);
                    throw NativeSignature.rethrow(pending);
                }
            }
            finally {
                UnmanagedMemory.free((PointerBase)argPtrs);
            }
        }

        @NeverInline(value="Must not be inlined in a caller that has an exception handler: We only support InvokeNode and not InvokeWithExceptionNode between a CFunctionPrologueNode and CFunctionEpilogueNode")
        private static void ffiCall(LibFFI.ffi_cif cif, PointerBase fn, PointerBase rvalue, WordPointer avalue, CIntPointer errnoMirror) {
            CFunctionPrologueNode.cFunctionPrologue((int)3);
            ExecuteHelper.doFfiCall(cif, fn, rvalue, avalue, errnoMirror);
            CFunctionEpilogueNode.cFunctionEpilogue((int)3);
        }

        @Uninterruptible(reason="In native.")
        @NeverInline(value="Can have only a single invoke between CFunctionPrologueNode and CFunctionEpilogueNode.")
        private static void doFfiCall(LibFFI.ffi_cif cif, PointerBase fn, PointerBase rvalue, WordPointer avalue, CIntPointer errnoMirror) {
            LibC.setErrno((int)errnoMirror.read());
            LibFFI.NoTransitions.ffi_call(cif, fn, rvalue, avalue);
            errnoMirror.write(LibC.errno());
        }
    }

    static class PrepareHelper {
        PrepareHelper() {
        }

        static CifData prepareArgs(int argCount, Target_com_oracle_truffle_nfi_backend_libffi_LibFFIType ... args) {
            CifData data = (CifData)UnmanagedMemory.malloc((int)(SizeOf.get(CifData.class) + argCount * SizeOf.get(LibFFI.ffi_type_array.class)));
            for (int i = 0; i < argCount; ++i) {
                data.args().write(i, (LibFFI.ffi_type)WordFactory.pointer((long)args[i].type));
            }
            return data;
        }

        static long checkRet(CifData data, int ret) {
            if (ret == LibFFI.FFI_OK()) {
                return data.rawValue();
            }
            UnmanagedMemory.free((PointerBase)data);
            return 0L;
        }
    }

    @CContext(value=LibFFIHeaderDirectives.class)
    @CStruct(value="svm_cif_data")
    public static interface CifData
    extends PointerBase {
        @CFieldAddress
        public LibFFI.ffi_cif cif();

        @CFieldAddress
        public LibFFI.ffi_type_array args();
    }
}

