/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.isolated;

import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.CompilerHandle;
import com.oracle.svm.graal.isolated.CompilerIsolateThread;
import com.oracle.svm.graal.isolated.IsolatedCompileClient;
import com.oracle.svm.graal.isolated.IsolatedCompileContext;
import java.util.function.Supplier;
import org.graalvm.nativeimage.c.function.CEntryPoint;

final class IsolatedStringSupplier
implements Supplier<String> {
    private final CompilerHandle<Supplier<String>> originalObjectHandle;

    IsolatedStringSupplier(CompilerHandle<Supplier<String>> originalObjectHandle) {
        this.originalObjectHandle = originalObjectHandle;
    }

    @Override
    public String get() {
        ClientHandle<String> resultHandle = IsolatedStringSupplier.getReasonAndStackTrace0(IsolatedCompileClient.get().getCompiler(), this.originalObjectHandle);
        return (String)IsolatedCompileClient.get().unhand(resultHandle);
    }

    @CEntryPoint(exceptionHandler=IsolatedCompileContext.WordExceptionHandler.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(callerEpilogue=IsolatedCompileContext.ExceptionRethrowCallerEpilogue.class)
    private static ClientHandle<String> getReasonAndStackTrace0(CompilerIsolateThread compiler, CompilerHandle<Supplier<String>> reasonAndStackTraceHandle) {
        Supplier supplier = (Supplier)IsolatedCompileContext.get().unhand(reasonAndStackTraceHandle);
        return IsolatedCompileContext.get().createStringInClient((CharSequence)supplier.get());
    }
}

