/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.compiler.hotspot.libgraal;

import com.oracle.truffle.compiler.hotspot.libgraal.FromLibGraalId;
import com.oracle.truffle.compiler.hotspot.libgraal.TruffleFromLibGraalRepeated;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;

@Repeatable(value=TruffleFromLibGraalRepeated.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
public @interface TruffleFromLibGraal {
    public Id value();

    public static enum Id implements FromLibGraalId
    {
        AddTargetToDequeue,
        AddInlinedTarget,
        AsJavaConstant,
        CancelCompilation,
        CompilableToString,
        ConsumeOptimizedAssumptionDependency,
        CreateStringSupplier,
        CountDirectCallNodes,
        EngineId,
        GetCompilableCallCount,
        GetCompilableName,
        GetCompilerOptions,
        GetConstantFieldInfo,
        GetDescription,
        GetFailedSpeculationsAddress,
        GetKnownCallSiteCount,
        GetLanguage,
        GetLineNumber,
        PrepareForCompilation,
        GetNodeId,
        GetNodeClassName,
        GetDebugProperties,
        GetNonTrivialNodeCount,
        GetOffsetEnd,
        GetOffsetStart,
        GetPosition,
        GetSuppliedString,
        GetURI,
        IsCancelled,
        IsLastTier,
        HasNextTier,
        IsSameOrSplit,
        IsSuppressedFailure,
        IsTrivial,
        IsValueType,
        Log,
        OnCodeInstallation,
        OnCompilationFailed,
        OnCompilationRetry,
        OnFailure,
        OnGraalTierFinished,
        OnSuccess,
        OnTruffleTierFinished,
        GetPartialEvaluationMethodInfo,
        GetHostMethodInfo,
        RegisterOptimizedAssumptionDependency,
        SetCallCounts,
        OnIsolateShutdown;

        private final String signature;
        private final String methodName;
        private final Class<?> returnType;
        private final Class<?>[] parameterTypes;

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public String getSignature() {
            return this.signature;
        }

        @Override
        public String getMethodName() {
            return this.methodName;
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.parameterTypes;
        }

        @Override
        public Class<?> getReturnType() {
            return this.returnType;
        }

        public String toString() {
            return this.methodName + this.signature;
        }

        private Id() {
            try {
                Signature sig = Id.class.getDeclaredField(this.name()).getAnnotation(Signature.class);
                Class<?>[] sigTypes = sig.value();
                this.returnType = sigTypes[0];
                this.parameterTypes = Arrays.copyOfRange(sigTypes, 1, sigTypes.length);
                this.signature = FromLibGraalId.encodeMethodSignature(this.returnType, this.parameterTypes);
                this.methodName = Character.toLowerCase(this.name().charAt(0)) + this.name().substring(1);
            }
            catch (NoSuchFieldException e) {
                throw new InternalError(e);
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Signature {
        public Class<?>[] value();
    }
}

