/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.jitprofiling.vtune;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.code.CompilationResultFrameTree;
import com.oracle.svm.core.code.InstalledCodeObserver;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.jitprofiling.vtune.Jitprofiling;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import jdk.vm.ci.code.BytecodePosition;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.ProcessProperties;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.impl.UnmanagedMemorySupport;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

final class VTuneDynamicCodeObserver
implements InstalledCodeObserver {
    private final DebugContext xY;
    private final CompilationResult xZ;
    private final Pointer ya;
    private int yb;
    private final Path yc;

    VTuneDynamicCodeObserver(DebugContext debugContext, CompilationResult compilationResult, Pointer pointer) {
        this.xY = debugContext;
        this.xZ = compilationResult;
        this.ya = pointer;
        this.yc = VTuneDynamicCodeObserver.gl();
    }

    private static Path gl() {
        String string = (String)com.oracle.svm.enterprise.jitprofiling.vtune.d.VTuneRuntimeSourceDestDir.getValue();
        if (string != null) {
            return Path.of(string, new String[0]);
        }
        Path path = Path.of("sources", new String[0]);
        Path path2 = Path.of(ProcessProperties.getExecutableName(), new String[0]).getParent();
        if (path2 != null) {
            path = path2.resolve(path);
        }
        return path;
    }

    public InstalledCodeObserver.InstalledCodeObserverHandle install() {
        if (Jitprofiling.iJIT_IsProfilingActive() != Jitprofiling.a.iJIT_SAMPLING_ON) {
            return (InstalledCodeObserver.InstalledCodeObserverHandle)WordFactory.nullPointer();
        }
        Object object = this.xZ.getName();
        if (object == null || ((String)object).isEmpty()) {
            object = "UnnamedCU";
        }
        object = "jit " + (String)object;
        CompilationResultFrameTree.CallNode callNode = new CompilationResultFrameTree.Builder(this.xY, this.xZ.getTargetCodeSize(), Integer.MAX_VALUE, true, true).build(this.xZ);
        if (callNode == null) {
            return (InstalledCodeObserver.InstalledCodeObserverHandle)WordFactory.nullPointer();
        }
        this.yb = 0;
        new d().a((String)object, callNode);
        if (this.yb == 0) {
            return (InstalledCodeObserver.InstalledCodeObserverHandle)WordFactory.nullPointer();
        }
        JITMethodHandle jITMethodHandle = (JITMethodHandle)UnmanagedMemory.malloc((int)SizeOf.get(JITMethodHandle.class));
        jITMethodHandle.setAccessor((InstalledCodeObserver.InstalledCodeObserverHandleAccessor)ImageSingletons.lookup(b.class));
        jITMethodHandle.setJitMethodID(this.yb);
        return jITMethodHandle;
    }

    private String a(StackTraceElement stackTraceElement) {
        Path path = this.yc.resolve(VTuneDynamicCodeObserver.b(stackTraceElement));
        if (((Boolean)com.oracle.svm.enterprise.jitprofiling.vtune.d.VTuneAbsoluteFilenames.getValue()).booleanValue()) {
            try {
                return path.toAbsolutePath().toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return path.toString();
    }

    private static String b(StackTraceElement stackTraceElement) {
        String string = stackTraceElement.getClassName();
        String string2 = string.substring(0, Math.max(0, string.lastIndexOf(46)));
        StringBuilder stringBuilder = new StringBuilder(string2.replace('.', File.separatorChar));
        if (stringBuilder.length() > 0) {
            stringBuilder.append(File.separatorChar);
        }
        stringBuilder.append(stackTraceElement.getFileName());
        return stringBuilder.toString();
    }

    private static String a(CompilationResultFrameTree.CallNode callNode) {
        return callNode.frame.getMethod().format("%H:%n(%P)").replace(".", ":");
    }

    private final class d
    implements CompilationResultFrameTree.Visitor {
        private CCharPointer yj;

        private d() {
        }

        public void a(String string, CompilationResultFrameTree.CallNode callNode) {
            try (DebugContext.Scope scope = VTuneDynamicCodeObserver.this.xY.scope((Object)"VTuneEventsEmitter", (Object)callNode);){
                VTuneDynamicCodeObserver.this.xY.log("Running VTuneEventsEmitter for %s", (Object)string);
                try (CTypeConversion.CCharPointerHolder cCharPointerHolder = CTypeConversion.toCString((CharSequence)string);){
                    this.yj = cCharPointerHolder.get();
                    callNode.visit((CompilationResultFrameTree.Visitor)this, new Object[0]);
                }
            }
            catch (Throwable throwable) {
                throw VTuneDynamicCodeObserver.this.xY.handle(throwable);
            }
        }

        public void apply(CompilationResultFrameTree.FrameNode frameNode, Object ... objectArray) {
            int n2;
            if (!(frameNode instanceof CompilationResultFrameTree.CallNode)) {
                return;
            }
            CompilationResultFrameTree.CallNode callNode = (CompilationResultFrameTree.CallNode)frameNode;
            if (objectArray.length == 0) {
                n2 = this.b(callNode);
            } else {
                int n3 = (Integer)objectArray[0];
                n2 = this.a(callNode, n3);
            }
            frameNode.visitChildren((CompilationResultFrameTree.Visitor)this, new Object[]{n2});
        }

        private int b(CompilationResultFrameTree.CallNode callNode) {
            Serializable serializable;
            VTuneDynamicCodeObserver.this.xY.log("%nEmitting METHOD_LOAD event for %s", (Object)callNode);
            if (VTuneDynamicCodeObserver.this.xY.isLogEnabled(4)) {
                serializable = new StringBuilder();
                CompilationResultFrameTree.dump((CompilationResultFrameTree.FrameNode)callNode, ((StringBuilder)serializable)::append, (boolean)false, (boolean)false, (int)1);
                VTuneDynamicCodeObserver.this.xY.log("%s", (Object)serializable);
            }
            serializable = callNode.getStackTraceElement();
            try (CTypeConversion.CCharPointerHolder cCharPointerHolder = CTypeConversion.toCString((CharSequence)VTuneDynamicCodeObserver.a(callNode));){
                int n2;
                block20: {
                    CTypeConversion.CCharPointerHolder cCharPointerHolder2 = CTypeConversion.toCString((CharSequence)VTuneDynamicCodeObserver.this.a((StackTraceElement)serializable));
                    try {
                        int n3 = SizeOf.get(Jitprofiling.iJIT_Method_Load_V2.class);
                        Jitprofiling.iJIT_Method_Load_V2 iJIT_Method_Load_V22 = (Jitprofiling.iJIT_Method_Load_V2)UnsafeStackValue.get((int)n3);
                        UnmanagedMemoryUtil.fill((Pointer)((Pointer)iJIT_Method_Load_V22), (UnsignedWord)WordFactory.unsigned((int)n3), (byte)0);
                        int n4 = Jitprofiling.iJIT_GetNewMethodID();
                        VMError.guarantee((n4 != 0 ? 1 : 0) != 0);
                        iJIT_Method_Load_V22.set_method_id(n4);
                        iJIT_Method_Load_V22.set_module_name(this.yj);
                        iJIT_Method_Load_V22.set_method_name(cCharPointerHolder.get());
                        iJIT_Method_Load_V22.set_method_load_address((PointerBase)VTuneDynamicCodeObserver.this.ya.add(callNode.getStartPos()));
                        iJIT_Method_Load_V22.set_method_size(callNode.getSpan());
                        iJIT_Method_Load_V22.set_source_file_name(cCharPointerHolder2.get());
                        try (c c2 = c.a(callNode, VTuneDynamicCodeObserver.this.xY);){
                            iJIT_Method_Load_V22.set_line_number_table(c2.yi.F(0));
                            iJIT_Method_Load_V22.set_line_number_size(c2.yh);
                            Jitprofiling.iJIT_NotifyEvent(Jitprofiling.iJVM_EVENT_TYPE_METHOD_LOAD_FINISHED_V2(), iJIT_Method_Load_V22);
                        }
                        VMError.guarantee((VTuneDynamicCodeObserver.this.yb == 0 ? 1 : 0) != 0);
                        VTuneDynamicCodeObserver.this.yb = n4;
                        n2 = n4;
                        if (cCharPointerHolder2 == null) break block20;
                    }
                    catch (Throwable throwable) {
                        if (cCharPointerHolder2 != null) {
                            try {
                                cCharPointerHolder2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    cCharPointerHolder2.close();
                }
                return n2;
            }
        }

        private int a(CompilationResultFrameTree.CallNode callNode, int n2) {
            Serializable serializable;
            VTuneDynamicCodeObserver.this.xY.log("%nEmitting METHOD_LOAD_INLINE event for %s", (Object)callNode);
            if (VTuneDynamicCodeObserver.this.xY.isLogEnabled(4)) {
                serializable = new StringBuilder();
                CompilationResultFrameTree.dump((CompilationResultFrameTree.FrameNode)callNode, ((StringBuilder)serializable)::append, (boolean)false, (boolean)false, (int)1);
                VTuneDynamicCodeObserver.this.xY.log("%s", (Object)serializable);
            }
            serializable = callNode.getStackTraceElement();
            try (CTypeConversion.CCharPointerHolder cCharPointerHolder = CTypeConversion.toCString((CharSequence)VTuneDynamicCodeObserver.a(callNode));){
                int n3;
                block20: {
                    CTypeConversion.CCharPointerHolder cCharPointerHolder2 = CTypeConversion.toCString((CharSequence)VTuneDynamicCodeObserver.this.a((StackTraceElement)serializable));
                    try {
                        int n4 = SizeOf.get(Jitprofiling.iJIT_Method_Inline_Load.class);
                        Jitprofiling.iJIT_Method_Inline_Load iJIT_Method_Inline_Load2 = (Jitprofiling.iJIT_Method_Inline_Load)UnsafeStackValue.get((int)n4);
                        UnmanagedMemoryUtil.fill((Pointer)((Pointer)iJIT_Method_Inline_Load2), (UnsignedWord)WordFactory.unsigned((int)n4), (byte)0);
                        int n5 = Jitprofiling.iJIT_GetNewMethodID();
                        VMError.guarantee((n5 != 0 ? 1 : 0) != 0);
                        iJIT_Method_Inline_Load2.set_method_id(n5);
                        iJIT_Method_Inline_Load2.set_parent_method_id(n2);
                        iJIT_Method_Inline_Load2.set_method_name(cCharPointerHolder.get());
                        iJIT_Method_Inline_Load2.set_method_load_address((PointerBase)VTuneDynamicCodeObserver.this.ya.add(callNode.getStartPos()));
                        iJIT_Method_Inline_Load2.set_method_size(callNode.getSpan());
                        iJIT_Method_Inline_Load2.set_source_file_name(cCharPointerHolder2.get());
                        try (c c2 = c.a(callNode, VTuneDynamicCodeObserver.this.xY);){
                            iJIT_Method_Inline_Load2.set_line_number_table(c2.yi.F(0));
                            iJIT_Method_Inline_Load2.set_line_number_size(c2.yh);
                            Jitprofiling.iJIT_NotifyEvent(Jitprofiling.iJVM_EVENT_TYPE_METHOD_INLINE_LOAD_FINISHED(), iJIT_Method_Inline_Load2);
                        }
                        n3 = n5;
                        if (cCharPointerHolder2 == null) break block20;
                    }
                    catch (Throwable throwable) {
                        if (cCharPointerHolder2 != null) {
                            try {
                                cCharPointerHolder2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    cCharPointerHolder2.close();
                }
                return n3;
            }
        }
    }

    @RawStructure
    private static interface JITMethodHandle
    extends InstalledCodeObserver.InstalledCodeObserverHandle {
        @RawField
        public int getJitMethodID();

        @RawField
        public void setJitMethodID(int var1);
    }

    static class b
    implements InstalledCodeObserver.InstalledCodeObserverHandleAccessor {
        b() {
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void release(InstalledCodeObserver.InstalledCodeObserverHandle installedCodeObserverHandle) {
            int n2 = SizeOf.get(Jitprofiling.iJIT_Method_Load_V2.class);
            Jitprofiling.iJIT_Method_Load_V2 iJIT_Method_Load_V22 = (Jitprofiling.iJIT_Method_Load_V2)StackValue.get((int)n2);
            UnmanagedMemoryUtil.fill((Pointer)((Pointer)iJIT_Method_Load_V22), (UnsignedWord)WordFactory.unsigned((int)n2), (byte)0);
            iJIT_Method_Load_V22.set_method_id(((JITMethodHandle)installedCodeObserverHandle).getJitMethodID());
            Jitprofiling.iJIT_NotifyEvent(Jitprofiling.iJVM_EVENT_TYPE_METHOD_UNLOAD_START(), iJIT_Method_Load_V22);
            ((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).free((PointerBase)installedCodeObserverHandle);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void releaseOnTearDown(InstalledCodeObserver.InstalledCodeObserverHandle installedCodeObserverHandle) {
            this.release(installedCodeObserverHandle);
        }
    }

    private static final class c
    implements CompilationResultFrameTree.Visitor,
    AutoCloseable {
        private final CompilationResultFrameTree.CallNode yd;
        private final DebugContext ye;
        private PinnedObject yf;
        private CompilationResultFrameTree.FrameNode yg;
        int yh;
        Jitprofiling.LineNumberInfo yi;

        private c(CompilationResultFrameTree.CallNode callNode, DebugContext debugContext) {
            this.yd = callNode;
            this.ye = debugContext;
        }

        public static c a(CompilationResultFrameTree.CallNode callNode, DebugContext debugContext) {
            c c2 = new c(callNode, debugContext);
            c2.yh = 0;
            c2.yi = (Jitprofiling.LineNumberInfo)WordFactory.nullPointer();
            c2.yg = null;
            callNode.visit((CompilationResultFrameTree.Visitor)c2, new Object[0]);
            callNode.visitChildren((CompilationResultFrameTree.Visitor)c2, new Object[0]);
            int n2 = SizeOf.get(Jitprofiling.LineNumberInfo.class) * c2.yh;
            debugContext.log(" Creating %d LineNumberInfo(s) (%d bytes) for %s", (Object)c2.yh, (Object)n2, (Object)callNode);
            c2.yf = PinnedObject.create((Object)new byte[n2]);
            c2.yh = 0;
            c2.yi = (Jitprofiling.LineNumberInfo)c2.yf.addressOfArrayElement(0);
            callNode.visit((CompilationResultFrameTree.Visitor)c2, new Object[0]);
            callNode.visitChildren((CompilationResultFrameTree.Visitor)c2, new Object[0]);
            return c2;
        }

        public void apply(CompilationResultFrameTree.FrameNode frameNode, Object ... objectArray) {
            if (this.yi.isNonNull()) {
                Jitprofiling.LineNumberInfo lineNumberInfo = this.yi.F(this.yh);
                BytecodePosition bytecodePosition = frameNode.frame;
                if (frameNode != this.yd && frameNode instanceof CompilationResultFrameTree.CallNode) {
                    bytecodePosition = bytecodePosition.getCaller();
                }
                StackTraceElement stackTraceElement = CompilationResultFrameTree.SourcePositionSupplier.getStackTraceElement((BytecodePosition)bytecodePosition);
                this.ye.log("  Write LineNumberInfo entry for: %s", (Object)frameNode);
                int n2 = stackTraceElement.getLineNumber();
                lineNumberInfo.setLineNumber(n2);
                int n3 = frameNode.getEndPos() - this.yd.getStartPos();
                if (frameNode == this.yd && this.yg != null) {
                    n3 = Math.max(0, this.yg.getStartPos() - this.yd.getStartPos() - 1);
                }
                lineNumberInfo.setOffset(n3);
                this.ye.log("  LineNumberInfo lineNumber = %d, offset = %d", n2, n3);
                VMError.guarantee((n3 >= 0 ? 1 : 0) != 0, (String)"LineNumberInfo entry with negative offset makes no sense");
            } else if (frameNode != this.yd && this.yg == null) {
                this.yg = frameNode;
            }
            ++this.yh;
        }

        @Override
        public void close() {
            this.yf.close();
        }
    }

    static final class a
    implements InstalledCodeObserver.Factory {
        a() {
        }

        public InstalledCodeObserver create(DebugContext debugContext, SharedMethod sharedMethod, CompilationResult compilationResult, Pointer pointer, int n2) {
            if (compilationResult == null) {
                return null;
            }
            return new VTuneDynamicCodeObserver(debugContext, compilationResult, pointer);
        }
    }
}

