/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.profiling.features;

import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.hub.DynamicHubSupport;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.thread.ThreadListener;
import com.oracle.svm.core.thread.ThreadListenerSupport;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.core.at;
import com.oracle.svm.enterprise.hosted.ml.features.provider.a;
import com.oracle.svm.enterprise.hosted.pgo.c;
import com.oracle.svm.enterprise.hosted.phases.priorityinline.SubstratePriorityInliningPhase;
import com.oracle.svm.enterprise.profiling.k;
import com.oracle.svm.enterprise.profiling.m;
import com.oracle.svm.enterprise.profiling.metadata.b;
import com.oracle.svm.enterprise.profiling.metadata.codepositions.i;
import com.oracle.svm.enterprise.profiling.metadata.elements.d;
import com.oracle.svm.enterprise.profiling.o;
import com.oracle.svm.enterprise.profiling.profiles.ProfilingRuntimeProfile;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.c.CGlobalDataFeature;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.ReflectionUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class a
implements InternalFeature {
    public static final SubstrateOptions.OptimizationLevel xS = SubstrateOptions.OptimizationLevel.O2;

    public static boolean gg() {
        if (((Boolean)a.ProfilingEnabled.getValue()).booleanValue()) {
            if (SubstrateOptions.optimizationLevel() != xS) {
                UserError.abort((String)"Optimization level hast been set to %s, optimization levels must not be set when using %s, the VM will configure the best optimizations for PGO.", (Object[])new Object[]{SubstrateOptionsParser.commandArgument((OptionKey)SubstrateOptions.Optimize, (String)((String)SubstrateOptions.Optimize.getValue())), SubstrateOptionsParser.commandArgument(a.ProfilingEnabled, (String)"+")});
            }
            UserError.guarantee((boolean)((Boolean)GraalOptions.TrackNodeSourcePosition.getValue(HostedOptionValues.singleton())), (String)"%s is incompatible with %s", (Object[])new Object[]{SubstrateOptionsParser.commandArgument((OptionKey)GraalOptions.TrackNodeSourcePosition, (String)"-"), SubstrateOptionsParser.commandArgument(a.ProfilingEnabled, (String)"+")});
            UserError.guarantee(((Boolean)SubstrateOptions.AOTTrivialInline.getValue(HostedOptionValues.singleton()) == false ? 1 : 0) != 0, (String)"%s is incompatible with %s", (Object[])new Object[]{SubstrateOptionsParser.commandArgument((OptionKey)SubstrateOptions.AOTTrivialInline, (String)"+"), SubstrateOptionsParser.commandArgument(a.ProfilingEnabled, (String)"+")});
            return true;
        }
        return false;
    }

    private static boolean gi() {
        if (a.ProfilingEnableProfileDumpHooks.hasBeenSet()) {
            return (Boolean)a.ProfilingEnableProfileDumpHooks.getValue();
        }
        return ImageInfo.isExecutable();
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return List.of(CGlobalDataFeature.class);
    }

    public void registerForeignCalls(SubstrateForeignCallsProvider substrateForeignCallsProvider) {
        substrateForeignCallsProvider.register(m.yt);
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess isInConfigurationAccess) {
        return a.gg();
    }

    public void afterRegistration(Feature.AfterRegistrationAccess afterRegistrationAccess) {
        ImageSingletons.add(ProfilingRuntimeProfile.class, (Object)new ProfilingRuntimeProfile());
        ImageSingletons.add(b.class, (Object)new b());
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess beforeAnalysisAccess) {
        RuntimeSupport runtimeSupport;
        ProfilingRuntimeProfile profilingRuntimeProfile = ProfilingRuntimeProfile.instance();
        b b2 = ProfilingRuntimeProfile.metadataBuilder();
        if (a.gi()) {
            runtimeSupport = RuntimeSupport.getRuntimeSupport();
            runtimeSupport.addStartupHook(profilingRuntimeProfile.dumpStartupHook());
            runtimeSupport.addShutdownHook(profilingRuntimeProfile.dumpShutdownHook());
        }
        b2.b(new d());
        b2.a(new com.oracle.svm.enterprise.profiling.metadata.elements.c());
        runtimeSupport = (FeatureImpl.BeforeAnalysisAccessImpl)beforeAnalysisAccess;
        AnalysisMetaAccess analysisMetaAccess = runtimeSupport.getMetaAccess();
        Iterator iterator = Stream.of("hashCode", "toString", "wait", "notify").map(string -> ReflectionUtil.lookupMethod(Object.class, (String)string, (Class[])new Class[0])).map(arg_0 -> ((AnalysisMetaAccess)analysisMetaAccess).lookupJavaMethod(arg_0)).iterator();
        NodeSourcePosition nodeSourcePosition = new NodeSourcePosition(null, (ResolvedJavaMethod)iterator.next(), 0);
        b2.a(m.a(nodeSourcePosition, b2::e), (byte)0, 0, false);
        b2.a(m.a(new NodeSourcePosition(nodeSourcePosition, (ResolvedJavaMethod)iterator.next(), 0), (Integer n2, Integer n3) -> b2.a((int)n2, (int)n3, new int[]{0, 1}, new int[]{0, 1})), (byte)0, 0, false);
        b2.a(m.a(new NodeSourcePosition(nodeSourcePosition, (ResolvedJavaMethod)iterator.next(), 0), (Integer n2, Integer n3) -> b2.a((int)n2, (int)n3, new ResolvedJavaType[0])), (byte)0, 0, false);
        b2.a(m.a(new NodeSourcePosition(nodeSourcePosition, (ResolvedJavaMethod)iterator.next(), 0), (Integer n2, Integer n3) -> new i(0, 0)), (byte)0, 0, false);
        profilingRuntimeProfile.data().gJ();
        profilingRuntimeProfile.setMetadata(b2.gV());
        for (SnippetRuntime.SubstrateForeignCallDescriptor substrateForeignCallDescriptor : m.yt) {
            runtimeSupport.registerAsRoot((AnalysisMethod)substrateForeignCallDescriptor.findMethod((MetaAccessProvider)analysisMetaAccess), true, "Profiling support, registered in " + String.valueOf(a.class), new MultiMethod.MultiMethodKey[0]);
        }
        if (!((Boolean)SubstrateOptions.MultiThreaded.getValue()).booleanValue()) {
            LogUtils.warning((String)"Single-threaded VM cannot use signals to trigger profile dumping.");
        }
        ThreadListenerSupport.get().register((ThreadListener)new k());
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess afterAnalysisAccess) {
        ProfilingRuntimeProfile.instance().reset();
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess beforeCompilationAccess) {
        int n2 = ((DynamicHubSupport)ImageSingletons.lookup(DynamicHubSupport.class)).getMaxTypeId();
        VMError.guarantee((n2 > 0 ? 1 : 0) != 0, (String)"Max type ID should be positive.");
        int n3 = ProfilingRuntimeProfile.instance().data().c(n2, false);
        VMError.guarantee((n3 == 0 ? 1 : 0) != 0, (String)"The monitor record should be in the beginning of the data storage.");
        b b2 = ProfilingRuntimeProfile.metadataBuilder();
        b2.d(n2, n3);
        if (a.ProfilingPackagePrefixes.hasBeenSet()) {
            Set set = Arrays.stream(((String)a.ProfilingPackagePrefixes.getValue()).split(",")).map(string -> string.split("\\.")).map(Arrays::asList).collect(Collectors.toSet());
            Set<String> set2 = ((FeatureImpl.BeforeCompilationAccessImpl)beforeCompilationAccess).getUniverse().getTypes().stream().filter(hostedType -> a.a(hostedType, set)).map(JavaType::toClassName).collect(Collectors.toSet());
            b2.g(set2);
        }
    }

    public void afterCompilation(Feature.AfterCompilationAccess afterCompilationAccess) {
        b b2 = ProfilingRuntimeProfile.metadataBuilder();
        HostedUniverse hostedUniverse = ((FeatureImpl.AfterCompilationAccessImpl)afterCompilationAccess).getUniverse();
        Set<HostedMethod> set = a.a(hostedUniverse, b2.gU());
        Set<HostedType> set2 = a.a(hostedUniverse, b2, set);
        b2.b(a.e(set));
        b2.a(a.f(set2));
        ProfilingRuntimeProfile.instance().setMetadata(b2.gV());
    }

    private static boolean a(HostedType hostedType, Set<List<String>> set) {
        if (hostedType.isPrimitive() || hostedType.isArray() && hostedType.getBaseType().isPrimitive()) {
            return true;
        }
        List<String> list = a.b(hostedType);
        return set.stream().anyMatch(list2 -> a.b(list, list2));
    }

    private static List<String> b(HostedType hostedType) {
        String[] stringArray = hostedType.toJavaName().split("\\.");
        return Arrays.asList(Arrays.copyOf(stringArray, stringArray.length - 1));
    }

    private static boolean b(List<String> list, List<String> list2) {
        if (list2.size() > list.size()) {
            return false;
        }
        return list.subList(0, list2.size()).equals(list2);
    }

    private static Set<HostedMethod> a(HostedUniverse hostedUniverse, Set<String> set) {
        if (o.isSamplingActive()) {
            return new HashSet<HostedMethod>(hostedUniverse.getMethods());
        }
        Map<Integer, HostedMethod> map = hostedUniverse.getMethods().stream().collect(Collectors.toMap(hostedMethod -> hostedMethod.getWrapped().getId(), hostedMethod -> hostedMethod));
        return set.stream().flatMap(string -> a.a(string, map)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static Stream<HostedMethod> a(String string2, Map<Integer, HostedMethod> map) {
        return Arrays.stream(m.O(string2)).map(string -> (HostedMethod)map.get(m.N(string).getLeft()));
    }

    private static com.oracle.svm.enterprise.profiling.metadata.elements.b<com.oracle.svm.enterprise.profiling.metadata.elements.c> e(Set<? extends ResolvedJavaMethod> set) {
        return new com.oracle.svm.enterprise.profiling.metadata.elements.b<com.oracle.svm.enterprise.profiling.metadata.elements.c>(set.stream().map(resolvedJavaMethod -> {
            ResolvedJavaType resolvedJavaType = resolvedJavaMethod.getDeclaringClass();
            int[] nArray = Arrays.stream(resolvedJavaMethod.getSignature().toParameterTypes(null)).map(javaType -> javaType.resolve(resolvedJavaType)).mapToInt(m::i).toArray();
            int n2 = m.i(resolvedJavaMethod.getSignature().getReturnType(resolvedJavaType).resolve(resolvedJavaType));
            return new com.oracle.svm.enterprise.profiling.metadata.elements.c(m.i(resolvedJavaMethod), resolvedJavaMethod.getName(), m.i(resolvedJavaType), n2, nArray);
        }).collect(Collectors.toList()));
    }

    private static Set<HostedType> a(HostedUniverse hostedUniverse, b b2, Set<HostedMethod> set) {
        Set<HostedType> set2 = hostedUniverse.getTypes().stream().filter(hostedType -> c.d(hostedType.getWrapped())).filter(hostedType -> b2.R(hostedType.toClassName())).collect(Collectors.toSet());
        Set set3 = set.stream().flatMap(a::z).collect(Collectors.toSet());
        a.a(set, b2);
        set2.addAll(set3);
        return set2;
    }

    private static void a(Set<HostedMethod> set2, b b2) {
        HashMap<HostedMethod, Set<String>> hashMap = new HashMap<HostedMethod, Set<String>>();
        HashSet<String> hashSet = new HashSet<String>();
        a.a(set2, b2, hashMap, hashSet);
        if (!hashMap.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder("Incomplete partial profiling. We profile forbidden types (types that do not match the profiling package prefixes):").append(System.lineSeparator());
            hashMap.forEach((hostedMethod, set) -> stringBuilder.append(hostedMethod.format("%H.%n")).append(" -> ").append(String.join((CharSequence)", ", set)).append(System.lineSeparator()));
            stringBuilder.append("Consider expanding your filter by including the packages:").append(System.lineSeparator()).append("-H:ProfilingPackagePrefixes=").append(String.join((CharSequence)",", hashSet));
            LogUtils.warning((String)stringBuilder.toString());
        }
    }

    private static void a(Set<HostedMethod> set, b b2, Map<HostedMethod, Set<String>> map, Set<String> set2) {
        for (HostedMethod hostedMethod : set) {
            Set<HostedType> set3 = a.z(hostedMethod).filter(hostedType -> !b2.R(hostedType.toClassName())).collect(Collectors.toSet());
            a.a(hostedMethod, set3, map, set2);
        }
    }

    private static void a(HostedMethod hostedMethod, Set<HostedType> set, Map<HostedMethod, Set<String>> map, Set<String> set2) {
        for (HostedType hostedType : set) {
            String string;
            map.putIfAbsent(hostedMethod, new HashSet());
            map.get(hostedMethod).add(hostedType.toClassName());
            String string2 = string = hostedType.isArray() ? hostedType.getBaseType().toClassName() : hostedType.toClassName();
            if (string.contains(".")) {
                string = string.substring(0, string.lastIndexOf("."));
            }
            set2.add(string);
        }
    }

    private static Stream<HostedType> z(HostedMethod hostedMethod) {
        HostedType hostedType = hostedMethod.getDeclaringClass();
        Stream<HostedType> stream = Stream.of(hostedType, (HostedType)hostedMethod.getSignature().getReturnType((ResolvedJavaType)hostedType).resolve((ResolvedJavaType)hostedType));
        Stream<HostedType> stream2 = Arrays.stream(hostedMethod.getSignature().toParameterTypes(null)).map(javaType -> (HostedType)javaType.resolve((ResolvedJavaType)hostedType));
        return Stream.concat(stream, stream2);
    }

    private static com.oracle.svm.enterprise.profiling.metadata.elements.b<d> f(Set<HostedType> set) {
        return new com.oracle.svm.enterprise.profiling.metadata.elements.b<d>(set.stream().map(hostedType -> new d(m.i((ResolvedJavaType)hostedType), hostedType.toClassName())).collect(Collectors.toList()));
    }

    public static class a {
        @APIOption(name={"pgo-instrument"})
        public static final HostedOptionKey<Boolean> ProfilingEnabled = new HostedOptionKey<Boolean>(Boolean.valueOf(false)){

            protected void a(EconomicMap<OptionKey<?>, Object> economicMap, Boolean bl2, Boolean bl3) {
                if (bl3.booleanValue()) {
                    Object object = economicMap.get((Object)SubstrateOptions.Optimize);
                    if (object != null) {
                        if (!object.equals("2")) {
                            SubstrateOptions.Optimize.update(economicMap, (Object)xS.getOptionSwitch());
                        }
                        GraalOptions.TrackNodeSourcePosition.update(economicMap, GraalOptions.TrackNodeSourcePosition.getDefaultValue());
                        SubstrateOptions.IncludeNodeSourcePositions.update(economicMap, SubstrateOptions.IncludeNodeSourcePositions.getDefaultValue());
                        SubstrateOptions.SourceLevelDebug.update(economicMap, SubstrateOptions.SourceLevelDebug.getDefaultValue());
                        SubstrateOptions.AOTTrivialInline.update(economicMap, SubstrateOptions.AOTTrivialInline.getDefaultValue());
                    }
                    SubstrateOptions.InstallExitHandlers.update(economicMap, (Object)true);
                    GraalOptions.TrackNodeSourcePosition.update(economicMap, (Object)true);
                    SubstrateOptions.AOTTrivialInline.update(economicMap, (Object)false);
                    at.AOTPriorityInline.update(economicMap, (Object)true);
                    SubstratePriorityInliningPhase.a.UseIPEA.update(economicMap, (Object)false);
                    o.a.SamplingCollect.update(economicMap, (Object)true);
                    a.a.MLProfileInference.update(economicMap, (Object)false);
                }
            }

            protected /* synthetic */ void onValueUpdate(EconomicMap economicMap, Object object, Object object2) {
                this.a(economicMap, (Boolean)object, (Boolean)object2);
            }
        };
        static final HostedOptionKey<Boolean> ProfilingEnableProfileDumpHooks = new HostedOptionKey((Object)Boolean.TRUE);
        public static final HostedOptionKey<String> ProfilingPackagePrefixes = new HostedOptionKey(null);
    }
}

