/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.code.layout;

import com.oracle.svm.core.nodes.SubstrateMethodCallTargetNode;
import com.oracle.svm.enterprise.hosted.code.layout.a;
import com.oracle.svm.enterprise.hosted.pgo.profiles.PGOProfilesLookup;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.ArrayList;
import java.util.function.Function;
import jdk.vm.ci.meta.JavaMethodProfile;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.core.common.cfg.AbstractControlFlowGraph;
import org.graalvm.compiler.core.common.cfg.BasicBlock;
import org.graalvm.compiler.core.common.cfg.BlockMap;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.cfg.HIRBlock;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.BasePhase;

public class CalculateCallEdgeCountPhase
extends BasePhase<CoreProviders> {
    final PGOProfilesLookup qD;
    final a qE;

    public CalculateCallEdgeCountPhase(PGOProfilesLookup pGOProfilesLookup, a a2) {
        this.qD = pGOProfilesLookup;
        this.qE = a2;
    }

    protected void run(StructuredGraph structuredGraph, CoreProviders coreProviders) {
        HostedMethod hostedMethod = (HostedMethod)structuredGraph.method();
        assert (this.qE.g(hostedMethod)) : "Caller-callee count should not be overwritten: double entry for " + String.valueOf(hostedMethod);
        if (!this.qD.isProfiled(hostedMethod)) {
            return;
        }
        ControlFlowGraph controlFlowGraph = CalculateCallEdgeCountPhase.d(structuredGraph);
        Function<HIRBlock, Iterable<? extends Node>> function = CalculateCallEdgeCountPhase.a(controlFlowGraph);
        EconomicMap economicMap = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        for (HIRBlock hIRBlock : controlFlowGraph.getBlocks()) {
            double d2 = hIRBlock.getRelativeFrequency();
            for (Node node : function.apply(hIRBlock)) {
                if (!(node instanceof Invoke)) continue;
                long l2 = this.qD.getCallCountProfile(hostedMethod).map(PGOProfilesLookup.a::fk).orElse(0L);
                this.a((Invoke)node, (EconomicMap<HostedMethod, Long>)economicMap, l2, d2);
            }
        }
        this.qE.a(hostedMethod, (EconomicMap<HostedMethod, Long>)economicMap);
    }

    private static ControlFlowGraph d(StructuredGraph structuredGraph) {
        if (structuredGraph.getLastSchedule() == null) {
            return ControlFlowGraph.compute((StructuredGraph)structuredGraph, (boolean)true, (boolean)true, (boolean)false, (boolean)false);
        }
        return structuredGraph.getLastSchedule().getCFG();
    }

    private static Function<HIRBlock, Iterable<? extends Node>> a(ControlFlowGraph controlFlowGraph) {
        BlockMap blockMap = new BlockMap((AbstractControlFlowGraph)controlFlowGraph);
        for (HIRBlock hIRBlock : controlFlowGraph.getBlocks()) {
            ArrayList<FixedNode> arrayList = new ArrayList<FixedNode>();
            for (FixedNode fixedNode : hIRBlock.getNodes()) {
                arrayList.add(fixedNode);
            }
            blockMap.put((BasicBlock)hIRBlock, arrayList);
        }
        return arg_0 -> ((BlockMap)blockMap).get(arg_0);
    }

    private void a(Invoke invoke, EconomicMap<HostedMethod, Long> economicMap, long l2, double d2) {
        if (invoke.callTarget() == null) {
            return;
        }
        if (invoke.getInvokeKind().isDirect()) {
            this.b(invoke, economicMap, l2, d2);
        } else {
            this.c(invoke, economicMap, l2, d2);
        }
    }

    private void b(Invoke invoke, EconomicMap<HostedMethod, Long> economicMap, long l2, double d2) {
        if (invoke.getTargetMethod() == null) {
            return;
        }
        HostedMethod hostedMethod = (HostedMethod)invoke.getTargetMethod();
        this.a(hostedMethod, economicMap, l2, d2, 1.0);
    }

    private void c(Invoke invoke, EconomicMap<HostedMethod, Long> economicMap, long l2, double d2) {
        JavaMethodProfile.ProfiledMethod[] profiledMethodArray = invoke.callTarget();
        if (profiledMethodArray instanceof SubstrateMethodCallTargetNode) {
            SubstrateMethodCallTargetNode substrateMethodCallTargetNode = (SubstrateMethodCallTargetNode)profiledMethodArray;
            if (substrateMethodCallTargetNode.getMethodProfile() == null) {
                return;
            }
            for (JavaMethodProfile.ProfiledMethod profiledMethod : substrateMethodCallTargetNode.getMethodProfile().getMethods()) {
                HostedMethod hostedMethod = (HostedMethod)profiledMethod.getMethod();
                this.a(hostedMethod, economicMap, l2, d2, profiledMethod.getProbability());
            }
        }
    }

    private void a(HostedMethod hostedMethod, EconomicMap<HostedMethod, Long> economicMap, long l2, double d2, double d3) {
        long l3 = this.qD.getCallCountProfile(hostedMethod).map(PGOProfilesLookup.a::fk).orElse(0L);
        if (l3 == 0L) {
            return;
        }
        long l4 = Math.round((double)l2 * d2 * d3);
        if (l4 > 0L) {
            Long l5 = (Long)economicMap.get((Object)hostedMethod, (Object)0L);
            economicMap.put((Object)hostedMethod, (Object)(l5 + l4));
        }
    }
}

