/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.gc.g1;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.graal.RuntimeCompilation;
import com.oracle.svm.core.graal.nodes.WriteCurrentVMThreadNode;
import com.oracle.svm.core.graal.snippets.CEntryPointSnippets;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.heap.StoredContinuationAccess;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.ParameterizedStackFrameVisitor;
import com.oracle.svm.core.thread.Continuation;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.core.at;
import com.oracle.svm.enterprise.gc.g1.bv;
import com.oracle.svm.enterprise.gc.g1.bw;
import com.oracle.svm.enterprise.gc.g1.nativelib.SharedGCStructs;
import java.util.function.BooleanSupplier;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.impl.UnmanagedMemorySupport;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class G1StackWalker {
    private static final e nO = new e();
    private static final c nP = new c();
    private static final a nQ = new a();
    public final CEntryPointLiteral<CFunctionPointer> nR = CEntryPointLiteral.create(G1StackWalker.class, (String)"fetchThreadStackFrames", (Class[])new Class[]{PointerBase.class, IsolateThread.class});
    public final CEntryPointLiteral<CFunctionPointer> nS = CEntryPointLiteral.create(G1StackWalker.class, (String)"freeThreadStackFrames", (Class[])new Class[]{PointerBase.class, IsolateThread.class, SharedGCStructs.StackFramesPerThread.class});
    public final CEntryPointLiteral<CFunctionPointer> nT = Continuation.isSupported() ? CEntryPointLiteral.create(G1StackWalker.class, (String)"fetchContinuationStackFrames", (Class[])new Class[]{PointerBase.class, Pointer.class}) : null;
    public final CEntryPointLiteral<CFunctionPointer> nU = Continuation.isSupported() ? CEntryPointLiteral.create(G1StackWalker.class, (String)"freeContinuationStackFrames", (Class[])new Class[]{PointerBase.class, SharedGCStructs.StackFrames.class}) : null;
    public final CEntryPointLiteral<CFunctionPointer> nV = RuntimeCompilation.isEnabled() ? CEntryPointLiteral.create(G1StackWalker.class, (String)"fetchCodeInfos", (Class[])new Class[]{PointerBase.class, IsolateThread.class}) : null;
    public final CEntryPointLiteral<CFunctionPointer> nW = RuntimeCompilation.isEnabled() ? CEntryPointLiteral.create(G1StackWalker.class, (String)"freeCodeInfos", (Class[])new Class[]{PointerBase.class, IsolateThread.class, SharedGCStructs.CodeInfosPerThread.class}) : null;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public G1StackWalker() {
    }

    @Uninterruptible(reason="G1 may only call uninterruptible code.")
    @CEntryPoint(include=bw.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=bv.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    public static SharedGCStructs.StackFramesPerThread fetchThreadStackFrames(PointerBase pointerBase, IsolateThread isolateThread) {
        return G1StackWalker.a(nO);
    }

    @Uninterruptible(reason="G1 may only call uninterruptible code.")
    @CEntryPoint(include=bw.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=bv.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    public static void freeThreadStackFrames(PointerBase pointerBase, IsolateThread isolateThread, SharedGCStructs.StackFramesPerThread stackFramesPerThread) {
        int n2 = 0;
        while ((long)n2 < stackFramesPerThread.count()) {
            ((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).free((PointerBase)stackFramesPerThread.threads().i(n2).di());
            ++n2;
        }
        ((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).free((PointerBase)stackFramesPerThread);
    }

    @Uninterruptible(reason="May be called by a non-Java thread (at or outside a safepoint).")
    @CEntryPoint(include=f.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=d.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    public static SharedGCStructs.StackFrames fetchContinuationStackFrames(PointerBase pointerBase, Pointer pointer) {
        StoredContinuation storedContinuation = (StoredContinuation)pointer.toObject();
        ContinuationStackFrameCollectorData continuationStackFrameCollectorData = (ContinuationStackFrameCollectorData)StackValue.get(ContinuationStackFrameCollectorData.class);
        c.a(continuationStackFrameCollectorData);
        StoredContinuationAccess.walkFrames((StoredContinuation)storedContinuation, (StoredContinuationAccess.ContinuationStackFrameVisitor)nP, (StoredContinuationAccess.ContinuationStackFrameVisitorData)continuationStackFrameCollectorData);
        return continuationStackFrameCollectorData.getStack();
    }

    @Uninterruptible(reason="May be called by a non-Java thread (at or outside a safepoint).")
    @CEntryPoint(include=f.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=d.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    public static void freeContinuationStackFrames(PointerBase pointerBase, SharedGCStructs.StackFrames stackFrames) {
        ((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).free((PointerBase)stackFrames);
    }

    @Uninterruptible(reason="G1 may only call uninterruptible code.")
    @CEntryPoint(include=bw.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=bv.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    public static SharedGCStructs.CodeInfosPerThread fetchCodeInfos(PointerBase pointerBase, IsolateThread isolateThread) {
        return G1StackWalker.a(nQ);
    }

    @Uninterruptible(reason="G1 may only call uninterruptible code.")
    @CEntryPoint(include=bw.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=bv.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    public static void freeCodeInfos(PointerBase pointerBase, IsolateThread isolateThread, SharedGCStructs.CodeInfosPerThread codeInfosPerThread) {
        int n2 = 0;
        while ((long)n2 < codeInfosPerThread.count()) {
            ((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).free((PointerBase)codeInfosPerThread.threads().f(n2).dh());
            ++n2;
        }
        ((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).free((PointerBase)codeInfosPerThread);
    }

    @NeverInline(value="Stack walking.")
    @Uninterruptible(reason="G1 may only call uninterruptible code.")
    private static <T extends PointerBase, U extends PointerBase> T a(b<T, U> b2) {
        VMOperation.guaranteeInProgressAtSafepoint((String)"Doing a stack walk for every thread is only possible when we are at a safepoint.");
        b2.cL();
        b2.cM();
        JavaStackWalker.walkCurrentThread((Pointer)KnownIntrinsics.readCallerStackPointer(), b2, null);
        b2.cN();
        IsolateThread isolateThread = VMThreads.firstThread();
        while (isolateThread.isNonNull()) {
            if (isolateThread != CurrentIsolate.getCurrentThread()) {
                b2.cM();
                JavaStackWalker.walkThread((IsolateThread)isolateThread, b2, null);
                b2.cN();
            }
            isolateThread = VMThreads.nextThread((IsolateThread)isolateThread);
        }
        return b2.cQ();
    }

    @Uninterruptible(reason="G1 may only call uninterruptible code.")
    private static <V extends PointerBase> V e(UnsignedWord unsignedWord) {
        PointerBase pointerBase = ((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).malloc(unsignedWord);
        if (pointerBase.isNull()) {
            throw VMError.shouldNotReachHere((String)"malloc returned null.");
        }
        return (V)pointerBase;
    }

    @Uninterruptible(reason="G1 may only call uninterruptible code.")
    private static <V extends PointerBase> V a(V v2, UnsignedWord unsignedWord) {
        PointerBase pointerBase = ((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).realloc(v2, unsignedWord);
        if (pointerBase.isNull()) {
            throw VMError.shouldNotReachHere((String)"realloc returned null.");
        }
        return (V)pointerBase;
    }

    private static class e
    extends b<SharedGCStructs.StackFramesPerThread, SharedGCStructs.StackFrames> {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        e() {
        }

        @Override
        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public void cL() {
            assert (((SharedGCStructs.StackFramesPerThread)this.nZ).isNull() && this.oa == 0 && ((SharedGCStructs.StackFrames)this.ob).isNull() && this.oc == 0);
            this.oa = 5;
            this.nZ = G1StackWalker.e(this.cR());
            ((SharedGCStructs.StackFramesPerThread)this.nZ).setCount(0L);
        }

        @Override
        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public void cM() {
            assert (((SharedGCStructs.StackFrames)this.ob).isNull() && this.oc == 0);
            this.oc = 10;
            this.ob = G1StackWalker.e(this.cS());
            ((SharedGCStructs.StackFrames)this.ob).setCount(0L);
        }

        @Override
        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public void cN() {
            long l2 = ((SharedGCStructs.StackFramesPerThread)this.nZ).count();
            if (l2 == (long)this.oa) {
                this.oa *= 2;
                this.nZ = G1StackWalker.a((SharedGCStructs.StackFramesPerThread)this.nZ, this.cR());
            }
            ((SharedGCStructs.StackFramesPerThread)this.nZ).threads().i(l2).a((SharedGCStructs.StackFrames)this.ob);
            ((SharedGCStructs.StackFramesPerThread)this.nZ).setCount(l2 + 1L);
            this.ob = WordFactory.nullPointer();
            this.oc = 0;
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public boolean visitFrame(Pointer pointer, CodePointer codePointer, CodeInfo codeInfo, DeoptimizedFrame deoptimizedFrame, Object object) {
            if (deoptimizedFrame != null) {
                return true;
            }
            NonmovableArray nonmovableArray = CodeInfoAccess.getStackReferenceMapEncoding((CodeInfo)codeInfo);
            long l2 = CodeInfoAccess.lookupStackReferenceMapIndex((CodeInfo)codeInfo, (long)CodeInfoAccess.relativeIP((CodeInfo)codeInfo, (CodePointer)codePointer));
            this.a(pointer, (NonmovableArray<Byte>)nonmovableArray, l2);
            return true;
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        private void a(Pointer pointer, NonmovableArray<Byte> nonmovableArray, long l2) {
            long l3 = ((SharedGCStructs.StackFrames)this.ob).count();
            if (l3 == (long)this.oc) {
                this.oc *= 2;
                this.ob = G1StackWalker.a((SharedGCStructs.StackFrames)this.ob, this.cS());
            }
            SharedGCStructs.StackFrame stackFrame = ((SharedGCStructs.StackFrames)this.ob).frames().h(l3);
            stackFrame.setStackPointer(pointer);
            stackFrame.setEncodedReferenceMap((CCharPointer)NonmovableArrays.getArrayBase(nonmovableArray));
            stackFrame.setReferenceMapIndex(l2);
            ((SharedGCStructs.StackFrames)this.ob).setCount(l3 + 1L);
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        private UnsignedWord cR() {
            return SizeOf.unsigned(SharedGCStructs.StackFramesPerThread.class).add(SizeOf.unsigned(SharedGCStructs.StackFrames.class).multiply(this.oa));
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        private UnsignedWord cS() {
            return SizeOf.unsigned(SharedGCStructs.StackFrames.class).add(SizeOf.unsigned(SharedGCStructs.StackFrame.class).multiply(this.oc));
        }
    }

    private static abstract class b<T extends PointerBase, U extends PointerBase>
    extends ParameterizedStackFrameVisitor {
        protected static final int nX = 5;
        protected static final int nY = 10;
        protected T nZ;
        protected int oa;
        protected U ob;
        protected int oc;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        b() {
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public abstract void cL();

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public abstract void cM();

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public abstract void cN();

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public T cQ() {
            assert (this.ob.isNull());
            assert (this.oc == 0);
            T t2 = this.nZ;
            this.nZ = WordFactory.nullPointer();
            this.oa = 0;
            return t2;
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        protected final boolean unknownFrame(Pointer pointer, CodePointer codePointer, DeoptimizedFrame deoptimizedFrame, Object object) {
            throw JavaStackWalker.reportUnknownFrameEncountered((Pointer)pointer, (CodePointer)codePointer, (DeoptimizedFrame)deoptimizedFrame);
        }
    }

    @RawStructure
    private static interface ContinuationStackFrameCollectorData
    extends StoredContinuationAccess.ContinuationStackFrameVisitorData {
        @RawField
        public int getCapacity();

        @RawField
        public void setCapacity(int var1);

        @RawField
        public SharedGCStructs.StackFrames getStack();

        @RawField
        public void setStack(SharedGCStructs.StackFrames var1);
    }

    private static class c
    extends StoredContinuationAccess.ContinuationStackFrameVisitor {
        private static final int od = 10;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        c() {
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public static void a(ContinuationStackFrameCollectorData continuationStackFrameCollectorData) {
            UnsignedWord unsignedWord = c.q(10);
            SharedGCStructs.StackFrames stackFrames = (SharedGCStructs.StackFrames)G1StackWalker.e(unsignedWord);
            stackFrames.setCount(0L);
            continuationStackFrameCollectorData.setStack(stackFrames);
            continuationStackFrameCollectorData.setCapacity(10);
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public void visitFrame(StoredContinuationAccess.ContinuationStackFrameVisitorData continuationStackFrameVisitorData, Pointer pointer, NonmovableArray<Byte> nonmovableArray, long l2, StoredContinuationAccess.ContinuationStackFrameVisitor continuationStackFrameVisitor) {
            Object object;
            ContinuationStackFrameCollectorData continuationStackFrameCollectorData = (ContinuationStackFrameCollectorData)continuationStackFrameVisitorData;
            long l3 = continuationStackFrameCollectorData.getStack().count();
            if (l3 == (long)continuationStackFrameCollectorData.getCapacity()) {
                int n2 = continuationStackFrameCollectorData.getCapacity() * 2;
                object = G1StackWalker.a(continuationStackFrameCollectorData.getStack(), c.q(n2));
                continuationStackFrameCollectorData.setStack((SharedGCStructs.StackFrames)object);
                continuationStackFrameCollectorData.setCapacity(n2);
            }
            SharedGCStructs.StackFrames stackFrames = continuationStackFrameCollectorData.getStack();
            object = stackFrames.frames().h(l3);
            object.setStackPointer(pointer);
            object.setEncodedReferenceMap((CCharPointer)NonmovableArrays.getArrayBase(nonmovableArray));
            object.setReferenceMapIndex(l2);
            stackFrames.setCount(l3 + 1L);
        }

        @Uninterruptible(reason="G1 may only execute uninterruptible code.")
        private static UnsignedWord q(int n2) {
            return SizeOf.unsigned(SharedGCStructs.StackFrames.class).add(SizeOf.unsigned(SharedGCStructs.StackFrame.class).multiply(n2));
        }
    }

    private static class a
    extends b<SharedGCStructs.CodeInfosPerThread, SharedGCStructs.CodeInfos> {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        a() {
        }

        @Override
        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public void cL() {
            assert (((SharedGCStructs.CodeInfosPerThread)this.nZ).isNull() && this.oa == 0 && ((SharedGCStructs.CodeInfos)this.ob).isNull() && this.oc == 0);
            this.oa = 5;
            this.nZ = G1StackWalker.e(this.cO());
            ((SharedGCStructs.CodeInfosPerThread)this.nZ).setCount(0L);
        }

        @Override
        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public void cM() {
            assert (((SharedGCStructs.CodeInfos)this.ob).isNull() && this.oc == 0);
            this.oc = 10;
            this.ob = G1StackWalker.e(this.cP());
            ((SharedGCStructs.CodeInfos)this.ob).setCount(0L);
        }

        @Override
        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public void cN() {
            long l2 = ((SharedGCStructs.CodeInfosPerThread)this.nZ).count();
            if (l2 == (long)this.oa) {
                this.oa *= 2;
                this.nZ = G1StackWalker.a((SharedGCStructs.CodeInfosPerThread)this.nZ, this.cO());
            }
            ((SharedGCStructs.CodeInfosPerThread)this.nZ).threads().f(l2).a((SharedGCStructs.CodeInfos)this.ob);
            ((SharedGCStructs.CodeInfosPerThread)this.nZ).setCount(l2 + 1L);
            this.ob = WordFactory.nullPointer();
            this.oc = 0;
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public boolean visitFrame(Pointer pointer, CodePointer codePointer, CodeInfo codeInfo, DeoptimizedFrame deoptimizedFrame, Object object) {
            if (deoptimizedFrame == null && codeInfo.notEqual((ComparableWord)CodeInfoTable.getImageCodeInfo())) {
                this.d(codeInfo);
            }
            return true;
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        private void d(CodeInfo codeInfo) {
            long l2 = ((SharedGCStructs.CodeInfos)this.ob).count();
            if (l2 == (long)this.oc) {
                this.oc *= 2;
                this.ob = G1StackWalker.a((SharedGCStructs.CodeInfos)this.ob, this.cP());
            }
            ((SharedGCStructs.CodeInfos)this.ob).codeInfos().addressOf(l2).write(codeInfo);
            ((SharedGCStructs.CodeInfos)this.ob).setCount(l2 + 1L);
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        private UnsignedWord cO() {
            return SizeOf.unsigned(SharedGCStructs.StackFramesPerThread.class).add(SizeOf.unsigned(SharedGCStructs.StackFrames.class).multiply(this.oa));
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        private UnsignedWord cP() {
            return SizeOf.unsigned(SharedGCStructs.StackFrames.class).add(SizeOf.unsigned(SharedGCStructs.StackFrame.class).multiply(this.oc));
        }
    }

    private static class f
    implements BooleanSupplier {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        f() {
        }

        @Override
        public boolean getAsBoolean() {
            return (Boolean)at.UseG1GC.getValue() != false && Continuation.isSupported();
        }
    }

    private static class d
    implements CEntryPointOptions.Prologue {
        private d() {
        }

        @Uninterruptible(reason="prologue")
        public static void b(PointerBase pointerBase) {
            CEntryPointSnippets.setHeapBase((PointerBase)pointerBase);
            WriteCurrentVMThreadNode.writeCurrentVMThread((IsolateThread)((IsolateThread)WordFactory.nullPointer()));
        }
    }
}

