/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core.sboutlining.concat;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.JavaLangSubstitutions;
import com.oracle.svm.util.ReflectionUtil;
import jdk.internal.misc.Unsafe;

public final class SubstrateStringConcatHelper {
    static final long lI = (long)a.lN << 32;
    static final long lJ = (long)a.lM << 32;
    private static final Unsafe lK = Unsafe.getUnsafe();

    private SubstrateStringConcatHelper() {
    }

    private static long c(long l2) {
        if ((int)l2 >= 0) {
            return l2;
        }
        throw new OutOfMemoryError("Overflow: String length out of range");
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static long mix(long l2, boolean bl2) {
        return SubstrateStringConcatHelper.c(l2 + (long)(bl2 ? 4 : 5));
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static long mix(long l2, byte by) {
        return SubstrateStringConcatHelper.mix(l2, (int)by);
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static long mix(long l2, char c2) {
        return SubstrateStringConcatHelper.c(l2 + 1L) | (Target_java_lang_StringLatin1.canEncode(c2) ? 0L : lJ);
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static long mix(long l2, short s2) {
        return SubstrateStringConcatHelper.mix(l2, (int)s2);
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static long mix(long l2, int n2) {
        return SubstrateStringConcatHelper.c(l2 + (long)Target_java_lang_Integer.stringSize(n2));
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static long mix(long l2, long l3) {
        return SubstrateStringConcatHelper.c(l2 + (long)Target_java_lang_Long.stringSize(l3));
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static long mix(long l2, String string) {
        l2 += (long)string.length();
        if (JavaLangSubstitutions.StringUtil.coder((String)string) == a.lM) {
            l2 |= lJ;
        }
        return SubstrateStringConcatHelper.c(l2);
    }

    @com.oracle.svm.enterprise.core.annotate.a
    private static long prepend(long l2, byte[] byArray, boolean bl2) {
        int n2 = (int)l2;
        if (l2 < lJ) {
            if (bl2) {
                byArray[--n2] = 101;
                byArray[--n2] = 117;
                byArray[--n2] = 114;
                byArray[--n2] = 116;
            } else {
                byArray[--n2] = 101;
                byArray[--n2] = 115;
                byArray[--n2] = 108;
                byArray[--n2] = 97;
                byArray[--n2] = 102;
            }
            return n2;
        }
        if (bl2) {
            Target_java_lang_StringUTF16.putChar(byArray, --n2, 101);
            Target_java_lang_StringUTF16.putChar(byArray, --n2, 117);
            Target_java_lang_StringUTF16.putChar(byArray, --n2, 114);
            Target_java_lang_StringUTF16.putChar(byArray, --n2, 116);
        } else {
            Target_java_lang_StringUTF16.putChar(byArray, --n2, 101);
            Target_java_lang_StringUTF16.putChar(byArray, --n2, 115);
            Target_java_lang_StringUTF16.putChar(byArray, --n2, 108);
            Target_java_lang_StringUTF16.putChar(byArray, --n2, 97);
            Target_java_lang_StringUTF16.putChar(byArray, --n2, 102);
        }
        return (long)n2 | lJ;
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static long prepend(long l2, byte[] byArray, boolean bl2, String string) {
        l2 = SubstrateStringConcatHelper.prepend(l2, byArray, bl2);
        if (string != null) {
            l2 = SubstrateStringConcatHelper.a(l2, byArray, string);
        }
        return l2;
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static long prepend(long l2, byte[] byArray, byte by, String string) {
        l2 = SubstrateStringConcatHelper.a(l2, byArray, by);
        if (string != null) {
            l2 = SubstrateStringConcatHelper.a(l2, byArray, string);
        }
        return l2;
    }

    @com.oracle.svm.enterprise.core.annotate.a
    private static long prepend(long l2, byte[] byArray, char c2) {
        if (l2 < lJ) {
            byArray[(int)(--l2)] = (byte)(c2 & 0xFF);
        } else {
            Target_java_lang_StringUTF16.putChar(byArray, (int)(--l2), c2);
        }
        return l2;
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static long prepend(long l2, byte[] byArray, char c2, String string) {
        l2 = SubstrateStringConcatHelper.prepend(l2, byArray, c2);
        if (string != null) {
            l2 = SubstrateStringConcatHelper.a(l2, byArray, string);
        }
        return l2;
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static long prepend(long l2, byte[] byArray, short s2, String string) {
        l2 = SubstrateStringConcatHelper.a(l2, byArray, s2);
        if (string != null) {
            l2 = SubstrateStringConcatHelper.a(l2, byArray, string);
        }
        return l2;
    }

    private static long a(long l2, byte[] byArray, int n2) {
        if (l2 < lJ) {
            return Target_java_lang_Integer.getChars(n2, (int)l2, byArray);
        }
        return (long)Target_java_lang_StringUTF16.getChars(n2, (int)l2, byArray) | lJ;
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static long prepend(long l2, byte[] byArray, int n2, String string) {
        l2 = SubstrateStringConcatHelper.a(l2, byArray, n2);
        if (string != null) {
            l2 = SubstrateStringConcatHelper.a(l2, byArray, string);
        }
        return l2;
    }

    private static long a(long l2, byte[] byArray, long l3) {
        if (l2 < lJ) {
            return Target_java_lang_Long.getChars(l3, (int)l2, byArray);
        }
        return (long)Target_java_lang_StringUTF16.getChars(l3, (int)l2, byArray) | lJ;
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static long prepend(long l2, byte[] byArray, long l3, String string) {
        l2 = SubstrateStringConcatHelper.a(l2, byArray, l3);
        if (string != null) {
            l2 = SubstrateStringConcatHelper.a(l2, byArray, string);
        }
        return l2;
    }

    private static long a(long l2, byte[] byArray, String string) {
        if ((l2 -= (long)string.length()) < lJ) {
            a.a(string, byArray, (int)l2, a.lN);
        } else {
            a.a(string, byArray, (int)l2, a.lM);
        }
        return l2;
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static long prepend(long l2, byte[] byArray, String string, String string2) {
        l2 = SubstrateStringConcatHelper.a(l2, byArray, string);
        if (string2 != null) {
            l2 = SubstrateStringConcatHelper.a(l2, byArray, string2);
        }
        return l2;
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static String newString(byte[] byArray, long l2) {
        if (l2 == lI) {
            return a.a(byArray, a.lN);
        }
        if (l2 == lJ) {
            return a.a(byArray, a.lM);
        }
        throw new InternalError("Storage is not completely initialized, " + (int)l2 + " bytes left");
    }

    @AlwaysInline(value="@ForceInline in JDK")
    @com.oracle.svm.enterprise.core.annotate.a
    static String simpleConcat(Object object, Object object2) {
        String string = SubstrateStringConcatHelper.stringOf(object);
        String string2 = SubstrateStringConcatHelper.stringOf(object2);
        if (string.isEmpty()) {
            return new String(string2);
        }
        if (string2.isEmpty()) {
            return new String(string);
        }
        long l2 = SubstrateStringConcatHelper.mix(SubstrateStringConcatHelper.ch(), string);
        l2 = SubstrateStringConcatHelper.mix(l2, string2);
        byte[] byArray = SubstrateStringConcatHelper.newArray(l2);
        l2 = SubstrateStringConcatHelper.a(l2, byArray, string2);
        l2 = SubstrateStringConcatHelper.a(l2, byArray, string);
        return SubstrateStringConcatHelper.newString(byArray, l2);
    }

    @AlwaysInline(value="@ForceInline in JDK")
    @com.oracle.svm.enterprise.core.annotate.a
    static String newStringOf(Object object) {
        return new String(SubstrateStringConcatHelper.stringOf(object));
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static String stringOf(Object object) {
        String string;
        return object == null || (string = object.toString()) == null ? "null" : string;
    }

    @AlwaysInline(value="@ForceInline in JDK")
    @com.oracle.svm.enterprise.core.annotate.a
    static byte[] newArrayWithSuffix(String string, long l2) {
        byte[] byArray = SubstrateStringConcatHelper.newArray(l2 + (long)string.length());
        if (l2 < lJ) {
            a.a(string, byArray, (int)l2, a.lN);
        } else {
            a.a(string, byArray, (int)l2, a.lM);
        }
        return byArray;
    }

    @AlwaysInline(value="@ForceInline in JDK")
    @com.oracle.svm.enterprise.core.annotate.a
    static byte[] newArray(long l2) {
        byte by = (byte)(l2 >> 32);
        int n2 = (int)l2 << by;
        if (n2 < 0) {
            throw new OutOfMemoryError("Overflow: String length out of range");
        }
        return (byte[])lK.allocateUninitializedArray(Byte.TYPE, n2);
    }

    static long ch() {
        return a.lL ? lI : lJ;
    }

    @TargetClass(className="java.lang.StringLatin1")
    static final class Target_java_lang_StringLatin1 {
        Target_java_lang_StringLatin1() {
        }

        @Alias
        static native boolean canEncode(int var0);

        @Alias
        static native int length(byte[] var0);
    }

    @TargetClass(value=Integer.class)
    static final class Target_java_lang_Integer {
        Target_java_lang_Integer() {
        }

        @Alias
        static native int stringSize(int var0);

        @Alias
        static native int getChars(int var0, int var1, byte[] var2);
    }

    @TargetClass(value=Long.class)
    static final class Target_java_lang_Long {
        Target_java_lang_Long() {
        }

        @Alias
        static native int stringSize(long var0);

        @Alias
        static native int getChars(long var0, int var2, byte[] var3);
    }

    static class a {
        static final boolean lL;
        static final byte lM;
        static final byte lN;

        a() {
        }

        static void a(String string, byte[] byArray, int n2, byte by) {
            ((Target_java_lang_String)SubstrateUtil.cast((Object)string, Target_java_lang_String.class)).getBytes(byArray, n2, by);
        }

        static String a(byte[] byArray, byte by) {
            return (String)SubstrateUtil.cast((Object)new Target_java_lang_String(byArray, by), String.class);
        }

        static {
            lN = (Byte)ReflectionUtil.readStaticField(String.class, (String)"LATIN1");
            lM = (Byte)ReflectionUtil.readStaticField(String.class, (String)"UTF16");
            lL = (Boolean)ReflectionUtil.readStaticField(String.class, (String)"COMPACT_STRINGS");
        }
    }

    @TargetClass(className="java.lang.StringUTF16")
    static final class Target_java_lang_StringUTF16 {
        Target_java_lang_StringUTF16() {
        }

        @Alias
        static native void putChar(byte[] var0, int var1, int var2);

        @Alias
        static native int getChars(long var0, int var2, byte[] var3);

        @Alias
        static native int length(byte[] var0);
    }

    @TargetClass(value=String.class)
    static final class Target_java_lang_String {
        @Alias
        Target_java_lang_String(byte[] byArray, byte by) {
        }

        @Alias
        native void getBytes(byte[] var1, int var2, byte var3);
    }
}

