/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core.posix.mpk;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.os.MemoryProtectionProvider;
import com.oracle.svm.core.posix.PosixVirtualMemoryProvider;
import com.oracle.svm.core.posix.headers.Dlfcn;
import com.oracle.svm.core.posix.headers.Mman;
import com.oracle.svm.core.posix.headers.Signal;
import org.graalvm.compiler.core.amd64.WriteProtectionKeyRegisterNode;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.Isolates;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@Platforms(value={Platform.LINUX_AMD64.class})
class b
extends PosixVirtualMemoryProvider
implements MemoryProtectionProvider {
    private static final int hp = -8;
    private static final UnsignedWord hq = WordFactory.unsigned((int)0x55555554);
    private static final int hr = 1;
    private static final int hs = 2;
    private static final int ht = 4;
    static final int hu = -1;
    private Isolates.ProtectionDomain hv;
    private static final CGlobalData<CCharPointer> hw = CGlobalDataFactory.createCString((String)"pkey_mprotect");
    private static final CGlobalData<CCharPointer> hx = CGlobalDataFactory.createCString((String)"pkey_alloc");
    private static final CGlobalData<CCharPointer> hy = CGlobalDataFactory.createCString((String)"pkey_free");

    b() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static d aU() {
        return (d)Dlfcn.dlsym((PointerBase)Dlfcn.RTLD_DEFAULT(), (CCharPointer)((CCharPointer)hw.get()));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static b aV() {
        return (b)Dlfcn.dlsym((PointerBase)Dlfcn.RTLD_DEFAULT(), (CCharPointer)((CCharPointer)hx.get()));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static c aW() {
        return (c)Dlfcn.dlsym((PointerBase)Dlfcn.RTLD_DEFAULT(), (CCharPointer)((CCharPointer)hy.get()));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int protect(PointerBase pointerBase, UnsignedWord unsignedWord, int n2) {
        int n3 = b.aY().readInt(0);
        if (n3 != 0) {
            d d2 = b.aU();
            if (d2.isNull()) {
                return -1;
            }
            return d2.a(pointerBase, unsignedWord, b.accessAsProt((int)n2), n3);
        }
        return Mman.NoTransitions.mprotect((PointerBase)pointerBase, (UnsignedWord)unsignedWord, (int)b.accessAsProt((int)n2));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Pointer commit(PointerBase pointerBase, UnsignedWord unsignedWord, int n2) {
        Pointer pointer = super.commit(pointerBase, unsignedWord, n2);
        if (pointer.isNonNull() && this.protect((PointerBase)pointer, unsignedWord, n2) != 0) {
            Mman.NoTransitions.munmap((PointerBase)pointer, (UnsignedWord)unsignedWord);
            return (Pointer)WordFactory.nullPointer();
        }
        return pointer;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Pointer mapFile(PointerBase pointerBase, UnsignedWord unsignedWord, WordBase wordBase, UnsignedWord unsignedWord2, int n2) {
        Pointer pointer = super.mapFile(pointerBase, unsignedWord, wordBase, unsignedWord2, n2);
        if (pointer.isNonNull() && this.protect((PointerBase)pointer, unsignedWord, n2) != 0) {
            Mman.NoTransitions.munmap((PointerBase)pointer, (UnsignedWord)unsignedWord);
            return (Pointer)WordFactory.nullPointer();
        }
        return pointer;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int aX() {
        b b2 = b.aV();
        if (b2.isNull()) {
            return -1;
        }
        return b2.b((UnsignedWord)WordFactory.zero(), (UnsignedWord)WordFactory.zero());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static Pointer aY() {
        return ((Pointer)Isolates.getHeapBase((Isolate)CurrentIsolate.getIsolate())).add(-8);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void l(int n2) {
        b.aY().writeInt(0, n2);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void aZ() {
        c c2;
        int n2 = b.aY().readInt(0);
        if (n2 != 0 && (c2 = b.aW()).isNonNull()) {
            c2.m(n2);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void unlockCurrentIsolate() {
        int n2 = b.aY().readInt(0);
        if (n2 != 0) {
            UnsignedWord unsignedWord = WordFactory.unsigned((int)3).shiftLeft(2 * n2).not();
            WriteProtectionKeyRegisterNode.writeProtectionKeyRegister((WordBase)hq.and(unsignedWord));
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void handleSegfault(PointerBase pointerBase) {
        Signal.siginfo_t siginfo_t2 = (Signal.siginfo_t)pointerBase;
        if (siginfo_t2.si_code() == 4) {
            WriteProtectionKeyRegisterNode.writeProtectionKeyRegister((WordBase)WordFactory.zero());
        }
    }

    public void printSignalInfo(PointerBase pointerBase) {
        Signal.siginfo_t siginfo_t2 = (Signal.siginfo_t)pointerBase;
        if (siginfo_t2.si_code() != 4) {
            return;
        }
        Log log = Log.log();
        log.newline();
        log.string("Protection key access violation at memory address ").hex(siginfo_t2.si_addr().rawValue());
        log.newline();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    PointerBase a(PointerBase pointerBase, UnsignedWord unsignedWord, int n2) {
        return super.commit(pointerBase, unsignedWord, n2);
    }

    public Isolates.ProtectionDomain getProtectionDomain() {
        if (this.hv == null) {
            int n2 = b.aY().readInt(0);
            this.hv = n2 != 0 ? new a(n2) : Isolates.ProtectionDomain.NO_DOMAIN;
        }
        return this.hv;
    }

    public int asProtectionKey(Isolates.ProtectionDomain protectionDomain) throws MemoryProtectionProvider.UnsupportedDomainException {
        if (Isolates.ProtectionDomain.NO_DOMAIN.equals((Object)protectionDomain)) {
            return 0;
        }
        if (Isolates.ProtectionDomain.NEW_DOMAIN.equals((Object)protectionDomain)) {
            return -1;
        }
        if (protectionDomain instanceof a) {
            return ((a)protectionDomain).hz;
        }
        throw new MemoryProtectionProvider.UnsupportedDomainException();
    }

    static interface d
    extends CFunctionPointer {
        @InvokeCFunctionPointer(transition=CFunction.Transition.NO_TRANSITION)
        public int a(PointerBase var1, UnsignedWord var2, int var3, int var4);
    }

    static interface b
    extends CFunctionPointer {
        @InvokeCFunctionPointer(transition=CFunction.Transition.NO_TRANSITION)
        public int b(UnsignedWord var1, UnsignedWord var2);
    }

    static interface c
    extends CFunctionPointer {
        @InvokeCFunctionPointer(transition=CFunction.Transition.NO_TRANSITION)
        public int m(int var1);
    }

    private static final class a
    implements Isolates.ProtectionDomain {
        final int hz;

        a(int n2) {
            this.hz = n2;
        }

        public String toString() {
            return "Protection Domain with Linux memory protection key " + String.valueOf(this.hz);
        }
    }
}

