/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core.auximage;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.function.CEntryPointErrors;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImage;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImageCodeObserver;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImageProvider;
import com.oracle.svm.enterprise.core.auximage.d;
import com.oracle.svm.enterprise.core.auximage.f;
import com.oracle.svm.enterprise.core.auximage.r;
import com.oracle.svm.enterprise.core.auximage.s;
import java.io.File;
import java.util.concurrent.ThreadLocalRandom;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class AuxiliaryImageLoader {
    private static final CGlobalData<WordPointer> dg = CGlobalDataFactory.createWord((WordBase)AuxiliaryImageLoader.Y());
    private static Pointer dh;
    private static UnsignedWord di;
    private static Pointer dj;
    private static Pointer dk;
    private static volatile f dl;

    private static WordBase Y() {
        long l2;
        while ((l2 = ThreadLocalRandom.current().nextLong()) == 0L) {
        }
        return WordFactory.signed((long)l2);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static ComparableWord getPrimaryImageId() {
        return (ComparableWord)((WordPointer)dg.get()).read();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setAuxImageReservedSpace(Pointer pointer, UnsignedWord unsignedWord) {
        VMError.guarantee((dh.isNull() && di.equal((UnsignedWord)WordFactory.zero()) ? 1 : 0) != 0);
        dh = pointer;
        di = unsignedWord;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setAuxImageLocation(Pointer pointer, Pointer pointer2, UnsignedWord unsignedWord) {
        VMError.guarantee((pointer.isNull() == pointer2.isNull() && dj.isNull() == dk.isNull() ? 1 : 0) != 0, (String)"sanity");
        VMError.guarantee((dj.isNull() || pointer.isNull() ? 1 : 0) != 0, (String)"Cannot replace a loaded image in-place");
        dj = pointer;
        dk = pointer2;
        AuxiliaryImageLoader.b(unsignedWord);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void b(UnsignedWord unsignedWord) {
        Object object;
        f f2 = null;
        ImageHeapInfo imageHeapInfo = null;
        if (dj.isNonNull()) {
            object = KnownIntrinsics.heapBase().add(unsignedWord);
            f2 = (f)object.toObject();
            imageHeapInfo = f2.dq;
        }
        dl = f2;
        object = d.singleton();
        object.da = imageHeapInfo;
        object.db = true;
    }

    public static AuxiliaryImage load(File file) {
        b b2 = new b(file.getPath());
        b2.enqueue();
        if (b2.do != null) {
            throw b2.do;
        }
        AuxiliaryImageLoader.ac();
        return AuxiliaryImageLoader.getLoaded();
    }

    public static AuxiliaryImage getLoaded() {
        f f2 = dl;
        if (f2 == null) {
            throw new IllegalStateException("No auxiliary image has been loaded.");
        }
        return f2.dp;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static f Z() {
        return dl;
    }

    public static boolean hasLoaded() {
        return dl != null;
    }

    static void aa() {
        AuxiliaryImageLoader.ab();
        AuxiliaryImageLoader.ac();
    }

    private static void ab() {
        f f2 = dl;
        if (f2 != null) {
            if (r.isSupportedInCurrentImage()) {
                if (f2.dr.length > 0) {
                    a a2 = new a(f2);
                    a2.enqueue();
                }
            } else assert (f2.dr.length == 0) : "No runtime compilation, where does the compiled code come from?";
        }
    }

    private static void ac() {
        assert (!VMOperation.isInProgressAtSafepoint());
        f f2 = dl;
        if (f2 != null && r.isSupportedInCurrentImage() && f2.dr.length > 0) {
            for (AuxiliaryImageCodeObserver auxiliaryImageCodeObserver : f2.dt) {
                auxiliaryImageCodeObserver.afterAllAuxiliaryImageCodeInstalled();
            }
        }
    }

    private AuxiliaryImageLoader() {
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static final class b
    extends JavaVMOperation {
        private final String dn;
        private RuntimeException do;

        b(String string) {
            super(VMOperationInfos.get(b.class, (String)"Load auxiliary image", (VMOperation.SystemEffect)VMOperation.SystemEffect.SAFEPOINT));
            this.dn = string;
        }

        protected void operate() {
            try {
                this.ad();
            }
            catch (RuntimeException runtimeException) {
                this.do = runtimeException;
            }
        }

        protected void ad() {
            if (dl != null) {
                throw new IllegalStateException("An auxiliary image is already loaded.");
            }
            if (dh.isNull() || di.belowOrEqual(0)) {
                throw new IllegalStateException("No space was reserved for loading an auxiliary image during isolate creation");
            }
            WordPointer wordPointer = (WordPointer)UnsafeStackValue.get(WordPointer.class);
            WordPointer wordPointer2 = (WordPointer)UnsafeStackValue.get(WordPointer.class);
            try (CTypeConversion.CCharPointerHolder cCharPointerHolder = CTypeConversion.toCString((CharSequence)this.dn);){
                int n2 = AuxiliaryImageProvider.get().loadAuxiliaryImage(dh, di, cCharPointerHolder.get(), wordPointer, wordPointer2);
                if (n2 != 0) {
                    throw new RuntimeException("Auxiliary image could not be loaded: " + CEntryPointErrors.getDescription((int)n2));
                }
                AuxiliaryImageLoader.ab();
                d d2 = d.singleton();
                VMError.guarantee((dj.isNonNull() && dk.isNonNull() && dl != null && d2.da != null && d2.db ? 1 : 0) != 0);
            }
        }
    }

    private static class a
    extends JavaVMOperation {
        private final f dm;

        a(f f2) {
            super(VMOperationInfos.get(a.class, (String)"Install auxiliary image persisted code", (VMOperation.SystemEffect)VMOperation.SystemEffect.SAFEPOINT));
            this.dm = f2;
        }

        protected void operate() {
            try {
                s.a(this.dm);
            }
            catch (Throwable throwable) {
                throw VMError.shouldNotReachHere((String)"Persisted code cache installation failed.", (Throwable)throwable);
            }
        }
    }
}

