/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core;

import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.svm.core.Containers;
import com.oracle.svm.core.SubstrateControlFlowIntegrity;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.core.ap;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.image.CCLinkerInvocation;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.nativeimage.Platform;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class at {
    public static final HostedOptionKey<Boolean> AOTPriorityInline = new HostedOptionKey((Object)true);
    public static final HostedOptionKey<Boolean> UsePartialEscapeSelectiveInlining = new HostedOptionKey((Object)false);
    public static final HostedOptionKey<Long> ReservedAuxiliaryImageBytes;
    public static final HostedOptionKey<Boolean> UseCompressedReferences;
    public static final HostedOptionKey<Boolean> UseCompressedReferenceShift;
    public static final HostedOptionKey<Boolean> OptionalIdentityHashCodes;
    @APIOption(name={"G1"}, group=SubstrateOptions.GCGroup.class, customHelp="G1 garbage collector")
    public static final HostedOptionKey<Boolean> UseG1GC;
    public static final HostedOptionKey<Boolean> ProtectionKeys;
    public static final HostedOptionKey<Boolean> StackOverflowCheckInPrologue;
    public static final HostedOptionKey<Boolean> SafepointCheckInEpilogue;
    public static final RuntimeOptionKey<Boolean> DumpMethodsData;
    public static final HostedOptionKey<Boolean> UseMethodChecks;
    public static final HostedOptionKey<Boolean> CopyPrimitiveElementArrays;
    public static final HostedOptionKey<Boolean> GraalOS;
    public static final HostedOptionKey<Integer> MaxRuntimeCodeOffsetInstructions;

    @Fold
    public static UnsignedWord getReservedAuxiliaryImageBytes() {
        Long l2 = (Long)ReservedAuxiliaryImageBytes.getValue();
        return WordFactory.unsigned((long)(l2 != null && l2 > 0L ? l2 : 0L));
    }

    @Fold
    public static boolean useCompressedReferences() {
        return (Boolean)SubstrateOptions.SpawnIsolates.getValue() != false && !SubstrateOptions.useLLVMBackend() && (Boolean)UseCompressedReferences.getValue() != false;
    }

    public static boolean Q() {
        return at.useCompressedReferences() && (Boolean)UseCompressedReferenceShift.getValue() != false;
    }

    public static boolean R() {
        return SubstrateOptions.shouldCompileInIsolates() && (Boolean)a.CompileInPerThreadReusedIsolates.getValue() != false;
    }

    private static void a(HostedOptionKey<Boolean> hostedOptionKey) {
        if (((Boolean)hostedOptionKey.getValue()).booleanValue()) {
            if (!Platform.includedIn(Platform.LINUX_AMD64.class)) {
                throw UserError.abort((String)"Invalid option '%s'. Needs to be enabled for GraalOS.", (Object[])new Object[]{SubstrateOptionsParser.commandArgument(hostedOptionKey, (String)((Boolean)hostedOptionKey.getValue() != false ? "+" : "-"))});
            }
            if (!((Boolean)SubstrateOptions.NoDirectRelocationsInText.getValue()).booleanValue()) {
                throw UserError.abort((String)"Invalid option '%s'. Needs to be enabled for GraalOS.", (Object[])new Object[]{SubstrateOptionsParser.commandArgument((OptionKey)SubstrateOptions.NoDirectRelocationsInText, (String)"-")});
            }
            if (!((Boolean)SubstrateOptions.StaticExecutableWithDynamicLibC.getValue()).booleanValue()) {
                throw UserError.abort((String)"Invalid option '%s'. Needs to be enabled for GraalOS.", (Object[])new Object[]{SubstrateOptionsParser.commandArgument((OptionKey)SubstrateOptions.StaticExecutableWithDynamicLibC, (String)"-")});
            }
        }
    }

    static {
        SubstrateOptions.setOptimizeValueUpdateHandler((economicMap, optimizationLevel) -> AOTPriorityInline.update(economicMap, (Object)optimizationLevel.isOneOf(new SubstrateOptions.OptimizationLevel[]{SubstrateOptions.OptimizationLevel.O2, SubstrateOptions.OptimizationLevel.O3})));
        ReservedAuxiliaryImageBytes = new HostedOptionKey((Object)0L);
        UseCompressedReferences = new HostedOptionKey((Object)true);
        UseCompressedReferenceShift = new HostedOptionKey((Object)true);
        OptionalIdentityHashCodes = new HostedOptionKey(null, hostedOptionKey -> {
            if (!((Boolean)SubstrateOptions.UseSerialGC.getValue()).booleanValue() && !((Boolean)SubstrateOptions.UseEpsilonGC.getValue()).booleanValue()) {
                throw new InterruptImageBuilding("The option '" + hostedOptionKey.getName() + "' can only be used together with the serial ('--gc=serial') or the epsilon garbage collector ('--gc=epsilon').");
            }
            if (Boolean.TRUE.equals(hostedOptionKey.getValue()) && !at.Q()) {
                throw new InterruptImageBuilding(String.format("Option %s cannot be used together with %s or %s or %s.", SubstrateOptionsParser.commandArgument(OptionalIdentityHashCodes, (String)"+"), SubstrateOptionsParser.commandArgument((OptionKey)SubstrateOptions.SpawnIsolates, (String)"-"), SubstrateOptionsParser.commandArgument(UseCompressedReferences, (String)"-"), SubstrateOptionsParser.commandArgument(UseCompressedReferenceShift, (String)"-")));
            }
        });
        UseG1GC = new HostedOptionKey<Boolean>(Boolean.valueOf(false)){

            protected void a(EconomicMap<OptionKey<?>, Object> economicMap, Boolean bl2, Boolean bl3) {
                if (bl3.booleanValue()) {
                    SubstrateOptions.UseSerialGC.update(economicMap, (Object)false);
                    SubstrateOptions.UseEpsilonGC.update(economicMap, (Object)false);
                    SubstrateOptions.SpawnIsolates.update(economicMap, (Object)true);
                    SubstrateOptions.AllowVMInternalThreads.update(economicMap, (Object)true);
                    SubstrateOptions.ConcealedOptions.UseDedicatedVMOperationThread.update(economicMap, (Object)true);
                    SubstrateOptions.ConcealedOptions.SupportCompileInIsolates.update(economicMap, (Object)false);
                }
            }

            protected /* synthetic */ void onValueUpdate(EconomicMap economicMap, Object object, Object object2) {
                this.a(economicMap, (Boolean)object, (Boolean)object2);
            }
        };
        ProtectionKeys = new HostedOptionKey((Object)false, hostedOptionKey -> {
            if (Boolean.TRUE.equals(hostedOptionKey.getValue()) && !at.useCompressedReferences()) {
                throw new InterruptImageBuilding(String.format("Option %s cannot be used together with %s or %s.", SubstrateOptionsParser.commandArgument(ProtectionKeys, (String)"+"), SubstrateOptionsParser.commandArgument((OptionKey)SubstrateOptions.SpawnIsolates, (String)"-"), SubstrateOptionsParser.commandArgument(UseCompressedReferences, (String)"-")));
            }
        });
        StackOverflowCheckInPrologue = new HostedOptionKey((Object)true);
        SafepointCheckInEpilogue = new HostedOptionKey((Object)true);
        DumpMethodsData = new RuntimeOptionKey((Object)false, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        UseMethodChecks = new HostedOptionKey((Object)true);
        CopyPrimitiveElementArrays = new HostedOptionKey((Object)false);
        GraalOS = new HostedOptionKey<Boolean>(Boolean.valueOf(false), at::a){

            protected void a(EconomicMap<OptionKey<?>, Object> economicMap, Boolean bl2, Boolean bl3) {
                super.onValueUpdate(economicMap, (Object)bl2, (Object)bl3);
                if (bl3.booleanValue()) {
                    Object object;
                    String string;
                    boolean bl4;
                    if (!economicMap.containsKey((Object)NativeImageOptions.ReportUnsupportedElementsAtRuntime)) {
                        NativeImageOptions.ReportUnsupportedElementsAtRuntime.update(economicMap, (Object)true);
                    }
                    if (!economicMap.containsKey(a.MaxReservedAddressSpaceSize)) {
                        a.MaxReservedAddressSpaceSize.update(economicMap, (Object)0x400000000L);
                    }
                    if (!economicMap.containsKey(ap.a.CFI)) {
                        ap.a.CFI.update(economicMap, (Object)SubstrateControlFlowIntegrity.CFIOptions.SW);
                    }
                    if (!economicMap.containsKey((Object)SubstrateOptions.StaticExecutableWithDynamicLibC)) {
                        SubstrateOptions.StaticExecutableWithDynamicLibC.update(economicMap, (Object)true);
                    }
                    CCLinkerInvocation.Options.NativeLinkerOption.update(economicMap, (Object)"-pie");
                    boolean bl5 = bl4 = ap.a.CFI.getValueOrDefault(economicMap) == SubstrateControlFlowIntegrity.CFIOptions.SW;
                    if (!economicMap.containsKey((Object)SubstrateOptions.UseLibC)) {
                        string = bl4 ? "musl-swcfi" : "musl";
                        SubstrateOptions.UseLibC.update(economicMap, (Object)string);
                        System.setProperty("substratevm.HostLibC", string);
                        object = (LocatableMultiOptionValue)economicMap.get((Object)SubstrateOptions.CLibraryPath);
                        if (object == null) {
                            throw UserError.abort((String)"'%s' must be set when building with '%s'.", (Object[])new Object[]{SubstrateOptionsParser.commandArgument((OptionKey)SubstrateOptions.CLibraryPath, (String)""), SubstrateOptionsParser.commandArgument(GraalOS, (String)"+")});
                        }
                        List list = object.values();
                        if (list == null) {
                            throw UserError.abort((String)"'%s' must be set when building with '%s'.", (Object[])new Object[]{SubstrateOptionsParser.commandArgument((OptionKey)SubstrateOptions.CLibraryPath, (String)""), SubstrateOptionsParser.commandArgument(GraalOS, (String)"+")});
                        }
                        LocatableMultiOptionValue.Paths paths = LocatableMultiOptionValue.Paths.buildWithCustomDelimiter((String)object.getDelimiter());
                        for (Object e2 : list) {
                            Path path = (Path)e2;
                            if (path.endsWith("glibc")) {
                                Path path2 = path.getParent();
                                if (path2 == null) {
                                    throw UserError.abort((String)"Invalid top-level directory for '%s' in '%s'.", (Object[])new Object[]{path, SubstrateOptionsParser.commandArgument((OptionKey)SubstrateOptions.CLibraryPath, (String)list.stream().map(Object::toString).collect(Collectors.joining(object.getDelimiter())))});
                                }
                                Path path3 = path2.resolve(string);
                                paths.valueUpdate((Object)path3);
                                continue;
                            }
                            paths.valueUpdate((Object)path);
                        }
                        economicMap.put((Object)SubstrateOptions.CLibraryPath, (Object)paths);
                    }
                    if (bl4 && !economicMap.containsKey((Object)SubstrateOptions.CCompilerPath)) {
                        string = "musl-swcfi";
                        object = Paths.get(System.getProperty("java.home"), new String[0]).resolve(Paths.get("lib", "toolchains", string, "bin", "clang"));
                        if (object == null || !Files.exists((Path)object, new LinkOption[0])) {
                            throw VMError.shouldNotReachHere((String)"Toolchain compiler \"%s\" not found in %s", (Object[])new Object[]{string, object});
                        }
                        try {
                            object = object.toRealPath(new LinkOption[0]);
                        }
                        catch (IOException iOException) {
                            throw VMError.shouldNotReachHere((String)"Toolchain compiler \"%s\" not found in %s", (Object[])new Object[]{string, object});
                        }
                        SubstrateOptions.CCompilerPath.update(economicMap, (Object)object.toString());
                    }
                    Containers.Options.UseContainerSupport.update(economicMap, (Object)false);
                }
            }

            protected /* synthetic */ void onValueUpdate(EconomicMap economicMap, Object object, Object object2) {
                this.a(economicMap, (Boolean)object, (Boolean)object2);
            }
        };
        MaxRuntimeCodeOffsetInstructions = new HostedOptionKey((Object)0, hostedOptionKey -> {
            if ((Integer)hostedOptionKey.getValue() < 0) {
                throw new InterruptImageBuilding(String.format("Option %s cannot be negative.", SubstrateOptionsParser.commandArgument(MaxRuntimeCodeOffsetInstructions, (String)"+")));
            }
        });
    }

    public static class a {
        public static final HostedOptionKey<Long> MaxReservedAddressSpaceSize = new HostedOptionKey((Object)0L);
        public static final RuntimeOptionKey<Boolean> CompileInPerThreadReusedIsolates = new RuntimeOptionKey((Object)true, new RuntimeOptionKey.RuntimeOptionKeyFlag[]{RuntimeOptionKey.RuntimeOptionKeyFlag.RelevantForCompilationIsolates});
        public static final HostedOptionKey<Boolean> UseStringInlining = new HostedOptionKey<Boolean>(Boolean.valueOf(false)){

            protected void a(EconomicMap<OptionKey<?>, Object> economicMap, Boolean bl2, Boolean bl3) {
                GraalOptions.EmitStringSubstitutions.update(economicMap, (Object)(bl3 == false && !((String)SubstrateOptions.CompilerBackend.getValueOrDefault(economicMap)).equals("llvm") ? 1 : 0));
            }

            protected /* synthetic */ void onValueUpdate(EconomicMap economicMap, Object object, Object object2) {
                this.a(economicMap, (Boolean)object, (Boolean)object2);
            }
        };
    }

    public static class c {
        public static final HostedOptionKey<Boolean> AuxiliaryEngineCache = new HostedOptionKey((Object)false);
    }

    public static class b {
        public static final OptionKey<Integer> by = new OptionKey((Object)0);
        public static final OptionKey<Integer> bz = new OptionKey((Object)0);
        public static final OptionKey<Boolean> bA = new OptionKey<Boolean>(Boolean.valueOf(false)){

            protected void a(EconomicMap<OptionKey<?>, Object> economicMap, Boolean bl2, Boolean bl3) {
                if (bl3.booleanValue()) {
                    PointstoOptions.TrackAccessChain.update(economicMap, (Object)true);
                    PointstoOptions.TrackInputFlows.update(economicMap, (Object)true);
                }
            }

            protected /* synthetic */ void onValueUpdate(EconomicMap economicMap, Object object, Object object2) {
                this.a(economicMap, (Boolean)object, (Boolean)object2);
            }
        };
    }
}

