/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime;

import ai.onnxruntime.OnnxMap;
import ai.onnxruntime.OnnxRuntime;
import ai.onnxruntime.OnnxTensor;
import ai.onnxruntime.OnnxValue;
import ai.onnxruntime.OrtException;
import ai.onnxruntime.SequenceInfo;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class OnnxSequence
implements OnnxValue {
    final long nativeHandle;
    private final long allocatorHandle;
    private final SequenceInfo info;

    OnnxSequence(long l2, long l3, SequenceInfo sequenceInfo) {
        this.nativeHandle = l2;
        this.allocatorHandle = l3;
        this.info = sequenceInfo;
    }

    @Override
    public OnnxValue.OnnxValueType getType() {
        return OnnxValue.OnnxValueType.ONNX_TYPE_SEQUENCE;
    }

    @Override
    public List<? extends OnnxValue> getValue() throws OrtException {
        if (this.info.sequenceOfMaps) {
            OnnxMap[] onnxMapArray = this.getMaps(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocatorHandle);
            return Collections.unmodifiableList(Arrays.asList(onnxMapArray));
        }
        switch (this.info.sequenceType) {
            case STRING: 
            case INT64: 
            case FLOAT: 
            case DOUBLE: {
                OnnxTensor[] onnxTensorArray = this.getTensors(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocatorHandle);
                return Collections.unmodifiableList(Arrays.asList(onnxTensorArray));
            }
        }
        throw new OrtException("Unsupported type in a sequence, found " + (Object)((Object)this.info.sequenceType));
    }

    @Override
    public SequenceInfo getInfo() {
        return this.info;
    }

    public String toString() {
        return "OnnxSequence(info=" + this.info.toString() + ")";
    }

    @Override
    public void close() {
        this.close(OnnxRuntime.ortApiHandle, this.nativeHandle);
    }

    private native OnnxMap[] getMaps(long var1, long var3, long var5) throws OrtException;

    private native OnnxTensor[] getTensors(long var1, long var3, long var5) throws OrtException;

    private native void close(long var1, long var3);

    static {
        try {
            OnnxRuntime.init();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to load onnx-runtime library", iOException);
        }
    }
}

