/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jni;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaMethod;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.graal.code.CGlobalDataInfo;
import com.oracle.svm.core.graal.nodes.CGlobalDataLoadAddressNode;
import com.oracle.svm.core.jni.access.JNINativeLinkage;
import com.oracle.svm.core.jni.headers.JNIEnvironment;
import com.oracle.svm.core.jni.headers.JNIObjectHandle;
import com.oracle.svm.hosted.annotation.CustomSubstitutionMethod;
import com.oracle.svm.hosted.c.CGlobalDataFeature;
import com.oracle.svm.hosted.code.SimpleSignature;
import com.oracle.svm.hosted.heap.SVMImageHeapScanner;
import com.oracle.svm.hosted.jni.JNIAccessFeature;
import com.oracle.svm.hosted.jni.JNIGraphKit;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.MonitorEnterNode;
import org.graalvm.compiler.nodes.java.MonitorExitNode;
import org.graalvm.compiler.nodes.java.MonitorIdNode;

class JNINativeCallWrapperMethod
extends CustomSubstitutionMethod {
    private static final int NATIVE_LINE_NUMBER = -2;
    private static final LineNumberTable LINE_NUMBER_TABLE = new LineNumberTable(new int[]{1}, new int[]{-2});
    private final JNINativeLinkage linkage;
    private final Field linkageBuiltInAddressField = ReflectionUtil.lookupField(JNINativeLinkage.class, (String)"builtInAddress");

    JNINativeCallWrapperMethod(ResolvedJavaMethod method) {
        super(method);
        assert (!(method instanceof WrappedJavaMethod));
        this.linkage = JNINativeCallWrapperMethod.createLinkage(method);
    }

    private static JNINativeLinkage createLinkage(ResolvedJavaMethod method) {
        String className = method.getDeclaringClass().getName();
        String descriptor = method.getSignature().toMethodDescriptor();
        return JNIAccessFeature.singleton().makeLinkage(className, method.getName(), descriptor);
    }

    @Override
    public int getModifiers() {
        return this.getOriginal().getModifiers() & 0xFFFFFFDF;
    }

    @Override
    public LineNumberTable getLineNumberTable() {
        return LINE_NUMBER_TABLE;
    }

    @Override
    public StackTraceElement asStackTraceElement(int bci) {
        StackTraceElement ste = super.asStackTraceElement(bci);
        ste = new StackTraceElement(ste.getClassLoaderName(), ste.getModuleName(), ste.getModuleVersion(), ste.getClassName(), ste.getMethodName(), ste.getFileName(), -2);
        assert (ste.isNativeMethod());
        return ste;
    }

    public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        InvokeWithExceptionNode callAddress;
        JNIGraphKit kit = new JNIGraphKit(debug, providers, method, purpose);
        StructuredGraph graph = kit.getGraph();
        if (this.linkage.isBuiltInFunction()) {
            Function<String, CGlobalDataInfo> createSymbol = symbolName -> CGlobalDataFeature.singleton().registerAsAccessedOrGet(CGlobalDataFactory.forSymbol(symbolName));
            CGlobalDataInfo builtinAddress = this.linkage.getOrCreateBuiltInAddress(createSymbol);
            callAddress = kit.unique(new CGlobalDataLoadAddressNode(builtinAddress));
            SVMImageHeapScanner.instance().rescanField((Object)this.linkage, this.linkageBuiltInAddressField);
        } else {
            callAddress = kit.invokeNativeCallAddress((ValueNode)kit.createObject(this.linkage));
        }
        InvokeWithExceptionNode environment = kit.invokeEnvironment();
        InvokeWithExceptionNode handleFrame = kit.invokeNativeCallPrologue();
        JavaType javaReturnType = method.getSignature().getReturnType(null);
        JavaType[] javaArgumentTypes = method.toParameterTypes();
        List<ValueNode> javaArguments = kit.loadArguments(javaArgumentTypes);
        ArrayList<ValueNode> jniArguments = new ArrayList<ValueNode>(2 + javaArguments.size());
        ArrayList<JavaType> jniArgumentTypes = new ArrayList<JavaType>(2 + javaArguments.size());
        ResolvedJavaType environmentType = providers.getMetaAccess().lookupJavaType(JNIEnvironment.class);
        ResolvedJavaType objectHandleType = providers.getMetaAccess().lookupJavaType(JNIObjectHandle.class);
        jniArguments.add((ValueNode)environment);
        jniArgumentTypes.add((JavaType)environmentType);
        if (method.isStatic()) {
            JavaConstant clazz = providers.getConstantReflection().asJavaClass(method.getDeclaringClass());
            ConstantNode clazzNode = ConstantNode.forConstant((JavaConstant)clazz, (MetaAccessProvider)providers.getMetaAccess(), (StructuredGraph)graph);
            InvokeWithExceptionNode box = kit.invokeBoxObjectInLocalHandle((ValueNode)clazzNode);
            jniArguments.add((ValueNode)box);
            jniArgumentTypes.add((JavaType)objectHandleType);
        }
        for (int i = 0; i < javaArguments.size(); ++i) {
            ValueNode arg = javaArguments.get(i);
            JavaType argType = javaArgumentTypes[i];
            if (javaArgumentTypes[i].getJavaKind().isObject()) {
                ValueNode obj = javaArguments.get(i);
                arg = kit.invokeBoxObjectInLocalHandle(obj);
                argType = objectHandleType;
            }
            jniArguments.add(arg);
            jniArgumentTypes.add(argType);
        }
        assert (jniArguments.size() == jniArgumentTypes.size());
        JavaType jniReturnType = javaReturnType;
        if (jniReturnType.getJavaKind().isObject()) {
            jniReturnType = objectHandleType;
        }
        if (this.getOriginal().isSynchronized()) {
            ValueNode monitorObject;
            if (method.isStatic()) {
                JavaConstant hubConstant = (JavaConstant)providers.getConstantReflection().asObjectHub(method.getDeclaringClass());
                monitorObject = ConstantNode.forConstant((JavaConstant)hubConstant, (MetaAccessProvider)providers.getMetaAccess(), (StructuredGraph)graph);
            } else {
                monitorObject = kit.maybeCreateExplicitNullCheck(javaArguments.get(0));
            }
            MonitorIdNode monitorId = (MonitorIdNode)graph.add((Node)new MonitorIdNode(kit.getFrameState().lockDepth(false)));
            MonitorEnterNode monitorEnter = (MonitorEnterNode)kit.append((Node)new MonitorEnterNode(monitorObject, monitorId));
            kit.getFrameState().pushLock(monitorEnter.object(), monitorEnter.getMonitorId());
            monitorEnter.setStateAfter(kit.getFrameState().create(kit.bci(), (StateSplit)monitorEnter));
        }
        kit.getFrameState().clearLocals();
        SimpleSignature jniSignature = new SimpleSignature(jniArgumentTypes, jniReturnType);
        ValueNode returnValue = kit.createCFunctionCall((ValueNode)callAddress, jniArguments, jniSignature, 3, false);
        if (this.getOriginal().isSynchronized()) {
            MonitorIdNode monitorId = kit.getFrameState().peekMonitorId();
            ValueNode monitorObject = kit.getFrameState().popLock();
            MonitorExitNode monitorExit = (MonitorExitNode)kit.append((Node)new MonitorExitNode(monitorObject, monitorId, null));
            monitorExit.setStateAfter(kit.getFrameState().create(kit.bci(), (StateSplit)monitorExit));
        }
        if (javaReturnType.getJavaKind().isObject()) {
            returnValue = kit.invokeUnboxHandle(returnValue);
        }
        kit.invokeNativeCallEpilogue((ValueNode)handleFrame);
        kit.invokeRethrowPendingException();
        if (javaReturnType.getJavaKind().isObject()) {
            returnValue = kit.checkObjectType(returnValue, (ResolvedJavaType)javaReturnType, false);
        }
        kit.createReturn(returnValue, javaReturnType.getJavaKind());
        return kit.finalizeGraph();
    }
}

