/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.config;

import com.oracle.svm.core.MissingRegistrationUtils;
import com.oracle.svm.core.TypeResult;
import com.oracle.svm.core.configure.ConfigurationTypeDescriptor;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.config.RegistryAdapter;
import com.oracle.svm.hosted.reflect.ReflectionDataBuilder;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.util.List;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.ReflectionRegistry;
import org.graalvm.nativeimage.impl.RuntimeJNIAccessSupport;
import org.graalvm.nativeimage.impl.RuntimeProxyCreationSupport;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;
import org.graalvm.nativeimage.impl.RuntimeSerializationSupport;

public class ReflectionRegistryAdapter
extends RegistryAdapter {
    private final RuntimeReflectionSupport reflectionSupport;
    private final RuntimeProxyCreationSupport proxySupport;
    private final RuntimeSerializationSupport serializationSupport;
    private final RuntimeJNIAccessSupport jniSupport;

    ReflectionRegistryAdapter(RuntimeReflectionSupport reflectionSupport, RuntimeProxyCreationSupport proxySupport, RuntimeSerializationSupport serializationSupport, RuntimeJNIAccessSupport jniSupport, ImageClassLoader classLoader) {
        super((ReflectionRegistry)reflectionSupport, classLoader);
        this.reflectionSupport = reflectionSupport;
        this.proxySupport = proxySupport;
        this.serializationSupport = serializationSupport;
        this.jniSupport = jniSupport;
    }

    @Override
    public TypeResult<Class<?>> resolveType(ConfigurationCondition condition, ConfigurationTypeDescriptor typeDescriptor, boolean allowPrimitives) {
        TypeResult<Class<?>> result = super.resolveType(condition, typeDescriptor, allowPrimitives);
        if (!result.isPresent()) {
            Throwable classLookupException = result.getException();
            if (classLookupException instanceof LinkageError) {
                this.reflectionSupport.registerClassLookupException(condition, typeDescriptor.toString(), classLookupException);
            } else if (MissingRegistrationUtils.throwMissingRegistrationErrors() && classLookupException instanceof ClassNotFoundException) {
                this.reflectionSupport.registerClassLookup(condition, typeDescriptor.toString());
            }
        }
        return result;
    }

    @Override
    public void registerType(ConfigurationCondition condition, Class<?> type) {
        super.registerType(condition, type);
        if (Proxy.isProxyClass(type)) {
            this.proxySupport.addProxyClass((Class[])type.getInterfaces());
        }
    }

    @Override
    public void registerPublicClasses(ConfigurationCondition condition, Class<?> type) {
        this.reflectionSupport.registerAllClassesQuery(condition, type);
    }

    @Override
    public void registerDeclaredClasses(ConfigurationCondition condition, Class<?> type) {
        this.reflectionSupport.registerAllDeclaredClassesQuery(condition, type);
    }

    @Override
    public void registerRecordComponents(ConfigurationCondition condition, Class<?> type) {
        this.reflectionSupport.registerAllRecordComponentsQuery(condition, type);
    }

    @Override
    public void registerPermittedSubclasses(ConfigurationCondition condition, Class<?> type) {
        this.reflectionSupport.registerAllPermittedSubclassesQuery(condition, type);
    }

    @Override
    public void registerNestMembers(ConfigurationCondition condition, Class<?> type) {
        this.reflectionSupport.registerAllNestMembersQuery(condition, type);
    }

    @Override
    public void registerSigners(ConfigurationCondition condition, Class<?> type) {
        this.reflectionSupport.registerAllSignersQuery(condition, type);
    }

    @Override
    public void registerPublicFields(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Class<?> type) {
        RuntimeReflectionSupport runtimeReflectionSupport = this.reflectionSupport;
        if (runtimeReflectionSupport instanceof ReflectionDataBuilder) {
            ReflectionDataBuilder reflectionDataBuilder = (ReflectionDataBuilder)runtimeReflectionSupport;
            reflectionDataBuilder.registerAllFieldsQuery(condition, queriedOnly, type);
        } else if (!queriedOnly && jniAccessible) {
            this.jniSupport.register(condition, false, type.getDeclaredFields());
        }
    }

    @Override
    public void registerDeclaredFields(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Class<?> type) {
        RuntimeReflectionSupport runtimeReflectionSupport = this.reflectionSupport;
        if (runtimeReflectionSupport instanceof ReflectionDataBuilder) {
            ReflectionDataBuilder reflectionDataBuilder = (ReflectionDataBuilder)runtimeReflectionSupport;
            reflectionDataBuilder.registerAllDeclaredFieldsQuery(condition, queriedOnly, type);
        } else if (!queriedOnly && jniAccessible) {
            this.jniSupport.register(condition, false, type.getFields());
        }
    }

    @Override
    public void registerPublicMethods(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Class<?> type) {
        this.reflectionSupport.registerAllMethodsQuery(condition, queriedOnly, type);
        if (!queriedOnly && jniAccessible) {
            this.jniSupport.register(condition, false, (Executable[])type.getMethods());
        }
    }

    @Override
    public void registerDeclaredMethods(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Class<?> type) {
        this.reflectionSupport.registerAllDeclaredMethodsQuery(condition, queriedOnly, type);
        if (!queriedOnly && jniAccessible) {
            this.jniSupport.register(condition, false, (Executable[])type.getDeclaredMethods());
        }
    }

    @Override
    public void registerPublicConstructors(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Class<?> type) {
        this.reflectionSupport.registerAllConstructorsQuery(condition, queriedOnly, type);
        if (!queriedOnly && jniAccessible) {
            this.jniSupport.register(condition, false, (Executable[])type.getConstructors());
        }
    }

    @Override
    public void registerDeclaredConstructors(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Class<?> type) {
        this.reflectionSupport.registerAllDeclaredConstructorsQuery(condition, queriedOnly, type);
        if (!queriedOnly && jniAccessible) {
            this.jniSupport.register(condition, false, (Executable[])type.getDeclaredConstructors());
        }
    }

    @Override
    public void registerField(ConfigurationCondition condition, Class<?> type, String fieldName, boolean allowWrite, boolean jniAccessible) throws NoSuchFieldException {
        try {
            super.registerField(condition, type, fieldName, allowWrite, jniAccessible);
        }
        catch (NoSuchFieldException e) {
            if (MissingRegistrationUtils.throwMissingRegistrationErrors()) {
                this.reflectionSupport.registerFieldLookup(condition, type, fieldName);
            }
            throw e;
        }
    }

    @Override
    public void registerMethod(ConfigurationCondition condition, boolean queriedOnly, Class<?> type, String methodName, List<Class<?>> methodParameterTypes, boolean jniAccessible) throws NoSuchMethodException {
        try {
            super.registerMethod(condition, queriedOnly, type, methodName, methodParameterTypes, jniAccessible);
        }
        catch (NoSuchMethodException e) {
            if (MissingRegistrationUtils.throwMissingRegistrationErrors()) {
                this.reflectionSupport.registerMethodLookup(condition, type, methodName, (Class[])ReflectionRegistryAdapter.getParameterTypes(methodParameterTypes));
            }
            throw e;
        }
    }

    @Override
    public void registerConstructor(ConfigurationCondition condition, boolean queriedOnly, Class<?> type, List<Class<?>> methodParameterTypes, boolean jniAccessible) throws NoSuchMethodException {
        try {
            super.registerConstructor(condition, queriedOnly, type, methodParameterTypes, jniAccessible);
        }
        catch (NoSuchMethodException e) {
            if (MissingRegistrationUtils.throwMissingRegistrationErrors()) {
                this.reflectionSupport.registerConstructorLookup(condition, type, (Class[])ReflectionRegistryAdapter.getParameterTypes(methodParameterTypes));
            }
            throw e;
        }
    }

    @Override
    public void registerAsSerializable(ConfigurationCondition condition, Class<?> clazz) {
        this.serializationSupport.register(condition, new Class[]{clazz});
    }

    @Override
    public void registerAsJniAccessed(ConfigurationCondition condition, Class<?> clazz) {
        this.jniSupport.register(condition, new Class[]{clazz});
    }

    @Override
    protected void registerField(ConfigurationCondition condition, boolean allowWrite, boolean jniAccessible, Field field) {
        super.registerField(condition, allowWrite, jniAccessible, field);
        if (jniAccessible) {
            this.jniSupport.register(condition, allowWrite, new Field[]{field});
        }
    }

    @Override
    protected void registerExecutable(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Executable ... executable) {
        super.registerExecutable(condition, queriedOnly, jniAccessible, executable);
        if (jniAccessible) {
            this.jniSupport.register(condition, queriedOnly, executable);
        }
    }
}

