/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.annotation.CustomSubstitutionMethod;
import com.oracle.svm.hosted.c.CInterfaceWrapper;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.EnumInfo;
import com.oracle.svm.hosted.c.info.EnumLookupInfo;
import com.oracle.svm.hosted.code.CEntryPointCallStubSupport;
import com.oracle.svm.hosted.code.SimpleSignature;
import com.oracle.svm.hosted.phases.CInterfaceEnumTool;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import java.lang.reflect.AnnotatedElement;
import java.util.List;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.java.FrameStateBuilder;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.constant.CEnum;
import org.graalvm.nativeimage.c.constant.CEnumLookup;

public abstract class CCallStubMethod
extends CustomSubstitutionMethod {
    private static final JavaKind cEnumKind = JavaKind.Int;
    protected final int newThreadStatus;

    CCallStubMethod(ResolvedJavaMethod original, int newThreadStatus) {
        super(original);
        this.newThreadStatus = newThreadStatus;
    }

    protected abstract String getCorrespondingAnnotationName();

    public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        NativeLibraries nativeLibraries = CEntryPointCallStubSupport.singleton().getNativeLibraries();
        boolean deoptimizationTarget = MultiMethod.isDeoptTarget((ResolvedJavaMethod)method);
        HostedGraphKit kit = new HostedGraphKit(debug, providers, method, purpose);
        FrameStateBuilder state = kit.getFrameState();
        List<ValueNode> arguments = kit.loadArguments(this.getParameterTypesForLoad(method));
        ValueNode callAddress = this.createTargetAddressNode(kit, providers, arguments);
        Signature signature = this.adaptSignatureAndConvertArguments(providers, nativeLibraries, kit, method, method.getSignature().getReturnType(null), method.toParameterTypes(), arguments);
        state.clearLocals();
        if (ImageSingletons.contains(CInterfaceWrapper.class)) {
            ((CInterfaceWrapper)ImageSingletons.lookup(CInterfaceWrapper.class)).tagCFunctionCallPrologue(kit, method);
        }
        ValueNode returnValue = kit.createCFunctionCall(callAddress, arguments, signature, this.newThreadStatus, deoptimizationTarget);
        if (ImageSingletons.contains(CInterfaceWrapper.class)) {
            ((CInterfaceWrapper)ImageSingletons.lookup(CInterfaceWrapper.class)).tagCFunctionCallEpilogue(kit, method);
        }
        returnValue = this.adaptReturnValue(method, providers, nativeLibraries, kit, returnValue);
        this.emitCallerEpilogue(kit);
        kit.createReturn(returnValue, signature.getReturnKind());
        return kit.finalizeGraph();
    }

    protected void emitCallerEpilogue(HostedGraphKit kit) {
    }

    protected abstract ValueNode createTargetAddressNode(HostedGraphKit var1, HostedProviders var2, List<ValueNode> var3);

    protected static boolean isPrimitiveOrWord(HostedProviders providers, JavaType type) {
        return type.getJavaKind().isPrimitive() || providers.getWordTypes().isWord(type);
    }

    protected JavaType[] getParameterTypesForLoad(ResolvedJavaMethod method) {
        return method.getSignature().toParameterTypes(null);
    }

    protected Signature adaptSignatureAndConvertArguments(HostedProviders providers, NativeLibraries nativeLibraries, HostedGraphKit kit, ResolvedJavaMethod method, JavaType returnType, JavaType[] parameterTypes, List<ValueNode> arguments) {
        MetaAccessProvider metaAccess = providers.getMetaAccess();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (CCallStubMethod.isPrimitiveOrWord(providers, parameterTypes[i])) continue;
            ElementInfo typeInfo = nativeLibraries.findElementInfo((AnnotatedElement)((ResolvedJavaType)parameterTypes[i]));
            if (typeInfo instanceof EnumInfo) {
                ValueNode argumentValue = kit.maybeCreateExplicitNullCheck(arguments.get(i));
                CInterfaceEnumTool tool = new CInterfaceEnumTool(metaAccess, providers.getSnippetReflection());
                argumentValue = tool.createEnumValueInvoke(kit, (EnumInfo)typeInfo, cEnumKind, argumentValue);
                arguments.set(i, argumentValue);
                parameterTypes[i] = metaAccess.lookupJavaType(cEnumKind.toJavaClass());
                continue;
            }
            throw UserError.abort("@%s parameter types are restricted to primitive types, word types and enumerations (@%s): %s", this.getCorrespondingAnnotationName(), CEnum.class.getSimpleName(), this.getOriginal());
        }
        JavaType actualReturnType = CCallStubMethod.isPrimitiveOrWord(providers, returnType) ? returnType : providers.getWordTypes().getWordImplType();
        return new SimpleSignature(parameterTypes, actualReturnType);
    }

    private ValueNode adaptReturnValue(ResolvedJavaMethod method, HostedProviders providers, NativeLibraries nativeLibraries, HostedGraphKit kit, ValueNode invokeValue) {
        ValueNode returnValue = invokeValue;
        JavaType declaredReturnType = method.getSignature().getReturnType(null);
        if (CCallStubMethod.isPrimitiveOrWord(providers, declaredReturnType)) {
            return returnValue;
        }
        ElementInfo typeInfo = nativeLibraries.findElementInfo((AnnotatedElement)((ResolvedJavaType)declaredReturnType));
        if (!(typeInfo instanceof EnumInfo)) {
            throw UserError.abort("Return types of methods annotated with @%s are restricted to primitive types, word types and enumerations (@%s): %s", this.getCorrespondingAnnotationName(), CEnum.class.getSimpleName(), this.getOriginal());
        }
        UserError.guarantee(typeInfo.getChildren().stream().anyMatch(EnumLookupInfo.class::isInstance), "Enum class %s needs a method that is annotated with @%s because it is used as the return type of a method annotated with @%s: %s", declaredReturnType, CEnumLookup.class.getSimpleName(), this.getCorrespondingAnnotationName(), this.getOriginal());
        CInterfaceEnumTool tool = new CInterfaceEnumTool(providers.getMetaAccess(), providers.getSnippetReflection());
        returnValue = tool.createEnumLookupInvoke(kit, (ResolvedJavaType)declaredReturnType, (EnumInfo)typeInfo, cEnumKind, returnValue);
        return returnValue;
    }
}

