/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c;

import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataImpl;
import com.oracle.svm.core.c.CGlobalDataNonConstantRegistry;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.code.CGlobalDataInfo;
import com.oracle.svm.core.graal.nodes.CGlobalDataLoadAddressNode;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.memory.BarrierType;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.memory.ReadNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class CGlobalDataFeature
implements InternalFeature {
    private final Method getCGlobalDataInfoMethod = ReflectionUtil.lookupMethod(CGlobalDataNonConstantRegistry.class, (String)"getCGlobalDataInfo", (Class[])new Class[]{CGlobalDataImpl.class});
    private final Field offsetField = ReflectionUtil.lookupField(CGlobalDataInfo.class, (String)"offset");
    private final Field isSymbolReferenceField = ReflectionUtil.lookupField(CGlobalDataInfo.class, (String)"isSymbolReference");
    private final CGlobalDataNonConstantRegistry nonConstantRegistry = new CGlobalDataNonConstantRegistry();
    private JavaConstant nonConstantRegistryJavaConstant;
    private final Map<CGlobalDataImpl<?>, CGlobalDataInfo> map = new ConcurrentHashMap();
    private CGlobalDataInfo cGlobalDataBaseAddress;
    private int totalSize = -1;

    public static CGlobalDataFeature singleton() {
        return (CGlobalDataFeature)ImageSingletons.lookup(CGlobalDataFeature.class);
    }

    private boolean isLayouted() {
        return this.totalSize != -1;
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        a.registerObjectReplacer(this::replaceObject);
        this.cGlobalDataBaseAddress = this.registerAsAccessedOrGet(CGlobalDataInfo.CGLOBALDATA_RUNTIME_BASE_ADDRESS);
        this.nonConstantRegistryJavaConstant = access.getMetaAccess().getUniverse().getSnippetReflection().forObject((Object)this.nonConstantRegistry);
    }

    public void afterHeapLayout(Feature.AfterHeapLayoutAccess access) {
        this.layout();
    }

    @Override
    public void registerInvocationPlugins(final Providers providers, SnippetReflectionProvider snippetReflection, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins.getInvocationPlugins(), CGlobalData.class);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("get", new Type[]{InvocationPlugin.Receiver.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                ValueNode cGlobalDataNode = receiver.get();
                if (cGlobalDataNode.isConstant()) {
                    CGlobalDataImpl data = (CGlobalDataImpl)providers.getSnippetReflection().asObject(CGlobalDataImpl.class, cGlobalDataNode.asJavaConstant());
                    CGlobalDataInfo info = CGlobalDataFeature.this.map.get(data);
                    b.addPush(targetMethod.getSignature().getReturnKind(), (ValueNode)new CGlobalDataLoadAddressNode(info));
                } else {
                    ConstantNode registry = ConstantNode.forConstant((JavaConstant)CGlobalDataFeature.this.nonConstantRegistryJavaConstant, (MetaAccessProvider)b.getMetaAccess(), (StructuredGraph)b.getGraph());
                    ValueNode info = (ValueNode)b.handleReplacedInvoke(CallTargetNode.InvokeKind.Virtual, b.getMetaAccess().lookupJavaMethod((Executable)CGlobalDataFeature.this.getCGlobalDataInfoMethod), new ValueNode[]{registry, cGlobalDataNode}, false);
                    b.pop(info.getStackKind());
                    info = b.nullCheckedValue(info);
                    ResolvedJavaType infoType = b.getMetaAccess().lookupJavaType(CGlobalDataInfo.class);
                    if (infoType instanceof AnalysisType) {
                        ((AnalysisType)infoType).registerAsReachable((Object)("registered by " + CGlobalDataFeature.class.getName()));
                    }
                    ValueNode offset = (ValueNode)b.add((Node)LoadFieldNode.create((Assumptions)b.getAssumptions(), (ValueNode)info, (ResolvedJavaField)b.getMetaAccess().lookupJavaField(CGlobalDataFeature.this.offsetField)));
                    CGlobalDataLoadAddressNode baseAddress = (CGlobalDataLoadAddressNode)b.add((Node)new CGlobalDataLoadAddressNode(CGlobalDataFeature.this.cGlobalDataBaseAddress));
                    ValueNode offsetWidened = (ValueNode)b.getGraph().addOrUnique((Node)SignExtendNode.create((ValueNode)offset, (int)IntegerStamp.getBits((Stamp)baseAddress.stamp(NodeView.DEFAULT)), (NodeView)NodeView.DEFAULT));
                    ValueNode address = (ValueNode)b.add((Node)new AddNode((ValueNode)baseAddress, offsetWidened));
                    ValueNode isSymbolReference = (ValueNode)b.add((Node)LoadFieldNode.create((Assumptions)b.getAssumptions(), (ValueNode)info, (ResolvedJavaField)b.getMetaAccess().lookupJavaField(CGlobalDataFeature.this.isSymbolReferenceField)));
                    LogicNode condition = IntegerEqualsNode.create((ValueNode)isSymbolReference, (ValueNode)ConstantNode.forBoolean((boolean)false, (StructuredGraph)b.getGraph()), (NodeView)NodeView.DEFAULT);
                    ReadNode readValue = (ReadNode)b.add((Node)new ReadNode((AddressNode)b.add((Node)OffsetAddressNode.create((ValueNode)address)), NamedLocationIdentity.ANY_LOCATION, baseAddress.stamp(NodeView.DEFAULT), BarrierType.NONE, MemoryOrderMode.PLAIN));
                    AbstractBeginNode trueBegin = (AbstractBeginNode)b.add((Node)new BeginNode());
                    FixedWithNextNode predecessor = (FixedWithNextNode)trueBegin.predecessor();
                    predecessor.setNext(null);
                    AbstractBeginNode falseBegin = (AbstractBeginNode)b.add((Node)new BeginNode());
                    trueBegin.setNext(null);
                    IfNode ifNode = (IfNode)b.add((Node)new IfNode(condition, trueBegin, falseBegin, BranchProbabilityNode.NOT_LIKELY_PROFILE));
                    falseBegin.setNext(null);
                    predecessor.setNext((FixedNode)ifNode);
                    EndNode thenEnd = (EndNode)b.add((Node)new EndNode());
                    trueBegin.setNext((FixedNode)thenEnd);
                    EndNode elseEnd = (EndNode)b.add((Node)new EndNode());
                    falseBegin.setNext((FixedNode)elseEnd);
                    AbstractMergeNode merge = (AbstractMergeNode)b.append((Node)new MergeNode());
                    merge.addForwardEnd(thenEnd);
                    merge.addForwardEnd(elseEnd);
                    ValuePhiNode phiNode = new ValuePhiNode(StampFactory.pointer(), merge, new ValueNode[]{address, readValue});
                    phiNode.inferStamp();
                    b.push(targetMethod.getSignature().getReturnKind(), (ValueNode)b.getGraph().addOrUnique((Node)phiNode));
                    b.setStateAfter((StateSplit)merge);
                }
                return true;
            }
        });
    }

    public CGlobalDataInfo registerAsAccessedOrGet(CGlobalData<?> obj) {
        CGlobalDataImpl data = (CGlobalDataImpl)obj;
        VMError.guarantee(!this.isLayouted() || this.map.containsKey(data), "CGlobalData instance must have been discovered/registered before or during analysis");
        return this.map.computeIfAbsent((CGlobalDataImpl)obj, o -> {
            CGlobalDataInfo cGlobalDataInfo = new CGlobalDataInfo(data);
            if (data.nonConstant) {
                this.nonConstantRegistry.registerNonConstantSymbol(cGlobalDataInfo);
            }
            return cGlobalDataInfo;
        });
    }

    public void registerWithGlobalSymbol(CGlobalData<?> obj) {
        this.registerWithGlobalSymbolImpl(obj);
    }

    public void registerWithGlobalHiddenSymbol(CGlobalData<?> obj) {
        this.registerWithGlobalSymbolImpl(obj).makeHiddenSymbol();
    }

    private CGlobalDataInfo registerWithGlobalSymbolImpl(CGlobalData<?> obj) {
        CGlobalDataInfo info = this.registerAsAccessedOrGet(obj);
        info.makeGlobalSymbol();
        return info;
    }

    public Set<String> getGlobalHiddenSymbols() {
        return this.map.entrySet().stream().filter(entry -> ((CGlobalDataInfo)entry.getValue()).isGlobalSymbol() && ((CGlobalDataInfo)entry.getValue()).isHiddenSymbol()).map(entry -> ((CGlobalDataImpl)entry.getKey()).symbolName).collect(Collectors.toSet());
    }

    private Object replaceObject(Object obj) {
        if (obj instanceof CGlobalDataImpl) {
            this.registerAsAccessedOrGet((CGlobalData)obj);
        }
        return obj;
    }

    private static CGlobalDataInfo assignCGlobalDataSize(Map.Entry<CGlobalDataImpl<?>, CGlobalDataInfo> entry, int wordSize) {
        CGlobalDataImpl<?> data = entry.getKey();
        CGlobalDataInfo info = entry.getValue();
        if (data.bytesSupplier != null) {
            byte[] bytes = data.bytesSupplier.get();
            info.assignSize(bytes.length);
            info.assignBytes(bytes);
        } else if (data.sizeSupplier != null) {
            info.assignSize(data.sizeSupplier.getAsInt());
        } else {
            assert (data.symbolName != null) : "CGlobalData without bytes, size, or referenced symbol";
            info.assignSize(wordSize);
        }
        return info;
    }

    private void layout() {
        assert (!this.isLayouted()) : "Already layouted";
        int wordSize = ConfigurationValues.getTarget().wordSize;
        this.totalSize = this.map.entrySet().stream().map(entry -> CGlobalDataFeature.assignCGlobalDataSize(entry, wordSize)).sorted(Comparator.comparing(CGlobalDataInfo::getSize)).reduce(0, (currentOffset, info) -> {
            info.assignOffset((int)currentOffset);
            int nextOffset = currentOffset + info.getSize();
            return nextOffset + (wordSize - 1) & ~(wordSize - 1);
        }, Integer::sum);
        assert (this.isLayouted());
    }

    public int getSize() {
        assert (this.isLayouted()) : "Not layouted yet";
        return this.totalSize;
    }

    public void writeData(RelocatableBuffer buffer, SymbolConsumer createSymbol, SymbolConsumer createSymbolReference) {
        assert (this.isLayouted()) : "Not layouted yet";
        ByteBuffer bufferBytes = buffer.getByteBuffer();
        int start = bufferBytes.position();
        assert (IntStream.range(start, start + this.totalSize).allMatch(i -> bufferBytes.get(i) == 0)) : "Buffer must be zero-initialized";
        for (CGlobalDataInfo info : this.map.values()) {
            byte[] bytes = info.getBytes();
            if (bytes != null) {
                bufferBytes.position(start + info.getOffset());
                bufferBytes.put(bytes, 0, bytes.length);
            }
            CGlobalDataImpl<?> data = info.getData();
            if (data.symbolName != null && !info.isSymbolReference()) {
                createSymbol.apply(info.getOffset(), data.symbolName, info.isGlobalSymbol());
            }
            if (!data.nonConstant || data.symbolName == null) continue;
            createSymbolReference.apply(info.getOffset(), data.symbolName, info.isGlobalSymbol());
        }
    }

    public static interface SymbolConsumer {
        public void apply(int var1, String var2, boolean var3);
    }
}

