/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.os;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.os.ImageHeapProvider;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.util.UnsignedUtils;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public abstract class AbstractImageHeapProvider
implements ImageHeapProvider {
    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getImageHeapAddressSpaceSize() {
        UnsignedWord pageSize = VirtualMemoryProvider.get().getGranularity();
        int imageHeapOffset = Heap.getHeap().getImageHeapOffsetInAddressSpace();
        assert (imageHeapOffset >= 0);
        UnsignedWord size = WordFactory.unsigned((int)imageHeapOffset);
        size = size.add(AbstractImageHeapProvider.getImageHeapSizeInFile());
        size = UnsignedUtils.roundUp(size, pageSize);
        return size;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getImageHeapSizeInFile() {
        Word imageHeapBegin = Isolates.IMAGE_HEAP_BEGIN.get();
        return Isolates.IMAGE_HEAP_END.get().subtract(imageHeapBegin);
    }
}

