/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jni.access;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.jni.access.JNIAccessibleClass;
import org.graalvm.collections.EconomicSet;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

abstract class JNIAccessibleMember {
    private final JNIAccessibleClass declaringClass;
    @UnknownObjectField(fullyQualifiedTypes={"org.graalvm.collections.EconomicMapImpl"}, canBeNull=true, availability=BuildPhaseProvider.ReadyForCompilation.class)
    private EconomicSet<Class<?>> hidingSubclasses;

    JNIAccessibleMember(JNIAccessibleClass declaringClass) {
        this.declaringClass = declaringClass;
    }

    public JNIAccessibleClass getDeclaringClass() {
        return this.declaringClass;
    }

    boolean isDiscoverableIn(Class<?> clazz) {
        Class<?> declaring = this.declaringClass.getClassObject();
        assert (clazz != null && declaring.isAssignableFrom(clazz));
        if (this.hidingSubclasses != null && !clazz.equals(declaring)) {
            Class<?> sup;
            if (this.hidingSubclasses.contains(clazz)) {
                return false;
            }
            if (declaring.isInterface()) {
                for (Class<?> iface : clazz.getInterfaces()) {
                    if (!declaring.isAssignableFrom(iface) || this.isDiscoverableIn(iface)) continue;
                    return false;
                }
            }
            if ((sup = clazz.getSuperclass()) != null && declaring.isAssignableFrom(sup) && !this.isDiscoverableIn(sup)) {
                return false;
            }
        }
        return true;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected void setHidingSubclasses(EconomicSet<Class<?>> hidingSubclasses) {
        assert (this.hidingSubclasses == null);
        this.hidingSubclasses = hidingSubclasses;
    }
}

