/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.core.MissingRegistrationUtils;
import com.oracle.svm.core.configure.ClassNameSupport;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.hub.PredefinedClassesSupport;
import com.oracle.svm.core.reflect.MissingReflectionRegistrationUtils;
import com.oracle.svm.core.util.ImageHeapMap;
import com.oracle.svm.core.util.VMError;
import java.io.Serializable;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@AutomaticallyRegisteredImageSingleton
public final class ClassForNameSupport {
    private final EconomicMap<String, Object> knownClasses = ImageHeapMap.create();
    private static final Object NEGATIVE_QUERY = new Object();

    static ClassForNameSupport singleton() {
        return (ClassForNameSupport)ImageSingletons.lookup(ClassForNameSupport.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerClass(Class<?> clazz) {
        assert (!clazz.isPrimitive()) : "primitive classes cannot be looked up by name";
        if (PredefinedClassesSupport.isPredefined(clazz)) {
            return;
        }
        String name = clazz.getName();
        Object currentValue = ClassForNameSupport.singleton().knownClasses.get((Object)name);
        VMError.guarantee(currentValue == null || currentValue == clazz || currentValue instanceof Throwable, "Invalid Class.forName value for %s: %s", name, currentValue);
        ClassForNameSupport.singleton().knownClasses.putIfAbsent((Object)name, clazz);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerExceptionForClass(String className, Throwable t) {
        ClassForNameSupport.singleton().knownClasses.put((Object)className, (Object)t);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerNegativeQuery(String className) {
        ClassForNameSupport.singleton().knownClasses.put((Object)className, NEGATIVE_QUERY);
    }

    public static Class<?> forNameOrNull(String className, ClassLoader classLoader) {
        try {
            return ClassForNameSupport.forName(className, classLoader, true);
        }
        catch (ClassNotFoundException e) {
            throw VMError.shouldNotReachHere("ClassForNameSupport.forNameOrNull should not throw", e);
        }
    }

    public static Class<?> forName(String className, ClassLoader classLoader) throws ClassNotFoundException {
        return ClassForNameSupport.forName(className, classLoader, false);
    }

    private static Class<?> forName(String className, ClassLoader classLoader, boolean returnNullOnException) throws ClassNotFoundException {
        if (className == null) {
            return null;
        }
        Serializable result = ClassForNameSupport.singleton().knownClasses.get((Object)className);
        if (result == NEGATIVE_QUERY) {
            result = new ClassNotFoundException(className);
        }
        if (result == null) {
            result = PredefinedClassesSupport.getLoadedForNameOrNull(className, classLoader);
        }
        if (result == null && !ClassNameSupport.isValidReflectionName(className)) {
            result = new ClassNotFoundException(className);
        }
        if (result instanceof Class) {
            return result;
        }
        if (result instanceof Throwable) {
            if (returnNullOnException) {
                return null;
            }
            if (result instanceof Error) {
                throw (Error)result;
            }
            if (result instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)result;
            }
        } else if (result == null) {
            if (MissingRegistrationUtils.throwMissingRegistrationErrors()) {
                MissingReflectionRegistrationUtils.forClass(className);
            }
            if (returnNullOnException) {
                return null;
            }
            throw new ClassNotFoundException(className);
        }
        throw VMError.shouldNotReachHere("Class.forName result should be Class, ClassNotFoundException or Error: " + String.valueOf(result));
    }

    public static int count() {
        return ClassForNameSupport.singleton().knownClasses.size();
    }
}

