/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunkVisitor;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.ReadOnlyHugeMemoryWalkerAccess;
import com.oracle.svm.core.genscavenge.ReadOnlyPrimitiveMemoryWalkerAccess;
import com.oracle.svm.core.genscavenge.ReadOnlyReferenceMemoryWalkerAccess;
import com.oracle.svm.core.genscavenge.ReadOnlyRelocatableMemoryWalkerAccess;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.genscavenge.WritableHugeMemoryWalkerAccess;
import com.oracle.svm.core.genscavenge.WritablePrimitiveMemoryWalkerAccess;
import com.oracle.svm.core.genscavenge.WritableReferenceMemoryWalkerAccess;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.os.CommittedMemoryProvider;
import com.oracle.svm.core.util.UnsignedUtils;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class ImageHeapWalker {
    private static final MemoryWalker.NativeImageHeapRegionAccess<ImageHeapInfo> READ_ONLY_PRIMITIVE_WALKER = new ReadOnlyPrimitiveMemoryWalkerAccess();
    private static final MemoryWalker.NativeImageHeapRegionAccess<ImageHeapInfo> READ_ONLY_REFERENCE_WALKER = new ReadOnlyReferenceMemoryWalkerAccess();
    private static final MemoryWalker.NativeImageHeapRegionAccess<ImageHeapInfo> READ_ONLY_RELOCATABLE_WALKER = new ReadOnlyRelocatableMemoryWalkerAccess();
    private static final MemoryWalker.NativeImageHeapRegionAccess<ImageHeapInfo> WRITABLE_PRIMITIVE_WALKER = new WritablePrimitiveMemoryWalkerAccess();
    private static final MemoryWalker.NativeImageHeapRegionAccess<ImageHeapInfo> WRITABLE_REFERENCE_WALKER = new WritableReferenceMemoryWalkerAccess();
    private static final MemoryWalker.NativeImageHeapRegionAccess<ImageHeapInfo> WRITABLE_HUGE_WALKER = new WritableHugeMemoryWalkerAccess();
    private static final MemoryWalker.NativeImageHeapRegionAccess<ImageHeapInfo> READ_ONLY_HUGE_WALKER = new ReadOnlyHugeMemoryWalkerAccess();

    private ImageHeapWalker() {
    }

    public static boolean walkRegions(ImageHeapInfo heapInfo, MemoryWalker.ImageHeapRegionVisitor visitor) {
        return visitor.visitNativeImageHeapRegion(heapInfo, READ_ONLY_PRIMITIVE_WALKER) && visitor.visitNativeImageHeapRegion(heapInfo, READ_ONLY_REFERENCE_WALKER) && visitor.visitNativeImageHeapRegion(heapInfo, READ_ONLY_RELOCATABLE_WALKER) && visitor.visitNativeImageHeapRegion(heapInfo, WRITABLE_PRIMITIVE_WALKER) && visitor.visitNativeImageHeapRegion(heapInfo, WRITABLE_REFERENCE_WALKER) && visitor.visitNativeImageHeapRegion(heapInfo, WRITABLE_HUGE_WALKER) && visitor.visitNativeImageHeapRegion(heapInfo, READ_ONLY_HUGE_WALKER);
    }

    public static boolean walkImageHeapObjects(ImageHeapInfo heapInfo, ObjectVisitor visitor) {
        return ImageHeapWalker.walkPartition(heapInfo.firstReadOnlyPrimitiveObject, heapInfo.lastReadOnlyPrimitiveObject, visitor, true) && ImageHeapWalker.walkPartition(heapInfo.firstReadOnlyReferenceObject, heapInfo.lastReadOnlyReferenceObject, visitor, true) && ImageHeapWalker.walkPartition(heapInfo.firstReadOnlyRelocatableObject, heapInfo.lastReadOnlyRelocatableObject, visitor, true) && ImageHeapWalker.walkPartition(heapInfo.firstWritablePrimitiveObject, heapInfo.lastWritablePrimitiveObject, visitor, true) && ImageHeapWalker.walkPartition(heapInfo.firstWritableReferenceObject, heapInfo.lastWritableReferenceObject, visitor, true) && ImageHeapWalker.walkPartition(heapInfo.firstWritableHugeObject, heapInfo.lastWritableHugeObject, visitor, false) && ImageHeapWalker.walkPartition(heapInfo.firstReadOnlyHugeObject, heapInfo.lastReadOnlyHugeObject, visitor, false);
    }

    public static void walkImageHeapChunks(ImageHeapInfo heapInfo, HeapChunkVisitor visitor) {
        Object firstUnalignedObject;
        if (!HeapImpl.usesImageHeapChunks()) {
            return;
        }
        Object firstObject = heapInfo.firstObject;
        if (ObjectHeaderImpl.isAlignedObject(firstObject)) {
            HeapChunk.Header<?> alignedChunks = ImageHeapWalker.getImageHeapChunkForObject(firstObject, true);
            ImageHeapWalker.walkChunks(alignedChunks, visitor, true);
        }
        if ((firstUnalignedObject = heapInfo.firstWritableHugeObject) == null) {
            firstUnalignedObject = heapInfo.firstReadOnlyHugeObject;
        }
        if (firstUnalignedObject != null) {
            HeapChunk.Header<?> unalignedChunks = ImageHeapWalker.getImageHeapChunkForObject(firstUnalignedObject, false);
            ImageHeapWalker.walkChunks(unalignedChunks, visitor, false);
        }
    }

    @NeverInline(value="Not performance critical")
    private static void walkChunks(HeapChunk.Header<?> firstChunk, HeapChunkVisitor visitor, boolean alignedChunks) {
        HeapChunk.Header<?> currentChunk = firstChunk;
        while (currentChunk.isNonNull()) {
            if (alignedChunks) {
                visitor.visitAlignedChunk((AlignedHeapChunk.AlignedHeader)currentChunk);
            } else {
                visitor.visitUnalignedChunk((UnalignedHeapChunk.UnalignedHeader)currentChunk);
            }
            currentChunk = HeapChunk.getNext(currentChunk);
        }
    }

    static boolean walkPartition(Object firstObject, Object lastObject, ObjectVisitor visitor, boolean alignedChunks) {
        return ImageHeapWalker.walkPartitionInline(firstObject, lastObject, visitor, alignedChunks, false);
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static boolean walkPartitionInline(Object firstObject, Object lastObject, ObjectVisitor visitor, boolean alignedChunks) {
        return ImageHeapWalker.walkPartitionInline(firstObject, lastObject, visitor, alignedChunks, true);
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean walkPartitionInline(Object firstObject, Object lastObject, ObjectVisitor visitor, boolean alignedChunks, boolean inlineObjectVisit) {
        if (firstObject == null || lastObject == null) {
            assert (firstObject == null && lastObject == null);
            return true;
        }
        Word firstPointer = Word.objectToUntrackedPointer((Object)firstObject);
        Word lastPointer = Word.objectToUntrackedPointer((Object)lastObject);
        Word current = firstPointer;
        HeapChunk.Header<?> currentChunk = (HeapChunk.Header<?>)WordFactory.nullPointer();
        if (HeapImpl.usesImageHeapChunks()) {
            currentChunk = ImageHeapWalker.getImageHeapChunkForObject(firstObject, alignedChunks);
        }
        do {
            Pointer chunkTop;
            Word limit = lastPointer;
            if (HeapImpl.usesImageHeapChunks() && lastPointer.aboveThan((UnsignedWord)(chunkTop = HeapChunk.getTopPointer(currentChunk)))) {
                limit = chunkTop.subtract(1);
            }
            while (current.belowOrEqual((UnsignedWord)limit)) {
                Object currentObject = current.toObject();
                if (inlineObjectVisit ? !ImageHeapWalker.visitObjectInline(visitor, currentObject) : !ImageHeapWalker.visitObject(visitor, currentObject)) {
                    return false;
                }
                current = LayoutEncoding.getImageHeapObjectEnd(current.toObject());
            }
            if (!HeapImpl.usesImageHeapChunks() || !current.belowThan((UnsignedWord)lastPointer)) continue;
            currentChunk = HeapChunk.getNext(currentChunk);
            Pointer pointer = current = alignedChunks ? AlignedHeapChunk.getObjectsStart((AlignedHeapChunk.AlignedHeader)currentChunk) : UnalignedHeapChunk.getObjectStart((UnalignedHeapChunk.UnalignedHeader)currentChunk);
        } while (current.belowOrEqual((UnsignedWord)lastPointer));
        return true;
    }

    @AlwaysInline(value="de-virtualize calls to ObjectReferenceVisitor")
    @Uninterruptible(reason="Bridge between uninterruptible and potentially interruptible code.", mayBeInlined=true, calleeMustBe=false)
    private static boolean visitObject(ObjectVisitor visitor, Object currentObject) {
        return visitor.visitObject(currentObject);
    }

    @Uninterruptible(reason="Bridge between uninterruptible and potentially interruptible code.", mayBeInlined=true, calleeMustBe=false)
    private static boolean visitObjectInline(ObjectVisitor visitor, Object currentObject) {
        return visitor.visitObjectInline(currentObject);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static HeapChunk.Header<?> getImageHeapChunkForObject(Object object, boolean alignedChunks) {
        Word objPtr = Word.objectToUntrackedPointer((Object)object);
        Pointer base = (Pointer)WordFactory.zero();
        if (!CommittedMemoryProvider.get().guaranteesHeapPreferredAddressSpaceAlignment()) {
            base = HeapImpl.getImageHeapStart();
        }
        Pointer offset = objPtr.subtract((UnsignedWord)base);
        UnsignedWord chunkOffset = alignedChunks ? UnsignedUtils.roundDown((UnsignedWord)offset, HeapParameters.getAlignedHeapChunkAlignment()) : offset.subtract(UnalignedHeapChunk.getObjectStartOffset());
        return (HeapChunk.Header)chunkOffset.add((UnsignedWord)base);
    }
}

