/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.TypeResult;
import com.oracle.svm.core.configure.ConfigurationConditionResolver;
import com.oracle.svm.core.configure.ConfigurationTypeDescriptor;
import com.oracle.svm.core.configure.ReflectionConfigurationParser;
import com.oracle.svm.core.configure.ReflectionConfigurationParserDelegate;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

class ReflectionMetadataParser<T>
extends ReflectionConfigurationParser<T> {
    private static final List<String> OPTIONAL_REFLECT_METADATA_ATTRS = Arrays.asList("condition", "allDeclaredConstructors", "allPublicConstructors", "allDeclaredMethods", "allPublicMethods", "allDeclaredFields", "allPublicFields", "methods", "fields", "unsafeAllocated", "serializable", "jniAccessible");

    ReflectionMetadataParser(String combinedFileKey, ConfigurationConditionResolver conditionResolver, ReflectionConfigurationParserDelegate<T> delegate, boolean strictConfiguration, boolean printMissingElements) {
        super(combinedFileKey, conditionResolver, delegate, strictConfiguration, printMissingElements);
    }

    @Override
    public void parseAndRegister(Object json, URI origin) {
        Object reflectionJson = this.getFromGlobalFile(json, this.combinedFileKey);
        if (reflectionJson != null) {
            this.parseClassArray(ReflectionMetadataParser.asList(reflectionJson, "first level of document must be an array of class descriptors"));
        }
    }

    @Override
    protected void parseClass(EconomicMap<String, Object> data) {
        boolean typeJniAccessible;
        this.checkAttributes(data, "reflection class descriptor object", List.of("type"), OPTIONAL_REFLECT_METADATA_ATTRS);
        Optional<ConfigurationTypeDescriptor> type = ReflectionMetadataParser.parseTypeContents(data.get((Object)"type"));
        if (type.isEmpty()) {
            return;
        }
        ConfigurationCondition unresolvedCondition = this.parseCondition(data, true);
        TypeResult<ConfigurationCondition> conditionResult = this.conditionResolver.resolveCondition(unresolvedCondition);
        if (!conditionResult.isPresent()) {
            return;
        }
        ConfigurationCondition condition = conditionResult.get();
        TypeResult result = this.delegate.resolveType(condition, type.get(), true);
        if (!result.isPresent()) {
            this.handleMissingElement("Could not resolve " + String.valueOf(type.get()) + " for reflection configuration.", result.getException());
            return;
        }
        ConfigurationCondition queryCondition = this.conditionResolver.alwaysTrue();
        Object clazz = result.get();
        this.delegate.registerType(conditionResult.get(), clazz);
        boolean jniParser = this.combinedFileKey.equals("jni");
        this.delegate.registerDeclaredClasses(queryCondition, clazz);
        this.delegate.registerPublicClasses(queryCondition, clazz);
        if (!jniParser) {
            this.delegate.registerRecordComponents(queryCondition, clazz);
            this.delegate.registerPermittedSubclasses(queryCondition, clazz);
            this.delegate.registerNestMembers(queryCondition, clazz);
            this.delegate.registerSigners(queryCondition, clazz);
        }
        this.delegate.registerDeclaredConstructors(queryCondition, true, jniParser, clazz);
        this.delegate.registerPublicConstructors(queryCondition, true, jniParser, clazz);
        this.delegate.registerDeclaredMethods(queryCondition, true, jniParser, clazz);
        this.delegate.registerPublicMethods(queryCondition, true, jniParser, clazz);
        this.delegate.registerDeclaredFields(queryCondition, true, jniParser, clazz);
        this.delegate.registerPublicFields(queryCondition, true, jniParser, clazz);
        if (jniParser) {
            typeJniAccessible = true;
        } else {
            this.registerIfNotDefault(data, false, clazz, "serializable", () -> this.delegate.registerAsSerializable(condition, clazz));
            typeJniAccessible = this.registerIfNotDefault(data, false, clazz, "jniAccessible", () -> this.delegate.registerAsJniAccessed(condition, clazz));
        }
        this.registerIfNotDefault(data, false, clazz, "allDeclaredConstructors", () -> this.delegate.registerDeclaredConstructors(condition, false, typeJniAccessible, clazz));
        this.registerIfNotDefault(data, false, clazz, "allPublicConstructors", () -> this.delegate.registerPublicConstructors(condition, false, typeJniAccessible, clazz));
        this.registerIfNotDefault(data, false, clazz, "allDeclaredMethods", () -> this.delegate.registerDeclaredMethods(condition, false, typeJniAccessible, clazz));
        this.registerIfNotDefault(data, false, clazz, "allPublicMethods", () -> this.delegate.registerPublicMethods(condition, false, typeJniAccessible, clazz));
        this.registerIfNotDefault(data, false, clazz, "allDeclaredFields", () -> this.delegate.registerDeclaredFields(condition, false, typeJniAccessible, clazz));
        this.registerIfNotDefault(data, false, clazz, "allPublicFields", () -> this.delegate.registerPublicFields(condition, false, typeJniAccessible, clazz));
        this.registerIfNotDefault(data, false, clazz, "unsafeAllocated", () -> this.delegate.registerUnsafeAllocated(condition, clazz));
        MapCursor cursor = data.getEntries();
        while (cursor.advance()) {
            String name = (String)cursor.getKey();
            Object value = cursor.getValue();
            try {
                switch (name) {
                    case "methods": {
                        this.parseMethods(condition, false, ReflectionMetadataParser.asList(value, "Attribute 'methods' must be an array of method descriptors"), clazz, typeJniAccessible);
                        break;
                    }
                    case "fields": {
                        this.parseFields(condition, ReflectionMetadataParser.asList(value, "Attribute 'fields' must be an array of field descriptors"), clazz, typeJniAccessible);
                    }
                }
            }
            catch (LinkageError e) {
                this.handleMissingElement("Could not register " + this.delegate.getTypeName(clazz) + ": " + name + " for reflection.", e);
            }
        }
    }
}

