/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow.context.bytecode;

import com.oracle.graal.pointsto.AnalysisPolicy;
import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AbstractSpecialInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.AbstractStaticInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.AbstractVirtualInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.ArrayElementsTypeFlow;
import com.oracle.graal.pointsto.flow.CallSiteSensitiveMethodTypeFlow;
import com.oracle.graal.pointsto.flow.CloneTypeFlow;
import com.oracle.graal.pointsto.flow.ContextInsensitiveFieldTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodFlowsGraphClone;
import com.oracle.graal.pointsto.flow.MethodFlowsGraphInfo;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.ProxyTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.flow.context.bytecode.BytecodeAnalysisContext;
import com.oracle.graal.pointsto.flow.context.bytecode.BytecodeAnalysisContextPolicy;
import com.oracle.graal.pointsto.flow.context.bytecode.BytecodeSensitiveSpecialInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.context.bytecode.BytecodeSensitiveStaticInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.context.bytecode.BytecodeSensitiveVirtualInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.context.bytecode.ContextSensitiveMultiTypeState;
import com.oracle.graal.pointsto.flow.context.bytecode.ContextSensitiveSingleTypeState;
import com.oracle.graal.pointsto.flow.context.bytecode.TypesObjectsIterator;
import com.oracle.graal.pointsto.flow.context.object.AllocationContextSensitiveObject;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.flow.context.object.ConstantContextSensitiveObject;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.typestate.MultiTypeState;
import com.oracle.graal.pointsto.typestate.PointsToStats;
import com.oracle.graal.pointsto.typestate.SingleTypeState;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.typestate.TypeStateUtils;
import com.oracle.graal.pointsto.typestore.ArrayElementsTypeStore;
import com.oracle.graal.pointsto.typestore.FieldTypeStore;
import com.oracle.graal.pointsto.typestore.SplitArrayElementsTypeStore;
import com.oracle.graal.pointsto.typestore.SplitFieldTypeStore;
import com.oracle.graal.pointsto.typestore.UnifiedArrayElementsTypeStore;
import com.oracle.graal.pointsto.typestore.UnifiedFieldTypeStore;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.ListUtils;
import com.oracle.svm.common.meta.MultiMethod;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.BitSet;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.options.OptionValues;

public final class BytecodeSensitiveAnalysisPolicy
extends AnalysisPolicy {
    private final BytecodeAnalysisContextPolicy contextPolicy = new BytecodeAnalysisContextPolicy();
    private static final ThreadLocal<ListUtils.UnsafeArrayListClosable<AnalysisObject>> doUnion2TL = new ThreadLocal();
    private static final ThreadLocal<ListUtils.UnsafeArrayListClosable<AnalysisObject>> doUnion2ObjectsTL = new ThreadLocal();
    private static ThreadLocal<ListUtils.UnsafeArrayListClosable<AnalysisObject>> intersectionArrayListTL = new ThreadLocal();

    public BytecodeSensitiveAnalysisPolicy(OptionValues options) {
        super(options);
    }

    @Override
    public boolean isContextSensitiveAnalysis() {
        return true;
    }

    public BytecodeAnalysisContextPolicy getContextPolicy() {
        return this.contextPolicy;
    }

    @Override
    public MethodTypeFlow createMethodTypeFlow(PointsToAnalysisMethod method) {
        return new CallSiteSensitiveMethodTypeFlow(this.options, method);
    }

    @Override
    public boolean needsConstantCache() {
        return true;
    }

    @Override
    public boolean isSummaryObject(AnalysisObject object) {
        return object.isContextInsensitiveObject();
    }

    @Override
    public boolean isMergingEnabled() {
        return true;
    }

    @Override
    public void noteMerge(PointsToAnalysis bb, TypeState t) {
        t.noteMerge(bb);
    }

    @Override
    public void noteMerge(PointsToAnalysis bb, AnalysisObject ... a) {
        for (AnalysisObject o : a) {
            o.noteMerge(bb);
        }
    }

    @Override
    public void noteMerge(PointsToAnalysis bb, AnalysisObject o) {
        o.noteMerge(bb);
    }

    @Override
    public boolean isContextSensitiveAllocation(PointsToAnalysis bb, AnalysisType type, AnalysisContext allocationContext) {
        return bb.trackConcreteAnalysisObjects(type);
    }

    @Override
    public AnalysisObject createHeapObject(PointsToAnalysis bb, AnalysisType type, BytecodePosition allocationSite, AnalysisContext allocationContext) {
        assert (this.allocationSiteSensitiveHeap);
        if (this.isContextSensitiveAllocation(bb, type, allocationContext)) {
            return new AllocationContextSensitiveObject(bb, type, allocationSite, allocationContext);
        }
        return type.getContextInsensitiveAnalysisObject();
    }

    @Override
    public AnalysisObject createConstantObject(PointsToAnalysis bb, JavaConstant constant, AnalysisType exactType) {
        if (bb.trackConcreteAnalysisObjects(exactType)) {
            return exactType.getCachedConstantObject(bb, constant, c -> new ConstantContextSensitiveObject(bb, exactType, (JavaConstant)c));
        }
        return exactType.getContextInsensitiveAnalysisObject();
    }

    @Override
    public TypeState constantTypeState(PointsToAnalysis bb, JavaConstant constant, AnalysisType exactType) {
        AnalysisObject constantObject = bb.analysisPolicy().createConstantObject(bb, constant, exactType);
        return TypeState.forNonNullObject(bb, constantObject);
    }

    @Override
    public TypeState dynamicNewInstanceState(PointsToAnalysis bb, TypeState currentState, TypeState newState, BytecodePosition allocationSite, AnalysisContext allocationContext) {
        TypeState resultState = TypeState.forEmpty();
        for (AnalysisType type : newState.types(bb)) {
            if (currentState.containsType(type)) continue;
            TypeState typeState = BytecodeSensitiveAnalysisPolicy.forAllocation(bb, allocationSite, type, allocationContext);
            resultState = TypeState.forUnion(bb, resultState, typeState);
        }
        assert (!resultState.canBeNull());
        return resultState;
    }

    @Override
    public TypeState cloneState(PointsToAnalysis bb, TypeState currentState, TypeState inputState, BytecodePosition cloneSite, AnalysisContext allocationContext) {
        TypeState resultState;
        if (inputState.isEmpty() || inputState.isNull()) {
            resultState = inputState.forNonNull(bb);
        } else {
            resultState = TypeState.forEmpty();
            for (AnalysisType type : inputState.types(bb)) {
                if (currentState.containsType(type)) continue;
                TypeState typeState = BytecodeSensitiveAnalysisPolicy.forClone(bb, cloneSite, type, allocationContext);
                resultState = TypeState.forUnion(bb, resultState, typeState);
            }
        }
        assert (!resultState.canBeNull());
        return resultState;
    }

    private static TypeState forClone(PointsToAnalysis bb, BytecodePosition cloneSite, AnalysisType type, AnalysisContext allocationContext) {
        return BytecodeSensitiveAnalysisPolicy.forAllocation(bb, cloneSite, type, allocationContext);
    }

    private static TypeState forAllocation(PointsToAnalysis bb, BytecodePosition allocationSite, AnalysisType objectType, AnalysisContext allocationContext) {
        assert (objectType.isArray() || objectType.isInstanceClass() && !Modifier.isAbstract(objectType.getModifiers())) : objectType;
        AnalysisObject allocationObject = bb.analysisPolicy().createHeapObject(bb, objectType, allocationSite, allocationContext);
        return TypeState.forNonNullObject(bb, allocationObject);
    }

    @Override
    public void linkClonedObjects(PointsToAnalysis bb, TypeFlow<?> inputFlow, CloneTypeFlow cloneFlow, BytecodePosition source) {
        TypeState inputState = inputFlow.getState();
        TypeState cloneState = cloneFlow.getState();
        for (AnalysisType type : inputState.types(bb)) {
            if (type.isArray()) {
                if (bb.analysisPolicy().aliasArrayTypeFlows()) continue;
                for (AnalysisObject originalObject : inputState.objects(type)) {
                    if (originalObject.isPrimitiveArray() || originalObject.isEmptyObjectArrayConstant(bb)) continue;
                    ArrayElementsTypeFlow originalObjectElementsFlow = originalObject.getArrayElementsFlow(bb, false);
                    for (AnalysisObject cloneObject : cloneState.objects(type)) {
                        if (cloneObject.isPrimitiveArray() || cloneObject.isEmptyObjectArrayConstant(bb)) continue;
                        ArrayElementsTypeFlow cloneObjectElementsFlow = cloneObject.getArrayElementsFlow(bb, true);
                        originalObjectElementsFlow.addUse(bb, cloneObjectElementsFlow);
                    }
                }
                continue;
            }
            for (AnalysisObject originalObject : inputState.objects(type)) {
                for (ResolvedJavaField javaField : type.getInstanceFields(true)) {
                    AnalysisField field = (AnalysisField)javaField;
                    FieldTypeFlow originalObjectFieldFlow = originalObject.getInstanceFieldFlow(bb, inputFlow, source, field, false);
                    for (AnalysisObject cloneObject : cloneState.objects(type)) {
                        FieldTypeFlow cloneObjectFieldFlow = cloneObject.getInstanceFieldFlow(bb, cloneFlow, source, field, true);
                        originalObjectFieldFlow.addUse(bb, cloneObjectFieldFlow);
                    }
                }
            }
        }
    }

    @Override
    public FieldTypeStore createFieldTypeStore(PointsToAnalysis bb, AnalysisObject object, AnalysisField field, AnalysisUniverse universe) {
        assert (this.allocationSiteSensitiveHeap);
        if (object.isContextInsensitiveObject()) {
            FieldTypeFlow writeFlow = new FieldTypeFlow(field, field.getType(), object);
            ContextInsensitiveFieldTypeFlow readFlow = new ContextInsensitiveFieldTypeFlow(field, field.getType(), object);
            return new SplitFieldTypeStore(field, object, writeFlow, readFlow);
        }
        return new UnifiedFieldTypeStore(field, object);
    }

    @Override
    public ArrayElementsTypeStore createArrayElementsTypeStore(AnalysisObject object, AnalysisUniverse universe) {
        assert (this.allocationSiteSensitiveHeap);
        if (object.type().isArray()) {
            if (this.aliasArrayTypeFlows) {
                if (object.type().getElementalType().isJavaLangObject() && object.isContextInsensitiveObject()) {
                    return new UnifiedArrayElementsTypeStore(object);
                }
                return universe.objectType().getArrayClass().getContextInsensitiveAnalysisObject().getArrayElementsTypeStore();
            }
            return BytecodeSensitiveAnalysisPolicy.getArrayElementsTypeStore(object);
        }
        return null;
    }

    private static ArrayElementsTypeStore getArrayElementsTypeStore(AnalysisObject object) {
        if (object.isContextInsensitiveObject()) {
            return new SplitArrayElementsTypeStore(object);
        }
        return new UnifiedArrayElementsTypeStore(object);
    }

    @Override
    public AbstractVirtualInvokeTypeFlow createVirtualInvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, PointsToAnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, MultiMethod.MultiMethodKey callerMultiMethodKey) {
        return new BytecodeSensitiveVirtualInvokeTypeFlow(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, callerMultiMethodKey);
    }

    @Override
    public AbstractSpecialInvokeTypeFlow createSpecialInvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, PointsToAnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, MultiMethod.MultiMethodKey callerMultiMethodKey) {
        return new BytecodeSensitiveSpecialInvokeTypeFlow(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, callerMultiMethodKey);
    }

    @Override
    public AbstractStaticInvokeTypeFlow createStaticInvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, PointsToAnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, MultiMethod.MultiMethodKey callerMultiMethodKey) {
        return new BytecodeSensitiveStaticInvokeTypeFlow(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, callerMultiMethodKey);
    }

    @Override
    public InvokeTypeFlow createDeoptInvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, PointsToAnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, MultiMethod.MultiMethodKey callerMultiMethodKey) {
        throw AnalysisError.shouldNotReachHere("This has not been implemented yet");
    }

    @Override
    public MethodFlowsGraphInfo staticRootMethodGraph(PointsToAnalysis bb, PointsToAnalysisMethod method) {
        return ((CallSiteSensitiveMethodTypeFlow)method.getTypeFlow()).addContext(bb, (AnalysisContext)this.contextPolicy.emptyContext(), null);
    }

    @Override
    public AnalysisContext allocationContext(PointsToAnalysis bb, MethodFlowsGraph callerGraph) {
        return this.contextPolicy.allocationContext((BytecodeAnalysisContext)((MethodFlowsGraphClone)callerGraph).context(), this.maxHeapContextDepth);
    }

    @Override
    public TypeFlow<?> proxy(BytecodePosition source, TypeFlow<?> input) {
        return new ProxyTypeFlow(source, input);
    }

    @Override
    public boolean addOriginalUse(PointsToAnalysis bb, TypeFlow<?> flow, TypeFlow<?> use) {
        return flow.addUse(bb, use, false);
    }

    @Override
    public boolean addOriginalObserver(PointsToAnalysis bb, TypeFlow<?> flow, TypeFlow<?> observer) {
        return flow.addObserver(bb, observer, false);
    }

    @Override
    public void linkActualReturn(PointsToAnalysis bb, boolean isStatic, InvokeTypeFlow invoke) {
    }

    @Override
    public void registerAsImplementationInvoked(InvokeTypeFlow invoke, PointsToAnalysisMethod method) {
        if (invoke.isContextInsensitive()) {
            method.registerAsImplementationInvoked(invoke);
        } else {
            method.registerAsImplementationInvoked(invoke.getOriginalInvoke());
        }
    }

    static BytecodeAnalysisContextPolicy contextPolicy(BigBang bb) {
        return ((BytecodeSensitiveAnalysisPolicy)bb.analysisPolicy()).getContextPolicy();
    }

    @Override
    public TypeState forContextInsensitiveTypeState(PointsToAnalysis bb, TypeState state) {
        if (state.isEmpty() || state.isNull()) {
            return state;
        }
        if (state instanceof SingleTypeState) {
            AnalysisType type = state.exactType();
            AnalysisObject analysisObject = state.asConstant() != null ? state.objects(bb).iterator().next() : type.getContextInsensitiveAnalysisObject();
            return this.singleTypeState(bb, state.canBeNull(), analysisObject.type(), analysisObject);
        }
        ContextSensitiveMultiTypeState multiState = (ContextSensitiveMultiTypeState)state;
        AnalysisObject[] objectsArray = new AnalysisObject[multiState.typesCount()];
        int i = 0;
        for (AnalysisType type : multiState.types(bb)) {
            objectsArray[i++] = type.getContextInsensitiveAnalysisObject();
        }
        return this.multiTypeState(bb, multiState.canBeNull(), multiState.bitSet(), multiState.typesCount(), objectsArray);
    }

    @Override
    public SingleTypeState singleTypeState(PointsToAnalysis bb, boolean canBeNull, AnalysisType type, AnalysisObject ... objects) {
        return new ContextSensitiveSingleTypeState(bb, canBeNull, type, objects);
    }

    @Override
    public MultiTypeState multiTypeState(PointsToAnalysis bb, boolean canBeNull, BitSet typesBitSet, int typesCount, AnalysisObject ... objects) {
        return new ContextSensitiveMultiTypeState(bb, canBeNull, typesBitSet, typesCount, objects);
    }

    @Override
    public TypeState doUnion(PointsToAnalysis bb, SingleTypeState state1, SingleTypeState state2) {
        boolean resultCanBeNull;
        if (state1.equals(state2)) {
            return state1;
        }
        ContextSensitiveSingleTypeState s1 = (ContextSensitiveSingleTypeState)state1;
        ContextSensitiveSingleTypeState s2 = (ContextSensitiveSingleTypeState)state2;
        boolean bl = resultCanBeNull = s1.canBeNull() || s2.canBeNull();
        if (s1.exactType().equals(s2.exactType())) {
            Object[] resultObjects = TypeStateUtils.union(bb, s1.objects, s2.objects);
            if (resultObjects == s1.objects) {
                return s1.forCanBeNull(bb, resultCanBeNull);
            }
            if (resultObjects == s2.objects) {
                return s2.forCanBeNull(bb, resultCanBeNull);
            }
            assert (!bb.extendedAsserts() || !Arrays.equals(resultObjects, s1.objects) && !Arrays.equals(resultObjects, s2.objects));
            ContextSensitiveSingleTypeState result = new ContextSensitiveSingleTypeState(bb, resultCanBeNull, s1.exactType(), (AnalysisObject[])resultObjects);
            assert (!s1.equals(result) && !s2.equals(result));
            PointsToStats.registerUnionOperation(bb, s1, s2, result);
            return result;
        }
        AnalysisObject[] resultObjects = s1.exactType().getId() < s2.exactType().getId() ? TypeStateUtils.concat(s1.objects, s2.objects) : TypeStateUtils.concat(s2.objects, s1.objects);
        BitSet typesBitSet = TypeStateUtils.newBitSet(s1.exactType().getId(), s2.exactType().getId());
        assert (typesBitSet.cardinality() == 2);
        ContextSensitiveMultiTypeState result = new ContextSensitiveMultiTypeState(bb, resultCanBeNull, typesBitSet, 2, resultObjects);
        PointsToStats.registerUnionOperation(bb, s1, s2, result);
        return result;
    }

    @Override
    public TypeState doUnion(PointsToAnalysis bb, MultiTypeState state1, SingleTypeState state2) {
        AnalysisObject[] resultObjects;
        ContextSensitiveMultiTypeState s1 = (ContextSensitiveMultiTypeState)state1;
        ContextSensitiveSingleTypeState s2 = (ContextSensitiveSingleTypeState)state2;
        boolean resultCanBeNull = s1.canBeNull() || s2.canBeNull();
        AnalysisObject[] so1 = s1.objects;
        AnalysisObject[] so2 = s2.objects;
        if (so2.length == 1 && BytecodeSensitiveAnalysisPolicy.containsObject(s1, so2[0])) {
            return s1.forCanBeNull(bb, resultCanBeNull);
        }
        if (s1.containsType(s2.exactType())) {
            ContextSensitiveMultiTypeState.Range typeRange = s1.findTypeRange(s2.exactType());
            Object[] s1ObjectsSlice = s1.objectsArray(typeRange);
            Object[] unionObjects = TypeStateUtils.union(bb, (AnalysisObject[])s1ObjectsSlice, so2);
            if (unionObjects == s1ObjectsSlice) {
                return s1.forCanBeNull(bb, resultCanBeNull);
            }
            assert (!bb.extendedAsserts() || !Arrays.equals(unionObjects, s1ObjectsSlice));
            int resultSize = so1.length + unionObjects.length - s1ObjectsSlice.length;
            AnalysisObject[] resultObjects2 = new AnalysisObject[resultSize];
            System.arraycopy(so1, 0, resultObjects2, 0, typeRange.left());
            System.arraycopy(unionObjects, 0, resultObjects2, typeRange.left(), unionObjects.length);
            System.arraycopy(so1, typeRange.right(), resultObjects2, typeRange.left() + unionObjects.length, so1.length - typeRange.right());
            ContextSensitiveMultiTypeState result = new ContextSensitiveMultiTypeState(bb, resultCanBeNull, s1.bitSet(), s1.typesCount(), resultObjects2);
            assert (!((MultiTypeState)result).equals(s1));
            PointsToStats.registerUnionOperation(bb, s1, s2, result);
            return result;
        }
        if (s2.exactType().getId() < s1.firstTypeId()) {
            resultObjects = TypeStateUtils.concat(so2, so1);
        } else if (s2.exactType().getId() > s1.lastTypeId()) {
            resultObjects = TypeStateUtils.concat(so1, so2);
        } else {
            int idx1;
            for (idx1 = 0; idx1 < so1.length && so1[idx1].getTypeId() < s2.exactType().getId(); ++idx1) {
            }
            resultObjects = new AnalysisObject[so1.length + so2.length];
            System.arraycopy(so1, 0, resultObjects, 0, idx1);
            System.arraycopy(so2, 0, resultObjects, idx1, so2.length);
            System.arraycopy(so1, idx1, resultObjects, idx1 + so2.length, so1.length - idx1);
        }
        BitSet typesBitSet = TypeStateUtils.set(s1.bitSet(), s2.exactType().getId());
        int typesCount = s1.typesCount() + 1;
        assert (typesCount == typesBitSet.cardinality());
        ContextSensitiveMultiTypeState result = new ContextSensitiveMultiTypeState(bb, resultCanBeNull, typesBitSet, typesCount, resultObjects);
        PointsToStats.registerUnionOperation(bb, s1, s2, result);
        return result;
    }

    public static boolean containsObject(ContextSensitiveMultiTypeState state, AnalysisObject object) {
        return state.containsType(object.type()) && Arrays.binarySearch(state.objects, object) >= 0;
    }

    @Override
    public TypeState doUnion(PointsToAnalysis bb, MultiTypeState state1, MultiTypeState state2) {
        boolean resultCanBeNull;
        ContextSensitiveMultiTypeState s1 = (ContextSensitiveMultiTypeState)state1;
        ContextSensitiveMultiTypeState s2 = (ContextSensitiveMultiTypeState)state2;
        assert (s1.objectsCount() >= s2.objectsCount()) : "Union is commutative, must call it with s1 being the bigger state";
        boolean bl = resultCanBeNull = s1.canBeNull() || s2.canBeNull();
        if (s1.objects == s2.objects) {
            return s1.forCanBeNull(bb, resultCanBeNull);
        }
        return this.doUnion0(bb, s1, s2, resultCanBeNull);
    }

    private TypeState doUnion0(PointsToAnalysis bb, ContextSensitiveMultiTypeState s1, ContextSensitiveMultiTypeState s2, boolean resultCanBeNull) {
        if (s1.lastTypeId() < s2.firstTypeId()) {
            AnalysisObject[] resultObjects = TypeStateUtils.concat(s1.objects, s2.objects);
            BitSet resultTypesBitSet = TypeStateUtils.or(s1.bitSet(), s2.bitSet());
            int typesCount = s1.typesCount() + s2.typesCount();
            assert (typesCount == resultTypesBitSet.cardinality());
            ContextSensitiveMultiTypeState result = new ContextSensitiveMultiTypeState(bb, resultCanBeNull, resultTypesBitSet, typesCount, resultObjects);
            PointsToStats.registerUnionOperation(bb, s1, s2, result);
            return result;
        }
        if (s2.lastTypeId() < s1.firstTypeId()) {
            AnalysisObject[] resultObjects = TypeStateUtils.concat(s2.objects, s1.objects);
            BitSet resultTypesBitSet = TypeStateUtils.or(s1.bitSet(), s2.bitSet());
            int typesCount = s1.typesCount() + s2.typesCount();
            assert (typesCount == resultTypesBitSet.cardinality());
            ContextSensitiveMultiTypeState result = new ContextSensitiveMultiTypeState(bb, resultCanBeNull, resultTypesBitSet, typesCount, resultObjects);
            PointsToStats.registerUnionOperation(bb, s1, s2, result);
            return result;
        }
        return this.doUnion1(bb, s1, s2, resultCanBeNull);
    }

    private TypeState doUnion1(PointsToAnalysis bb, ContextSensitiveMultiTypeState s1, ContextSensitiveMultiTypeState s2, boolean resultCanBeNull) {
        if (this.allocationSiteSensitiveHeap) {
            return this.allocationSensitiveSpeculativeUnion1(bb, s1, s2, resultCanBeNull);
        }
        return this.allocationInsensitiveSpeculativeUnion1(bb, s1, s2, resultCanBeNull);
    }

    private TypeState allocationInsensitiveSpeculativeUnion1(PointsToAnalysis bb, ContextSensitiveMultiTypeState s1, ContextSensitiveMultiTypeState s2, boolean resultCanBeNull) {
        if (s1.bitSet().length() >= s2.bitSet().length()) {
            long[] bits1 = TypeStateUtils.extractBitSetField(s1.bitSet());
            long[] bits2 = TypeStateUtils.extractBitSetField(s2.bitSet());
            assert (s2.bitSet().cardinality() == s2.objects.length) : "Cardinality and length of objects must match.";
            boolean speculate = true;
            int numberOfWords = Math.min(bits1.length, bits2.length);
            for (int i = 0; i < numberOfWords; ++i) {
                if ((bits1[i] & bits2[i]) == bits2[i]) continue;
                speculate = false;
                break;
            }
            if (speculate) {
                return s1.forCanBeNull(bb, resultCanBeNull);
            }
        }
        return this.doUnion2(bb, s1, s2, resultCanBeNull, 0, 0);
    }

    private TypeState allocationSensitiveSpeculativeUnion1(PointsToAnalysis bb, ContextSensitiveMultiTypeState s1, ContextSensitiveMultiTypeState s2, boolean resultCanBeNull) {
        int idx1 = 0;
        int idx2 = 0;
        AnalysisPolicy analysisPolicy = bb.analysisPolicy();
        AnalysisObject[] so1 = s1.objects;
        AnalysisObject[] so2 = s2.objects;
        while (idx1 < so1.length && idx2 < so2.length) {
            AnalysisObject o1 = so1[idx1];
            AnalysisObject o2 = so2[idx2];
            if (analysisPolicy.isSummaryObject(o1) && o1.getTypeId() == o2.getTypeId()) {
                ++idx1;
                while (idx2 < s2.objectsCount() && so2[idx2].getTypeId() == o1.getTypeId()) {
                    analysisPolicy.noteMerge(bb, so2[idx2]);
                    ++idx2;
                }
            } else if (o1.getId() < o2.getId()) {
                ++idx1;
            } else {
                if (o1.getId() != o2.getId()) break;
                ++idx1;
                ++idx2;
            }
            if (idx2 != so2.length) continue;
            return s1.forCanBeNull(bb, resultCanBeNull);
        }
        return this.doUnion2(bb, s1, s2, resultCanBeNull, idx1, idx2);
    }

    private TypeState doUnion2(PointsToAnalysis bb, ContextSensitiveMultiTypeState s1, ContextSensitiveMultiTypeState s2, boolean resultCanBeNull, int startId1, int startId2) {
        try (ListUtils.UnsafeArrayListClosable<AnalysisObject> resultObjectsClosable = ListUtils.getTLArrayList(doUnion2TL, s1.objects.length + s2.objects.length);){
            TypeState typeState;
            ListUtils.UnsafeArrayList<AnalysisObject> resultObjects = resultObjectsClosable.list();
            AnalysisObject[] objects = s1.objects;
            resultObjects.addAll(objects, 0, startId1);
            int idx1 = startId1;
            int idx2 = startId2;
            try (ListUtils.UnsafeArrayListClosable<AnalysisObject> tlUnionObjectsClosable = ListUtils.getTLArrayList(doUnion2ObjectsTL, s1.objects.length + s2.objects.length);){
                ListUtils.UnsafeArrayList<AnalysisObject> unionObjects = tlUnionObjectsClosable.list();
                AnalysisObject[] so1 = s1.objects;
                AnalysisObject[] so2 = s2.objects;
                AnalysisPolicy analysisPolicy = bb.analysisPolicy();
                while (idx1 < so1.length && idx2 < so2.length) {
                    AnalysisObject o1 = so1[idx1];
                    AnalysisObject o2 = so2[idx2];
                    int t1 = o1.getTypeId();
                    int t2 = o2.getTypeId();
                    if (analysisPolicy.isSummaryObject(o1) && t1 == t2) {
                        unionObjects.add(o1);
                        while (idx2 < so2.length && t1 == so2[idx2].getTypeId()) {
                            analysisPolicy.noteMerge(bb, so2[idx2]);
                            ++idx2;
                        }
                        ++idx1;
                        continue;
                    }
                    if (analysisPolicy.isSummaryObject(o2) && t1 == t2) {
                        unionObjects.add(o2);
                        while (idx1 < so1.length && so1[idx1].getTypeId() == t2) {
                            analysisPolicy.noteMerge(bb, so1[idx1]);
                            ++idx1;
                        }
                        ++idx2;
                        continue;
                    }
                    if (o1.getId() < o2.getId()) {
                        unionObjects.add(o1);
                        ++idx1;
                        continue;
                    }
                    if (o1.getId() > o2.getId()) {
                        unionObjects.add(o2);
                        ++idx2;
                        continue;
                    }
                    assert (o1.equals(o2));
                    unionObjects.add(o1);
                    ++idx1;
                    ++idx2;
                }
                if (this.limitObjectArrayLength && unionObjects.size() > this.maxObjectSetSize) {
                    int idxStart = 0;
                    int idxEnd = 0;
                    while (idxEnd < unionObjects.size()) {
                        AnalysisObject oStart = unionObjects.get(idxStart);
                        while (idxEnd < unionObjects.size() && oStart.equals(unionObjects.get(idxEnd))) {
                            ++idxEnd;
                        }
                        int size = idxEnd - idxStart;
                        if (size > this.maxObjectSetSize) {
                            for (int i = idxStart; i < idxEnd; ++i) {
                                bb.analysisPolicy().noteMerge(bb, unionObjects.get(i));
                            }
                            resultObjects.add(oStart.type().getContextInsensitiveAnalysisObject());
                        } else {
                            resultObjects.addAll(unionObjects.elementData(), idxStart, idxEnd);
                        }
                        idxStart = idxEnd;
                    }
                } else {
                    resultObjects.addAll(unionObjects.elementData(), 0, unionObjects.size());
                }
            }
            if (idx1 < s1.objects.length) {
                resultObjects.addAll(s1.objects, idx1, s1.objects.length);
            } else if (idx2 < s2.objects.length) {
                resultObjects.addAll(s2.objects, idx2, s2.objects.length);
            }
            assert (resultObjects.size() > 1) : "The result state of a (Multi U Multi) operation must have at least 2 objects";
            BitSet resultTypesBitSet = TypeStateUtils.or(s1.bitSet(), s2.bitSet());
            ContextSensitiveMultiTypeState result = new ContextSensitiveMultiTypeState(bb, resultCanBeNull, resultTypesBitSet, resultTypesBitSet.cardinality(), resultObjects.copyToArray(new AnalysisObject[resultObjects.size()]));
            assert (!((MultiTypeState)result).equals(s1)) : "speculation code should prevent this case";
            if (s1.typesCount() == s2.typesCount() && ((MultiTypeState)result).equals(s2)) {
                typeState = s2.forCanBeNull(bb, resultCanBeNull);
                return typeState;
            }
            PointsToStats.registerUnionOperation(bb, s1, s2, result);
            typeState = result;
            return typeState;
        }
    }

    @Override
    public TypeState doIntersection(PointsToAnalysis bb, MultiTypeState s1, SingleTypeState s2) {
        boolean resultCanBeNull;
        assert (!bb.extendedAsserts() || TypeStateUtils.isContextInsensitiveTypeState(bb, s2)) : "Current implementation limitation.";
        boolean bl = resultCanBeNull = s1.canBeNull() && s2.canBeNull();
        if (s1.containsType(s2.exactType())) {
            AnalysisObject[] resultObjects = ((ContextSensitiveMultiTypeState)s1).objectsArray(s2.exactType());
            assert (TypeStateUtils.holdsSingleTypeState(resultObjects));
            return new ContextSensitiveSingleTypeState(bb, resultCanBeNull, s2.exactType(), resultObjects);
        }
        return TypeState.forEmpty().forCanBeNull(bb, resultCanBeNull);
    }

    @Override
    public TypeState doIntersection(PointsToAnalysis bb, MultiTypeState state1, MultiTypeState state2) {
        boolean resultCanBeNull;
        ContextSensitiveMultiTypeState s1 = (ContextSensitiveMultiTypeState)state1;
        ContextSensitiveMultiTypeState s2 = (ContextSensitiveMultiTypeState)state2;
        assert (!bb.extendedAsserts() || TypeStateUtils.isContextInsensitiveTypeState(bb, s2)) : "Current implementation limitation.";
        boolean bl = resultCanBeNull = s1.canBeNull() && s2.canBeNull();
        if (s1.objects == s2.objects) {
            return s1.forCanBeNull(bb, resultCanBeNull);
        }
        return BytecodeSensitiveAnalysisPolicy.doIntersection0(bb, s1, s2, resultCanBeNull);
    }

    private static TypeState doIntersection0(PointsToAnalysis bb, ContextSensitiveMultiTypeState s1, ContextSensitiveMultiTypeState s2, boolean resultCanBeNull) {
        if (s1.bitSet().equals(s2.bitSet())) {
            return s1.forCanBeNull(bb, resultCanBeNull);
        }
        if (!s1.bitSet().intersects(s2.bitSet())) {
            return TypeState.forEmpty().forCanBeNull(bb, resultCanBeNull);
        }
        return BytecodeSensitiveAnalysisPolicy.doIntersection1(bb, s1, s2, resultCanBeNull);
    }

    private static TypeState doIntersection1(PointsToAnalysis bb, ContextSensitiveMultiTypeState s1, ContextSensitiveMultiTypeState s2, boolean resultCanBeNull) {
        int idx1 = 0;
        int idx2 = 0;
        AnalysisObject[] so1 = s1.objects;
        AnalysisObject[] so2 = s2.objects;
        while (idx2 < so2.length) {
            AnalysisObject o1 = so1[idx1];
            AnalysisObject o2 = so2[idx2];
            assert (o2.isContextInsensitiveObject()) : "Current implementation limitation.";
            if (o1.getTypeId() > o2.getTypeId()) {
                ++idx2;
            } else {
                if (o1.getTypeId() != o2.getTypeId()) break;
                while (idx1 < so1.length && so1[idx1].getTypeId() == o2.getTypeId()) {
                    ++idx1;
                }
                ++idx2;
            }
            if (idx1 != so1.length) continue;
            return s1.forCanBeNull(bb, resultCanBeNull);
        }
        return BytecodeSensitiveAnalysisPolicy.doIntersection2(bb, s1, s2, resultCanBeNull, idx1, idx2);
    }

    private static TypeState doIntersection2(PointsToAnalysis bb, ContextSensitiveMultiTypeState s1, ContextSensitiveMultiTypeState s2, boolean resultCanBeNull, int idx1Param, int idx2Param) {
        try (ListUtils.UnsafeArrayListClosable<AnalysisObject> tlArrayClosable = ListUtils.getTLArrayList(intersectionArrayListTL, 256);){
            ListUtils.UnsafeArrayList<AnalysisObject> resultObjects = tlArrayClosable.list();
            AnalysisObject[] so1 = s1.objects;
            AnalysisObject[] so2 = s2.objects;
            int[] types1 = s1.getObjectTypeIds();
            int[] types2 = s2.getObjectTypeIds();
            int idx1 = idx1Param;
            int idx2 = idx2Param;
            int l1 = so1.length;
            int l2 = so2.length;
            int t1 = types1[idx1];
            int t2 = types2[idx2];
            while (idx1 < l1 && idx2 < l2) {
                assert (so2[idx2].isContextInsensitiveObject()) : "Current implementation limitation.";
                if (t1 == t2) {
                    assert (so1[idx1].type().equals(so2[idx2].type()));
                    resultObjects.add(so1[idx1]);
                    t1 = types1[++idx1];
                    continue;
                }
                if (t1 < t2) {
                    t1 = types1[++idx1];
                    continue;
                }
                if (t1 <= t2) continue;
                t2 = types2[++idx2];
            }
            int totalLength = idx1Param + resultObjects.size();
            if (totalLength == 0) {
                TypeState typeState = TypeState.forEmpty().forCanBeNull(bb, resultCanBeNull);
                return typeState;
            }
            AnalysisObject[] objects = new AnalysisObject[totalLength];
            resultObjects.copyToArray(objects, idx1Param);
            System.arraycopy(s1.objects, 0, objects, 0, idx1Param);
            if (TypeStateUtils.holdsSingleTypeState(objects, objects.length)) {
                ContextSensitiveSingleTypeState contextSensitiveSingleTypeState = new ContextSensitiveSingleTypeState(bb, resultCanBeNull, objects[0].type(), objects);
                return contextSensitiveSingleTypeState;
            }
            BitSet resultTypesBitSet = TypeStateUtils.and(s1.bitSet(), s2.bitSet());
            ContextSensitiveMultiTypeState result = new ContextSensitiveMultiTypeState(bb, resultCanBeNull, resultTypesBitSet, resultTypesBitSet.cardinality(), objects);
            if (s1.typesCount() == s2.typesCount() && ((MultiTypeState)result).equals(s1)) {
                TypeState typeState = s1.forCanBeNull(bb, resultCanBeNull);
                return typeState;
            }
            ContextSensitiveMultiTypeState contextSensitiveMultiTypeState = result;
            return contextSensitiveMultiTypeState;
        }
    }

    @Override
    public TypeState doSubtraction(PointsToAnalysis bb, MultiTypeState state1, SingleTypeState state2) {
        boolean resultCanBeNull;
        ContextSensitiveMultiTypeState s1 = (ContextSensitiveMultiTypeState)state1;
        ContextSensitiveSingleTypeState s2 = (ContextSensitiveSingleTypeState)state2;
        boolean bl = resultCanBeNull = s1.canBeNull() && !s2.canBeNull();
        if (s1.containsType(s2.exactType())) {
            assert (!bb.extendedAsserts() || TypeStateUtils.isContextInsensitiveTypeState(bb, s2)) : "Current implementation limitation.";
            ContextSensitiveMultiTypeState.Range typeRange = s1.findTypeRange(s2.exactType());
            int newLength = s1.objects.length - (typeRange.right() - typeRange.left());
            AnalysisObject[] resultObjects = new AnalysisObject[newLength];
            System.arraycopy(s1.objects, 0, resultObjects, 0, typeRange.left());
            System.arraycopy(s1.objects, typeRange.right(), resultObjects, typeRange.left(), s1.objects.length - typeRange.right());
            if (resultObjects.length == 1) {
                return new ContextSensitiveSingleTypeState(bb, resultCanBeNull, resultObjects[0].type(), resultObjects[0]);
            }
            if (TypeStateUtils.holdsSingleTypeState(resultObjects)) {
                return new ContextSensitiveSingleTypeState(bb, resultCanBeNull, resultObjects[0].type(), resultObjects);
            }
            BitSet resultTypesBitSet = TypeStateUtils.clear(s1.bitSet(), s2.exactType().getId());
            int typesCount = s1.typesCount() - 1;
            assert (typesCount == resultTypesBitSet.cardinality());
            return new ContextSensitiveMultiTypeState(bb, resultCanBeNull, resultTypesBitSet, typesCount, resultObjects);
        }
        return s1.forCanBeNull(bb, resultCanBeNull);
    }

    @Override
    public TypeState doSubtraction(PointsToAnalysis bb, MultiTypeState state1, MultiTypeState state2) {
        boolean resultCanBeNull;
        ContextSensitiveMultiTypeState s1 = (ContextSensitiveMultiTypeState)state1;
        ContextSensitiveMultiTypeState s2 = (ContextSensitiveMultiTypeState)state2;
        boolean bl = resultCanBeNull = s1.canBeNull() && !s2.canBeNull();
        if (s1.objects == s2.objects) {
            return TypeState.forEmpty().forCanBeNull(bb, resultCanBeNull);
        }
        return BytecodeSensitiveAnalysisPolicy.doSubtraction0(bb, s1, s2, resultCanBeNull);
    }

    private static TypeState doSubtraction0(PointsToAnalysis bb, ContextSensitiveMultiTypeState s1, ContextSensitiveMultiTypeState s2, boolean resultCanBeNull) {
        if (s1.bitSet().equals(s2.bitSet())) {
            return TypeState.forEmpty().forCanBeNull(bb, resultCanBeNull);
        }
        if (!s1.bitSet().intersects(s2.bitSet())) {
            return s1.forCanBeNull(bb, resultCanBeNull);
        }
        return BytecodeSensitiveAnalysisPolicy.doSubtraction1(bb, s1, s2, resultCanBeNull);
    }

    private static TypeState doSubtraction1(PointsToAnalysis bb, ContextSensitiveMultiTypeState s1, ContextSensitiveMultiTypeState s2, boolean resultCanBeNull) {
        int idx2;
        int idx1;
        block3: {
            idx1 = 0;
            idx2 = 0;
            AnalysisObject[] so1 = s1.objects;
            AnalysisObject[] so2 = s2.objects;
            while (true) {
                AnalysisObject o1 = so1[idx1];
                AnalysisObject o2 = so2[idx2];
                assert (o2.isContextInsensitiveObject()) : "Current implementation limitation.";
                if (o1.getTypeId() < o2.getTypeId()) {
                    if (++idx1 != so1.length) continue;
                    return s1.forCanBeNull(bb, resultCanBeNull);
                }
                if (o1.getTypeId() <= o2.getTypeId()) break block3;
                if (++idx2 == so2.length) break;
            }
            return s1.forCanBeNull(bb, resultCanBeNull);
        }
        return BytecodeSensitiveAnalysisPolicy.doSubtraction2(bb, s1, s2, resultCanBeNull, idx1, idx2);
    }

    private static TypeState doSubtraction2(PointsToAnalysis bb, ContextSensitiveMultiTypeState s1, ContextSensitiveMultiTypeState s2, boolean resultCanBeNull, int idx1Param, int idx2Param) {
        try (ListUtils.UnsafeArrayListClosable<AnalysisObject> tlArrayClosable = ListUtils.getTLArrayList(intersectionArrayListTL, 256);){
            ListUtils.UnsafeArrayList<AnalysisObject> resultObjects = tlArrayClosable.list();
            AnalysisObject[] so1 = s1.objects;
            AnalysisObject[] so2 = s2.objects;
            int[] types1 = s1.getObjectTypeIds();
            int[] types2 = s2.getObjectTypeIds();
            int idx1 = idx1Param;
            int idx2 = idx2Param;
            int l1 = so1.length;
            int l2 = so2.length;
            int t1 = types1[idx1];
            int t2 = types2[idx2];
            while (idx1 < l1 && idx2 < l2) {
                assert (so2[idx2].isContextInsensitiveObject()) : "Current implementation limitation.";
                if (t1 < t2) {
                    resultObjects.add(so1[idx1]);
                    t1 = types1[++idx1];
                    continue;
                }
                if (t1 > t2) {
                    t2 = types2[++idx2];
                    continue;
                }
                if (t1 != t2) continue;
                assert (so1[idx1].type().equals(so2[idx2].type()));
                t1 = types1[++idx1];
            }
            int remainder = s1.objects.length - idx1;
            int totalLength = idx1Param + resultObjects.size() + remainder;
            if (totalLength == 0) {
                TypeState typeState = TypeState.forEmpty().forCanBeNull(bb, resultCanBeNull);
                return typeState;
            }
            AnalysisObject[] objects = new AnalysisObject[totalLength];
            resultObjects.copyToArray(objects, idx1Param);
            System.arraycopy(s1.objects, 0, objects, 0, idx1Param);
            System.arraycopy(s1.objects, idx1, objects, totalLength - remainder, remainder);
            if (TypeStateUtils.holdsSingleTypeState(objects, totalLength)) {
                ContextSensitiveSingleTypeState contextSensitiveSingleTypeState = new ContextSensitiveSingleTypeState(bb, resultCanBeNull, objects[0].type(), objects);
                return contextSensitiveSingleTypeState;
            }
            BitSet resultTypesBitSet = TypeStateUtils.andNot(s1.bitSet(), s2.bitSet());
            ContextSensitiveMultiTypeState contextSensitiveMultiTypeState = new ContextSensitiveMultiTypeState(bb, resultCanBeNull, resultTypesBitSet, resultTypesBitSet.cardinality(), objects);
            return contextSensitiveMultiTypeState;
        }
    }

    @Override
    public void processArrayCopyStates(PointsToAnalysis bb, TypeState srcArrayState, TypeState dstArrayState) {
        TypesObjectsIterator srcIterator = new TypesObjectsIterator(srcArrayState);
        while (srcIterator.hasNextType()) {
            AnalysisType srcType = srcIterator.nextType();
            if (!BytecodeSensitiveAnalysisPolicy.isObjectArrayType(srcType)) {
                srcIterator.skipObjects(srcType);
                continue;
            }
            srcIterator.memoizePosition();
            TypesObjectsIterator dstIterator = new TypesObjectsIterator(dstArrayState);
            while (dstIterator.hasNextType()) {
                AnalysisType dstType = dstIterator.nextType();
                if (!BytecodeSensitiveAnalysisPolicy.isObjectArrayType(dstType)) {
                    dstIterator.skipObjects(dstType);
                    continue;
                }
                if (BytecodeSensitiveAnalysisPolicy.areTypesCompatibleForSystemArraycopy(srcType, dstType)) {
                    srcIterator.reset();
                    dstIterator.memoizePosition();
                    while (srcIterator.hasNextObject(srcType)) {
                        AnalysisObject srcObject = srcIterator.nextObject(srcType);
                        if (srcObject.isEmptyObjectArrayConstant(bb)) continue;
                        ArrayElementsTypeFlow srcArrayElements = srcObject.getArrayElementsFlow(bb, true);
                        dstIterator.reset();
                        while (dstIterator.hasNextObject(dstType)) {
                            AnalysisObject dstObject = dstIterator.nextObject(dstType);
                            if (dstObject.isEmptyObjectArrayConstant(bb)) continue;
                            ArrayElementsTypeFlow dstArrayElements = dstObject.getArrayElementsFlow(bb, true);
                            srcArrayElements.addUse(bb, dstArrayElements);
                        }
                    }
                    continue;
                }
                dstIterator.skipObjects(dstType);
            }
        }
    }

    private static boolean isObjectArrayType(AnalysisType type) {
        return type.isArray() && type.getComponentType().getJavaKind() == JavaKind.Object;
    }
}

