/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AllInstantiatedTypeFlow;
import com.oracle.graal.pointsto.flow.AllSynchronizedTypeFlow;
import com.oracle.graal.pointsto.flow.ArrayElementsTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.FormalParamTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.ProxyTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.util.AnalysisError;
import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.common.JVMCIError;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;

public class MethodFlowsGraphClone
extends MethodFlowsGraph {
    private final AnalysisContext context;
    private final MethodFlowsGraph originalFlowsGraph;
    protected boolean sealed;

    public MethodFlowsGraphClone(PointsToAnalysisMethod method, MethodFlowsGraph originalFlowsGraph, AnalysisContext context) {
        super(method, originalFlowsGraph.getGraphKind());
        this.context = context;
        this.originalFlowsGraph = originalFlowsGraph;
        assert (this.originalFlowsGraph.isLinearized());
    }

    public AnalysisContext context() {
        return this.context;
    }

    void cloneOriginalFlows(PointsToAnalysis bb) {
        this.cloneOriginalFlowsHelper(bb, false);
    }

    void recloneOriginalFlows(PointsToAnalysis bb) {
        this.cloneOriginalFlowsHelper(bb, true);
    }

    private void cloneOriginalFlowsHelper(PointsToAnalysis bb, boolean isReclone) {
        if (isReclone) {
            this.sealed = false;
        }
        assert (this.context != null);
        assert (this.originalFlowsGraph != null && this.originalFlowsGraph.isLinearized()) : " Method " + String.valueOf(this) + " is not linearized";
        this.linearizedGraph = new TypeFlow[this.originalFlowsGraph.linearizedGraph.length];
        if (!isReclone) {
            this.parameters = new FormalParamTypeFlow[this.originalFlowsGraph.parameters.length];
            for (int i = 0; i < this.originalFlowsGraph.parameters.length; ++i) {
                if (this.originalFlowsGraph.getParameter(i) == null) continue;
                this.parameters[i] = this.lookupCloneOf(bb, this.originalFlowsGraph.getParameter(i));
            }
            this.returnFlow = this.originalFlowsGraph.getReturnFlow() != null ? this.lookupCloneOf(bb, this.originalFlowsGraph.getReturnFlow()) : null;
        }
        this.nodeFlows = this.lookupClonesOf(bb, this.originalFlowsGraph.nodeFlows);
        this.instanceOfFlows = this.lookupClonesOf(bb, this.originalFlowsGraph.instanceOfFlows);
        this.miscEntryFlows = this.lookupClonesOf(bb, this.originalFlowsGraph.miscEntryFlows);
        this.invokeFlows = this.lookupClonesOf(bb, this.originalFlowsGraph.invokeFlows);
        this.sealed = true;
    }

    private <K, V extends TypeFlow<?>> EconomicMap<K, V> lookupClonesOf(PointsToAnalysis bb, EconomicMap<K, V> original) {
        if (original == null) {
            return null;
        }
        EconomicMap result = EconomicMap.create((int)original.size());
        MapCursor cursor = original.getEntries();
        while (cursor.advance()) {
            result.put(cursor.getKey(), (Object)this.lookupCloneOf(bb, (TypeFlow)cursor.getValue()));
        }
        return result;
    }

    private <V extends TypeFlow<?>> List<V> lookupClonesOf(PointsToAnalysis bb, List<V> original) {
        if (original == null) {
            return null;
        }
        ArrayList<TypeFlow> result = new ArrayList<TypeFlow>(original.size());
        for (TypeFlow value : original) {
            result.add(this.lookupCloneOf(bb, value));
        }
        return result;
    }

    @Override
    public <T extends TypeFlow<?>> T lookupCloneOf(PointsToAnalysis bb, T original) {
        assert (original != null) : "Looking for the clone of a 'null' flow in " + String.valueOf(this);
        assert (!original.isClone()) : "Looking for the clone of the already cloned flow " + String.valueOf(original) + " in " + String.valueOf(this);
        assert (!(original instanceof FieldTypeFlow)) : "Trying to clone a field type flow";
        assert (!(original instanceof ArrayElementsTypeFlow)) : "Trying to clone an mixed elements type flow";
        if (original instanceof AllInstantiatedTypeFlow || original instanceof AllSynchronizedTypeFlow) {
            return original;
        }
        if (original instanceof ProxyTypeFlow) {
            return (T)((ProxyTypeFlow)original).getInput();
        }
        int slot = original.getSlot();
        assert (slot >= 0 && slot < this.linearizedGraph.length) : "Slot index out of bounds " + slot + " : " + String.valueOf(original) + " [" + String.valueOf(original.getSource()) + "]";
        TypeFlow<?> clone = this.linearizedGraph[slot];
        if (clone == null) {
            if (this.sealed) {
                JVMCIError.shouldNotReachHere((String)"Trying to create a clone after the method flows have been sealed.");
            }
            clone = original.copy(bb, this);
            assert (slot == clone.getSlot());
            assert (this.linearizedGraph[slot] == null) : "Clone already exists: " + slot + " : " + String.valueOf(original);
            this.linearizedGraph[slot] = clone;
        }
        return (T)clone;
    }

    void linkCloneFlows(PointsToAnalysis bb) {
        for (TypeFlow<?> original : this.originalFlowsGraph.linearizedGraph) {
            TypeFlow<?> clone = this.lookupCloneOf(bb, original);
            if (clone.needsInitialization()) {
                clone.initFlow(bb);
            }
            for (TypeFlow<?> originalObserver : original.getObservers()) {
                assert (!(originalObserver instanceof AllInstantiatedTypeFlow));
                assert (!originalObserver.isClone());
                if (MethodFlowsGraph.nonCloneableFlow(originalObserver)) {
                    clone.addObserver(bb, originalObserver);
                    continue;
                }
                if (MethodFlowsGraph.crossMethodUse(original, originalObserver)) continue;
                TypeFlow<?> clonedObserver = this.lookupCloneOf(bb, originalObserver);
                clone.addObserver(bb, clonedObserver);
            }
            for (TypeFlow<?> originalUse : original.getUses()) {
                assert (!(originalUse instanceof AllInstantiatedTypeFlow));
                assert (!originalUse.isClone()) : "Original use " + String.valueOf(originalUse) + " should not be a clone. Reached from: " + String.valueOf(original);
                if (MethodFlowsGraph.nonCloneableFlow(originalUse)) {
                    clone.addUse(bb, originalUse);
                    continue;
                }
                if (MethodFlowsGraph.crossMethodUse(original, originalUse)) continue;
                TypeFlow<?> clonedUse = this.lookupCloneOf(bb, originalUse);
                clone.addUse(bb, clonedUse);
            }
        }
    }

    @Override
    void updateInternalState(MethodFlowsGraph.GraphKind newGraphKind) {
        throw AnalysisError.shouldNotReachHere("Cannot be updated, should use recloneOriginalFlows");
    }

    @Override
    public String toString() {
        return "MethodFlowsGraphClone<" + this.method.format("%h.%n(%p)") + " " + String.valueOf(this.context) + ">";
    }
}

