/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.tools.asn1.Asn1;
import com.oracle.jipher.internal.tools.asn1.Asn1BerValue;
import com.oracle.jipher.internal.tools.asn1.Asn1DecodeException;
import com.oracle.jipher.internal.tools.asn1.UniversalTag;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.MGF1ParameterSpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class RsaParameters
extends AlgorithmParametersSpi {
    private static final Asn1BerValue ID_MGF1 = Asn1.newOid("1.2.840.113549.1.1.8");
    private static final Asn1BerValue ID_SHA1 = Asn1.newOid("1.3.14.3.2.26");
    private static final Asn1BerValue ID_SHA224 = Asn1.newOid("2.16.840.1.101.3.4.2.4");
    private static final Asn1BerValue ID_SHA256 = Asn1.newOid("2.16.840.1.101.3.4.2.1");
    private static final Asn1BerValue ID_SHA384 = Asn1.newOid("2.16.840.1.101.3.4.2.2");
    private static final Asn1BerValue ID_SHA512 = Asn1.newOid("2.16.840.1.101.3.4.2.3");
    private static final Map<Asn1BerValue, String> OID_TO_DIGEST_MAP;
    private static final Map<String, Asn1BerValue> DIGEST_TO_OID_MAP;

    RsaParameters() {
    }

    private static void updateMaps(Map<Asn1BerValue, String> oidToDigestMap, Map<String, Asn1BerValue> digestToOidMap, String digestName, Asn1BerValue oid) {
        oidToDigestMap.put(oid, digestName);
        digestToOidMap.put(digestName.toLowerCase(), oid);
    }

    @Override
    protected byte[] engineGetEncoded(String format) throws IOException {
        if (format != null && !format.equalsIgnoreCase("ASN.1")) {
            throw new IllegalArgumentException("Only supports ASN.1 format");
        }
        return this.engineGetEncoded();
    }

    @Override
    protected void engineInit(byte[] params, String format) throws IOException {
        if (format != null && !format.equalsIgnoreCase("ASN.1")) {
            throw new IllegalArgumentException("Only supports ASN.1 format");
        }
        this.engineInit(params);
    }

    static Asn1BerValue[] decodeParams(int numParams, byte[] der) {
        Asn1BerValue paramStructure = Asn1.decodeOne(der);
        Util.assertUniversal(paramStructure);
        List<Asn1BerValue> paramList = paramStructure.maxCount(numParams).sequence();
        Asn1BerValue[] pssParams = new Asn1BerValue[numParams];
        int nextTag = 0;
        for (Asn1BerValue pExplicit : paramList) {
            Util.assertContextSpecific(pExplicit);
            if (pExplicit.tagValue < nextTag || pExplicit.tagValue >= numParams) {
                throw new Asn1DecodeException("Unexpected context specific tag value at offset " + pExplicit.offset + "; expected: " + nextTag + ", was: " + pExplicit.tagValue);
            }
            Asn1BerValue param = pExplicit.explicit();
            Util.assertAllUniversal(param);
            pssParams[pExplicit.tagValue] = param;
            nextTag = pExplicit.tagValue + 1;
        }
        return pssParams;
    }

    String getHashAlg(Asn1BerValue hashAlgorithm) {
        return hashAlgorithm == null ? "SHA-1" : RsaParameters.getDigestAlg(hashAlgorithm, "PSS Digest");
    }

    MGF1ParameterSpec getMgf1Spec(Asn1BerValue maskGenAlgorithm) {
        return maskGenAlgorithm == null ? MGF1ParameterSpec.SHA1 : new MGF1ParameterSpec(RsaParameters.getDigestAlg(RsaParameters.getAlgIdParams(maskGenAlgorithm, ID_MGF1, "MGF"), "MGF1 Digest"));
    }

    static Asn1BerValue getAlgIdParams(Asn1BerValue algId, Asn1BerValue expectedOid, String desc) {
        List<Asn1BerValue> values = RsaParameters.getAlgIdContent(algId);
        Asn1BerValue algorithm = values.get(0);
        if (!algorithm.equals(expectedOid)) {
            throw new Asn1DecodeException("Unsupported OAEP " + desc + " algorithm; was: " + algorithm.getOid() + ", expected: " + expectedOid.getOid());
        }
        return values.get(1);
    }

    Asn1BerValue hashAlgToBer(String digestAlg) {
        Asn1BerValue digestOid = DIGEST_TO_OID_MAP.get(digestAlg.toLowerCase());
        if (digestOid != ID_SHA1) {
            return Asn1.explicit(0).newSequence(digestOid, Asn1.newNull());
        }
        return null;
    }

    Asn1BerValue mgfToBer(MGF1ParameterSpec mgf1Spec) {
        Asn1BerValue mgf1DigestOid = DIGEST_TO_OID_MAP.get(mgf1Spec.getDigestAlgorithm().toLowerCase());
        if (mgf1DigestOid != ID_SHA1) {
            return Asn1.explicit(1).newSequence(ID_MGF1, Asn1.newSequence(mgf1DigestOid, Asn1.newNull()));
        }
        return null;
    }

    private static String getDigestAlg(Asn1BerValue algId, String desc) {
        Asn1BerValue digestOid = RsaParameters.getDigestOid(algId);
        String digestAlg = OID_TO_DIGEST_MAP.get(digestOid);
        if (digestAlg == null) {
            throw new Asn1DecodeException("Unsupported OAEP " + desc + " algorithm: " + digestOid);
        }
        return digestAlg;
    }

    private static Asn1BerValue getDigestOid(Asn1BerValue algId) {
        List<Asn1BerValue> values = RsaParameters.getAlgIdContent(algId);
        values.get(1).getNull();
        return values.get(0);
    }

    private static List<Asn1BerValue> getAlgIdContent(Asn1BerValue algId) {
        List<Asn1BerValue> values = algId.count(2).sequence();
        values.get(0).tag(UniversalTag.OBJECT_IDENTIFIER);
        return values;
    }

    static {
        HashMap<Asn1BerValue, String> oidToDigestMap = new HashMap<Asn1BerValue, String>();
        HashMap<String, Asn1BerValue> digestToOidMap = new HashMap<String, Asn1BerValue>();
        RsaParameters.updateMaps(oidToDigestMap, digestToOidMap, "SHA-1", ID_SHA1);
        RsaParameters.updateMaps(oidToDigestMap, digestToOidMap, "SHA-224", ID_SHA224);
        RsaParameters.updateMaps(oidToDigestMap, digestToOidMap, "SHA-256", ID_SHA256);
        RsaParameters.updateMaps(oidToDigestMap, digestToOidMap, "SHA-384", ID_SHA384);
        RsaParameters.updateMaps(oidToDigestMap, digestToOidMap, "SHA-512", ID_SHA512);
        OID_TO_DIGEST_MAP = Collections.unmodifiableMap(oidToDigestMap);
        DIGEST_TO_OID_MAP = Collections.unmodifiableMap(digestToOidMap);
    }
}

