/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.Util;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.PBEKeySpec;
import javax.security.auth.Destroyable;

public abstract class PbeKeyFactory
extends SecretKeyFactorySpi {
    private static final Set<String> SUPPORTED_ALGS = new HashSet<String>(Arrays.asList("PBEWithHmacSHA1AndAES_128".toUpperCase(), "PBEWithHmacSHA224AndAES_128".toUpperCase(), "PBEWithHmacSHA256AndAES_128".toUpperCase(), "PBEWithHmacSHA384AndAES_128".toUpperCase(), "PBEWithHmacSHA512AndAES_128".toUpperCase(), "PBEWithHmacSHA1AndAES_256".toUpperCase(), "PBEWithHmacSHA224AndAES_256".toUpperCase(), "PBEWithHmacSHA256AndAES_256".toUpperCase(), "PBEWithHmacSHA384AndAES_256".toUpperCase(), "PBEWithHmacSHA512AndAES_256".toUpperCase(), "PBEWithSHA1AndDESede".toUpperCase()));
    private final String algorithm;
    private final boolean checkPrintableAscii;

    PbeKeyFactory(String algorithm, boolean checkPrintableAscii) {
        this.algorithm = algorithm;
        this.checkPrintableAscii = checkPrintableAscii;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected KeySpec engineGetKeySpec(SecretKey key, Class<?> keySpec) throws InvalidKeySpecException {
        if (keySpec == null || !PBEKeySpec.class.isAssignableFrom(keySpec)) {
            throw new InvalidKeySpecException("Invalid key spec");
        }
        String keyAlg = key.getAlgorithm().toUpperCase();
        if (!SUPPORTED_ALGS.contains(keyAlg) || !key.getFormat().equalsIgnoreCase("RAW")) {
            throw new InvalidKeySpecException("Invalid key format/algorithm");
        }
        byte[] encoded = key.getEncoded();
        char[] password = null;
        try {
            password = PbeKeyFactory.decodePassword(encoded, keyAlg);
            PBEKeySpec pBEKeySpec = new PBEKeySpec(password);
            return pBEKeySpec;
        }
        finally {
            Util.clearArray(password);
            Util.clearArray(encoded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (!(keySpec instanceof PBEKeySpec)) {
            throw new InvalidKeySpecException("Invalid key spec");
        }
        char[] password = ((PBEKeySpec)keySpec).getPassword();
        try {
            if (this.checkPrintableAscii && !Util.isPrintableAscii(password)) {
                throw new InvalidKeySpecException("Password is not ASCII");
            }
            PasswordKey passwordKey = new PasswordKey(this.algorithm, this.encodePassword(password));
            return passwordKey;
        }
        finally {
            Util.clearArray(password);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        String keyAlg = key.getAlgorithm().toUpperCase();
        if (!SUPPORTED_ALGS.contains(keyAlg) || !key.getFormat().equalsIgnoreCase("RAW")) {
            throw new InvalidKeyException("Invalid key format/algorithm");
        }
        byte[] encoded = key.getEncoded();
        char[] password = null;
        try {
            password = PbeKeyFactory.decodePassword(encoded, keyAlg);
            if (this.checkPrintableAscii && !Util.isPrintableAscii(password)) {
                throw new InvalidKeyException("Cannot translate key: Password is not ASCII");
            }
            PasswordKey passwordKey = new PasswordKey(this.algorithm, this.encodePassword(password));
            return passwordKey;
        }
        finally {
            Util.clearArray(password);
            Util.clearArray(encoded);
        }
    }

    abstract byte[] encodePassword(char[] var1);

    private static char[] decodePassword(byte[] encoded, String keyAlg) {
        boolean isP12 = keyAlg.equals("PBE") || keyAlg.startsWith("PBEWITHSHA");
        return isP12 ? Util.utf16BeDecode(encoded) : Util.asciiDecode(encoded);
    }

    static final class PasswordKey
    implements SecretKey,
    Destroyable {
        final String algorithm;
        byte[] encoded;

        PasswordKey(String algorithm, byte[] encoded) {
            this.algorithm = algorithm;
            this.encoded = encoded;
        }

        @Override
        public String getAlgorithm() {
            return this.algorithm;
        }

        @Override
        public String getFormat() {
            return "RAW";
        }

        @Override
        public byte[] getEncoded() {
            if (this.encoded == null) {
                throw new IllegalStateException("password has been cleared");
            }
            return (byte[])this.encoded.clone();
        }

        @Override
        public void destroy() {
            if (this.encoded != null) {
                Arrays.fill(this.encoded, (byte)0);
                this.encoded = null;
            }
        }

        @Override
        public boolean isDestroyed() {
            return this.encoded == null;
        }

        public int hashCode() {
            return this.algorithm.hashCode() + Util.hashCode(this.encoded);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PasswordKey)) {
                return false;
            }
            PasswordKey other = (PasswordKey)obj;
            return this.algorithm.equals(other.algorithm) && Util.equalsTC(this.encoded, other.encoded);
        }
    }

    public static final class PBEWithSHA1AndDESede
    extends Pkcs12PbeKeyFactory {
        public PBEWithSHA1AndDESede() {
            super("PBEWithSHA1AndDESede");
        }
    }

    public static final class PBE
    extends Pkcs12PbeKeyFactory {
        public PBE() {
            super("PBE");
        }
    }

    static abstract class Pkcs12PbeKeyFactory
    extends PbeKeyFactory {
        Pkcs12PbeKeyFactory(String algorithm) {
            super(algorithm, false);
        }

        @Override
        final byte[] encodePassword(char[] password) {
            return Util.utf16BeEncode(password);
        }
    }

    public static final class PBEWithHmacSHA512AndAES256
    extends Pbes2KeyFactory {
        public PBEWithHmacSHA512AndAES256() {
            super("PBEWithHmacSHA512AndAES_256");
        }
    }

    public static final class PBEWithHmacSHA384AndAES256
    extends Pbes2KeyFactory {
        public PBEWithHmacSHA384AndAES256() {
            super("PBEWithHmacSHA384AndAES_256");
        }
    }

    public static final class PBEWithHmacSHA256AndAES256
    extends Pbes2KeyFactory {
        public PBEWithHmacSHA256AndAES256() {
            super("PBEWithHmacSHA256AndAES_256");
        }
    }

    public static final class PBEWithHmacSHA224AndAES256
    extends Pbes2KeyFactory {
        public PBEWithHmacSHA224AndAES256() {
            super("PBEWithHmacSHA224AndAES_256");
        }
    }

    public static final class PBEWithHmacSHA1AndAES256
    extends Pbes2KeyFactory {
        public PBEWithHmacSHA1AndAES256() {
            super("PBEWithHmacSHA1AndAES_256");
        }
    }

    public static final class PBEWithHmacSHA512AndAES128
    extends Pbes2KeyFactory {
        public PBEWithHmacSHA512AndAES128() {
            super("PBEWithHmacSHA512AndAES_128");
        }
    }

    public static final class PBEWithHmacSHA384AndAES128
    extends Pbes2KeyFactory {
        public PBEWithHmacSHA384AndAES128() {
            super("PBEWithHmacSHA384AndAES_128");
        }
    }

    public static final class PBEWithHmacSHA256AndAES128
    extends Pbes2KeyFactory {
        public PBEWithHmacSHA256AndAES128() {
            super("PBEWithHmacSHA256AndAES_128");
        }
    }

    public static final class PBEWithHmacSHA224AndAES128
    extends Pbes2KeyFactory {
        public PBEWithHmacSHA224AndAES128() {
            super("PBEWithHmacSHA224AndAES_128");
        }
    }

    public static final class PBEWithHmacSHA1AndAES128
    extends Pbes2KeyFactory {
        public PBEWithHmacSHA1AndAES128() {
            super("PBEWithHmacSHA1AndAES_128");
        }
    }

    public static final class PBES2
    extends Pbes2KeyFactory {
        public PBES2() {
            super("PBES2");
        }
    }

    static abstract class Pbes2KeyFactory
    extends PbeKeyFactory {
        Pbes2KeyFactory(String algorithm) {
            super(algorithm, true);
        }

        @Override
        final byte[] encodePassword(char[] password) {
            return Util.asciiEncode(password);
        }
    }
}

