/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.key;

import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.key.JceOsslKey;
import com.oracle.jipher.internal.openssl.Pkey;
import com.oracle.jipher.internal.tools.asn1.Asn1;
import com.oracle.jipher.internal.tools.asn1.Asn1BerValue;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.interfaces.DSAPrivateKey;
import java.security.spec.DSAParameterSpec;

public final class JceDsaPrivateKey
extends JceOsslKey
implements DSAPrivateKey {
    static final String ALG = "DSA";
    private static final Asn1BerValue ID_DSA = Asn1.newOid("1.2.840.10040.4.1");
    private final BigInteger priv;
    private final DSAParameterSpec params;

    public JceDsaPrivateKey(Pkey pkey, BigInteger priv, DSAParameterSpec params) {
        super(ALG, pkey);
        this.priv = priv;
        this.params = params;
    }

    public JceDsaPrivateKey(Pkey pkey) throws InvalidKeyException {
        super(ALG, pkey);
        byte[] privVal = this.pkey.getDsaPrivateKey();
        try {
            this.priv = new BigInteger(1, privVal);
        }
        finally {
            Util.clearArray(privVal);
        }
        byte[][] vals = this.pkey.getDsaParams();
        this.params = new DSAParameterSpec(new BigInteger(1, vals[0]), new BigInteger(1, vals[1]), new BigInteger(1, vals[2]));
    }

    @Override
    public BigInteger getX() {
        return this.priv;
    }

    @Override
    public DSAParameterSpec getParams() {
        return this.params;
    }

    @Override
    public void destroy() {
        this.pkey.free();
    }

    @Override
    byte[] derEncode() throws InvalidKeyException {
        Asn1BerValue dsaPrivKey = Asn1.newSequence(Asn1.newInteger(0L), Asn1.newSequence(ID_DSA, Asn1.newSequence(Asn1.newInteger(this.params.getP()), Asn1.newInteger(this.params.getQ()), Asn1.newInteger(this.params.getG()))), Asn1.newOctetString(Asn1.newInteger(this.priv).encodeDer()));
        return dsaPrivKey.encodeDerOctets();
    }
}

