/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.common;

import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.openssl.Rand;
import java.nio.ByteBuffer;
import java.security.ProviderException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class TripleDesUtil {
    private static final int NUM_KEY_BYTES = 24;
    private static final long[] WEAK_KEYS = new long[]{0x101010101010101L, -72340172838076674L, -2242545357694045711L, 2242545357694045710L, 80784550989267214L, 2234100979542855169L, 135110050437988849L, -2305315235293957887L, 143554428589179390L, -143554428589179391L, 2296870857142767345L, -2296870857142767346L, 2305315235293957886L, -135110050437988850L, -2234100979542855170L, -80784550989267215L, 72373287035932174L, 2242512243496190209L, -2242758392366952946L, 72586321708839409L, 2242758392366952945L, -2242512243496190210L, 72619435906694910L, 2242791506564808446L, -2234347128413617906L, 80817407489084929L, 2296838000642949630L, -2234314271913800191L, 81030699860029950L, 2297082233958297870L, -2234068123043037455L, 81063556359847665L, 2297115090458115585L, -143831518404345346L, 135143164635844350L, 2305282121096102385L, -143798661904527631L, -143587285088997106L, 2305526354411450625L, -135387397951192591L, 135354283753337089L, 2305559468609306126L, -135143164635844351L, 135387397951192590L, -2305559468609306127L, -135354283753337090L, 143587285088997105L, -2305526354411450626L, -81063556359847666L, 143798661904527630L, -2305282121096102386L, -81030699860029951L, 143831518404345345L, -2297115090458115586L, -80817407489084930L, 2234068123043037454L, -2297082233958297871L, -72619435906694911L, 2234314271913800190L, -2296838000642949631L, -72586321708839410L, 2234347128413617905L, -2242791506564808447L, -72373287035932175L};
    private static final byte[] PARITY_TABLE = TripleDesUtil.genParityTable();

    private TripleDesUtil() {
    }

    private static byte[] genParityTable() {
        byte[] tbl = new byte[128];
        for (int i = 0; i < tbl.length; ++i) {
            tbl[i] = (byte)(i << 1 | Integer.bitCount(i) & 1 ^ 1);
        }
        return tbl;
    }

    public static void setParityBits(byte[] key) {
        for (int i = 0; i < key.length; ++i) {
            key[i] = PARITY_TABLE[key[i] >>> 1 & 0x7F];
        }
    }

    static boolean isWeakKey(long[] subKeys) {
        for (long subKey : subKeys) {
            if (!TripleDesUtil.isWeakKey(subKey)) continue;
            return true;
        }
        return false;
    }

    private static boolean isWeakKey(long key) {
        for (long wk : WEAK_KEYS) {
            if (key != wk) continue;
            return true;
        }
        return false;
    }

    public static SecretKey generateKey() {
        byte[] keyBytes = new byte[24];
        long[] subKeys = new long[3];
        try {
            for (int count = 0; count < 2; ++count) {
                Rand.generate(keyBytes);
                TripleDesUtil.setParityBits(keyBytes);
                ByteBuffer.wrap(keyBytes).asLongBuffer().get(subKeys);
                if (subKeys[0] == subKeys[1] || subKeys[0] == subKeys[2] || subKeys[1] == subKeys[2] || TripleDesUtil.isWeakKey(subKeys)) continue;
                SecretKeySpec secretKeySpec = new SecretKeySpec(keyBytes, "DESede");
                return secretKeySpec;
            }
            throw new ProviderException("Internal Error: Weak key retry count");
        }
        finally {
            Util.clearArray(keyBytes);
            Util.clearArray(subKeys);
        }
    }
}

