// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: SpectrePHTMitigations.java
package org.graalvm.compiler.core.common;

import java.util.*;
import org.graalvm.compiler.options.*;
import org.graalvm.compiler.options.OptionType;

public class SpectrePHTMitigations_OptionDescriptors implements OptionDescriptors {
    @Override
    public OptionDescriptor get(String value) {
        switch (value) {
        // CheckStyle: stop line length check
        case "SpectrePHTBarriers": {
            return OptionDescriptor.create(
                /*name*/ "SpectrePHTBarriers",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ org.graalvm.compiler.core.common.SpectrePHTMitigations.class,
                /*help*/ "Select a strategy to mitigate speculative bounds check bypass (aka Spectre-PHT or Spectre V1).",
                /*extraHelp*/ new String[] {
                         "This is an experimental option - execution of untrusted code is not supported by GraalVM CE.",
                         "The accepted values are:",
                         "                  None - No mitigations are used in JIT compiled code.",
                         "            AllTargets - Speculative execution on all branch targets is",
                         "                         stopped using speculative execution barrier instructions.",
                         "                         This option is equivalent to setting SpeculativeExecutionBarriers to true.",
                         "          GuardTargets - Branch targets relevant to Java memory safety are instrumented",
                         "                         with barrier instructions. This option has less performance impact",
                         "                         than AllTargets. ",
                         "  NonDeoptGuardTargets - Same as GuardTargets, except that branches which deoptimize are not",
                         "                         protected since they can not be executed repeatedly and are thus less",
                         "                         likely to be successfully exploited in an attack.",
                         "",
                         "                         ",
                         "Note that all modes except \"None\" will also instrument branch target blocks containing UNSAFE memory accesses",
                         "with barrier instructions.",
                              },
                /*declaringClass*/ SpectrePHTMitigations.Options.class,
                /*fieldName*/ "SpectrePHTBarriers",
                /*option*/ SpectrePHTMitigations.Options.SpectrePHTBarriers,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SpectrePHTIndexMasking": {
            return OptionDescriptor.create(
                /*name*/ "SpectrePHTIndexMasking",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Mask indices to scope access to allocation size after bounds check.",
                /*declaringClass*/ SpectrePHTMitigations.Options.class,
                /*fieldName*/ "SpectrePHTIndexMasking",
                /*option*/ SpectrePHTMitigations.Options.SpectrePHTIndexMasking,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SpeculativeExecutionBarriers": {
            return OptionDescriptor.create(
                /*name*/ "SpeculativeExecutionBarriers",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Stop speculative execution on all branch targets with execution barrier instructions.",
                /*declaringClass*/ SpectrePHTMitigations.Options.class,
                /*fieldName*/ "SpeculativeExecutionBarriers",
                /*option*/ SpectrePHTMitigations.Options.SpeculativeExecutionBarriers,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 3;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("SpectrePHTBarriers");
                    case 1: return get("SpectrePHTIndexMasking");
                    case 2: return get("SpeculativeExecutionBarriers");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
