/*
 * Copyright (c) 2005, 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package com.sun.source.tree;

import jdk.internal.javac.PreviewFeature;

/**
 * A tree node for an "enhanced" {@code for} loop statement.
 *
 * For example:
 * <pre>
 *   for ( <em>variable</em> : <em>expression</em> )
 *       <em>statement</em>
 * </pre>
 *
 * @jls 14.14.2 The enhanced for statement
 *
 * @author Peter von der Ah&eacute;
 * @author Jonathan Gibbons
 * @since 1.6
 */
public interface EnhancedForLoopTree extends StatementTree {
    /**
     * "Enhanced" {@code for} declarations come in two forms:
     * <ul>
     * <li> local variable declarations and
     * <li> record patterns
     * </ul>
     *
     * @since 20
     */
    @PreviewFeature(feature=PreviewFeature.Feature.RECORD_PATTERNS, reflective=true)
    public enum DeclarationKind {
        /** enum constant for local variable declarations */
        VARIABLE,
        /** enum constant for record pattern declarations */
        PATTERN
    }

    /**
     * Returns the control variable for the loop.
     * @return the control variable, or {@code null} if this "enhanced" {@code for} uses a pattern
     */
    VariableTree getVariable();

    /**
     * Returns the control variable or pattern for the loop.
     * @return the control variable or pattern
     * @since 20
     */
    @PreviewFeature(feature=PreviewFeature.Feature.RECORD_PATTERNS, reflective=true)
    Tree getVariableOrRecordPattern();

    /**
     * Returns the expression yielding the values for the control variable.
     * @return the expression
     */
    ExpressionTree getExpression();

    /**
     * Returns the body of the loop.
     * @return the body of the loop
     */
    StatementTree getStatement();

    /**
     * Returns the kind of the declaration of the "enhanced" {@code for}.
     * @return the kind of the declaration
     * @since 20
     */
    @PreviewFeature(feature=PreviewFeature.Feature.RECORD_PATTERNS, reflective=true)
    DeclarationKind getDeclarationKind();
}
