/*
 * Copyright (c) 2023, 2023, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

class Utils {
    static printIfExists(data, trueMessage = data, falseMessage = "-") {
        return data >= 0 ? trueMessage : falseMessage;
    }

    static toPercentage(ratio, precision = 3) {
        return `${(ratio * 100).toFixed(precision)}%`;
    }

    static toHumanReadableSize(size) {
        const exponent = size == 0 ? 0 : Math.floor(Math.log(size) / Math.log(1024));

        return (size / Math.pow(1024, exponent)).toFixed(2) * 1 + " " + ["B", "kB", "MB", "GB", "TB"][exponent];
    }

    /**
     * Download to the user's machine a file named `filename` with the given `text` as content.
     */
    static download(filename, text) {
        const element = document.createElement('a');
        element.setAttribute('href', 'data:text/plain;charset=utf-8,' + encodeURIComponent(text));
        element.setAttribute('download', filename);

        element.style.display = 'none';
        document.body.appendChild(element);

        element.click();
        document.body.removeChild(element);
    }
}