/*
 * Copyright (c) 2023, 2023, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

const tabsInitializer = () => {
    const tabLinks = document.querySelectorAll(".tab-link");
    for (let i = 0; i < tabLinks.length; i++) {
        tabLinks[i].onclick = function(e) {
            for (i = 0; i < tabLinks.length; i++) {
                tabLinks[i].classList.remove("active");
            }
            e.target.classList.add("active");

            const tabs = document.querySelectorAll(".tab-content");
            for (i = 0; i < tabs.length; i++) {
                tabs[i].classList.remove("active");
            }
            const selectedTab = document.querySelector(e.target.dataset.target);
            selectedTab.classList.add("active");
        };
    }
};

const activateTab = (target) => {
    const tabLinks = document.querySelectorAll(".tab-link");
    for (let i = 0; i < tabLinks.length; i++) {
        tabLinks[i].classList.remove("active");
    }
    const activatedTabLink = document.querySelector(`.tab-link[data-target="${target}"]`);
    activatedTabLink.classList.add("active");
    window.scrollTo({
        top: 0,
        left: 0,
        behavior: 'smooth'
    });

    const tabs = document.querySelectorAll(".tab-content");
    for (let i = 0; i < tabs.length; i++) {
        tabs[i].classList.remove("active");
    }
    const activatedTab = document.querySelector(target);
    activatedTab.classList.add("active");
};

window.addEventListener("load", tabsInitializer);