/*
 * Copyright (c) 2023, 2023, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

class SBOMList {
    constructor() {}

    // class fields are not well supported by Closure: https://github.com/google/closure-compiler/issues/2731

    static getInstance() {
        if (!this._instance) {
            this._instance = new SBOMList();
        }
        return this._instance;
    }

    getData() {
        return this._data;
    }

    setData(data) {
        this._data = data;
    }

    render(container) {
        const table = document.getElementById(container);
        table.innerHTML = "";
        const components = this._data.components;

        for (let i in components) {
            const component = components[i];
            const html =
                `<tr>
                    <td>${component.group}</td>
                    <td class="sbom-item-artifact">${component.name}</td>
                    <td><span class="version">${component.version}</span></td>
                </tr>`;

            const template = document.createElement("template");
            template.innerHTML = html;
            table.appendChild(template.content.firstChild);
        }
    }
}