/*
 * Copyright (c) 2023, 2023, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

const mainInitializer = () => {
    const data = window.data;
    document.title = data.name + " - " + document.title;
    document.querySelector("#image-name").innerHTML = data.name;

    const generateWorkerMethodURL = (method) => {
        return URL.createObjectURL(new Blob([`(${method.toString()})()`], { type: "text/javascript" } ));
    };

    const buildOutput = BuildOutput.getInstance();
    buildOutput.setData(data.buildOutput);
    buildOutput.render("build-output-image-details");
    document.getElementById("build-output-download").onclick = function(e) {
        e.preventDefault();
        const buildOutput = BuildOutput.getInstance();
        const text = JSON.stringify(buildOutput.getData(), null, 2);
        Utils.download(`${data.name}-build-output.json`, text);
    };

    const methodBreakdownType = document.querySelector("#method-breakdown-type");

    const renderMethodBasedBreakdown = () => {
        const methodBreakdown = MethodBreakdown.getInstance();
        const type = methodBreakdownType.options[methodBreakdownType.selectedIndex].value;

        methodBreakdown.render(type, "method-breakdown", "package-class-list");
    };

    const methodBreakdownWorker = new Worker(generateWorkerMethodURL(MethodBreakdown.dataWorker));
    methodBreakdownWorker.onmessage = function(e) {
        const methodBreakdown = MethodBreakdown.getInstance();

        methodBreakdown.setCountData(e.data.countData);
        methodBreakdown.setBytecodeSizeData(e.data.bytecodeSizeData);

        renderMethodBasedBreakdown();
    };
    methodBreakdownWorker.postMessage(data);

    methodBreakdownType.onchange = renderMethodBasedBreakdown;

    const heapBreakdown = HeapBreakdown.getInstance();
    heapBreakdown.setData(data.heap);
    heapBreakdown.render("heap-breakdown", "heap-breakdown-total-size");

    if (data.sbom) {
        const sbom = SBOMList.getInstance();
        sbom.setData(data.sbom);
        sbom.render("sbom-list");

        document.getElementById('sbom-download').onclick = function(e) {
            e.preventDefault();
            const sbom = SBOMList.getInstance();
            const text = JSON.stringify(sbom.getData(), null, 2);
            Utils.download(`${data.name}-sbom.json`, text);
        };
    } else {
        document.querySelector("li [data-target=\"#sbom-tab\"]").remove();
        document.querySelector("#sbom-tab").remove();
    }
};

window.addEventListener("load", mainInitializer);