/*
 * Copyright (c) 2023, 2023, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

class HeapBreakdown {
    constructor() {}

    // class fields are not well supported by Closure: https://github.com/google/closure-compiler/issues/2731

    static getInstance() {
        if (!this._instance) {
            this._instance = new HeapBreakdown();
        }
        return this._instance;
    }

    setData(data) {
        this._data = data;
    }

    render(container, totalSizeElementId) {
        const table = document.getElementById(container);
        table.innerHTML = "";

        const totalSizeElem = document.getElementById(totalSizeElementId);
        totalSizeElem.innerText = Utils.toHumanReadableSize(this._data.total);

        const items = this._data.items.sort((a, b) => b.size - a.size);
        for (let i in items) {
            const size = items[i].size;
            const percentage = size * 100 / this._data.total;
            const html =
                `<tr>
                    <td class="heap-item-name">${items[i].name}</td>
                    <td class="heap-item-size">
                        <meter value="${percentage}" min="0" max="100"></meter>
                        <span>${Utils.toPercentage(size / this._data.total, percentage > 0.1 ? 2 : 3)}</b> (${Utils.toHumanReadableSize(size)})</span>
                    </td>
                </tr>`;

            const template = document.createElement("template");
            template.innerHTML = html;

            table.appendChild(template.content.firstChild);
        }
    };
}