# Points-to Inspect

This document describes Points-to Inspect tool that enables visualization of type flow graphs in SubstrateVM.
This tool is a SubstrateVM Enterprise feature.
Since it relies on external libraries which are not cleared for distribution (GSON, NANO_HTTPD, Cytoscape) it is only for Oracle-internal use.

## Usage
The tool can be enabled using the `--macro:analysis-inspect` option with the `native-image` command.
This macro sets the `-H:+InspectGraphs` option and automatically configures the tool.


The macro is available with:
 - Local builds created with `mx --dy /substratevm-enterprise --disable-installables=true ...`
 - Builds that are automatically generated when using `mx native-image` in `substratevm-enterprise`
 - Builds downloaded from https://graalvm.oraclecorp.com/downloads:
    - `ee-complete` builds already contain the tool 
    - for `ee` builds the tool can be installed with `gu install native-image-analysis-inspect`

When the inspect tool is enabled the Native Image generator will run as usual and will pause after the `analysis` step.
At this point it will display a message such as: `Point your browser to http://127.0.0.1:8080/inspect/inspect.html`.
Navigating to that address will display a page such as:
 
![InspectView](../../../../../../resources/img/points-to-inspect-0.png) <!-- .element height="50%" width="50%" -->
<!--<img src="../../../../../../resources/img/points-to-inspect-0.png" width="200px"/>-->

The initial view will be empty.
Using the filters at the top you can select the methods or fields that you wish to visualize.
Each graph node has a context menu that enables you to expand it further.
For example it enables the expansion of the callees of an invocation node.

### Controls
- Use the 'Show navigator' button at the top to show a bird's eye view of the graph. 
It allows you to zoom, pan and focus the main view on a section of the graph.
- Scrolling (i.e., mouse wheel) doesn't move the graph vertically, but instead zooms in and out, using as the center the position of the mouse.
- To drag the graph in the main view click-hold-drag.
- Clicking on a node will show some detailed information on the side.
- You can press 'Reset viewport' to go back to the initial view of the graph.

## Architecture

The type flow graph visualization tool consists of a back-end written in Java and integrated with SubstrateVM Enterprise, and a front-end implemented in HTML/JS which runs in the browser.

### Front-end

The front end entry point can be found at `graal-enterprise/substratevm-enterprise/inspect/inspect.html`. 
The front end is built on top of the `cytoscape.js` graph visualization library.

By default `native-image` will look for the entry point at `./inspect`, thus if `native-image -H:+InspectGraphs` is invoked from the `substratevm-directory` no path needs to be specified.
A custom path can be specified using `-H:InspectServerContentPath=<path-to-inspect-front-end>`.
Using `--macro:analysis-inspect` will automatically set the path to `-H:InspectServerContentPath=${.}/inspect`.

### Back-end

The back-end is fully integrated in SubstrateVM.
When the points-to analysis step completes it performs the two steps necessary in using the analysis inspector:

1. Start a data server, i.e., an HTTP server, which encapsulates the points-to analysis results and exposes the API used to query the analysis results.
It will start at `localhost:some-available-port`.

2. Start a web server that publishes the Inspector root directory so that it can be accessible as a web page.
The web server encapsulates the port on which the data server was started, thus it knows to which service to connect. 
It uses a cookie to transmit this information to the page.
It will start at `localhost:some-other-available-port`.

Given the above design the data server and the web server work in tandem and there can be more than one (data-server:web-server) pairs running at the same time.
This allows the use of the analysis inspector for investigating multiple programs at the same time.
Also, since there are no hard coded port numbers in the web interface code this allows us to start the data server blindly on a default port (e.g. 8080),
 and if we fail scan until we find an open port, then communicate that port to the web interface. 
We use the same port 'scanning' approach when starting the web server.

