/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot.nativeapi;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.handles.ObjectHandlesImpl;
import com.oracle.svm.core.handles.ThreadLocalHandles;
import com.oracle.svm.core.jvmstat.PerfDataSupport;
import com.oracle.svm.core.thread.ThreadingSupportImpl;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.ObjectHandle;
import org.graalvm.nativeimage.Threading;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.VMRuntime;
import org.graalvm.nativeimage.c.CHeader;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.nativeimage.c.type.CConst;
import org.graalvm.nativeimage.c.type.CDoublePointer;
import org.graalvm.nativeimage.c.type.CFloatPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.c.type.CUnsigned;
import org.graalvm.nativeimage.c.type.VoidPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.nativeimage.impl.UnmanagedMemorySupport;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.Language;
import org.graalvm.polyglot.PolyglotAccess;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.io.IOAccess;
import org.graalvm.polyglot.nativeapi.PolyglotAPIHeader;
import org.graalvm.polyglot.nativeapi.PolyglotNativeAPIError;
import org.graalvm.polyglot.nativeapi.types.CBoolPointer;
import org.graalvm.polyglot.nativeapi.types.CInt16Pointer;
import org.graalvm.polyglot.nativeapi.types.CInt32Pointer;
import org.graalvm.polyglot.nativeapi.types.CInt64Pointer;
import org.graalvm.polyglot.nativeapi.types.CInt64PointerPointer;
import org.graalvm.polyglot.nativeapi.types.CInt8Pointer;
import org.graalvm.polyglot.nativeapi.types.CUnsignedBytePointer;
import org.graalvm.polyglot.nativeapi.types.CUnsignedIntPointer;
import org.graalvm.polyglot.nativeapi.types.CUnsignedShortPointer;
import org.graalvm.polyglot.nativeapi.types.PolyglotNativeAPITypes;
import org.graalvm.polyglot.proxy.ProxyArray;
import org.graalvm.polyglot.proxy.ProxyExecutable;
import org.graalvm.polyglot.proxy.ProxyObject;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@CHeader(value=PolyglotAPIHeader.class)
public final class PolyglotNativeAPI {
    private static final Charset UTF8_CHARSET = StandardCharsets.UTF_8;
    private static final int MAX_UNSIGNED_BYTE = 255;
    private static final int MAX_UNSIGNED_SHORT = 65535;
    private static final long MAX_UNSIGNED_INT = 0xFFFFFFFFL;
    private static final UnsignedWord POLY_AUTO_LENGTH = WordFactory.unsigned((long)-1L);
    private static final int DEFAULT_FRAME_CAPACITY = 16;
    private static final ThreadLocal<CallbackException> exceptionsTL = new ThreadLocal();
    private static final FastThreadLocalObject<ThreadLocalState> threadLocals = FastThreadLocalFactory.createObject(ThreadLocalState.class, (String)"PolyglotNativeAPI.threadLocals");
    private static final ObjectHandlesImpl objectHandles = new ObjectHandlesImpl(WordFactory.signed((long)Long.MIN_VALUE), ThreadLocalHandles.nullHandle().subtract(1), ThreadLocalHandles.nullHandle());
    private static final ExecutorService closeContextExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());

    private static ThreadLocalState ensureLocalsInitialized() {
        ThreadLocalState state = (ThreadLocalState)threadLocals.get();
        if (state == null) {
            state = new ThreadLocalState();
            threadLocals.set((Object)state);
        }
        return state;
    }

    private static ThreadLocalHandles<PolyglotNativeAPITypes.PolyglotHandle> getHandles() {
        ThreadLocalState locals = PolyglotNativeAPI.ensureLocalsInitialized();
        if (locals.handles == null) {
            locals.handles = new ThreadLocalHandles(16);
        }
        return locals.handles;
    }

    private static void nullCheck(PointerBase ptr, String fieldName) {
        if (ptr.isNull()) {
            throw new NullPointerException(fieldName + " must be not be null");
        }
    }

    @CEntryPoint(name="poly_create_engine_builder", exceptionHandler=ExceptionHandler.class, documentation={"Creates a new context builder that allows to configure an engine instance.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Engine.html#newBuilder--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_create_engine_builder(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotEngineBuilderPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(result, "result");
        PolyglotNativeAPITypes.PolyglotHandle handle = PolyglotNativeAPI.createHandle(Engine.newBuilder());
        result.write(handle);
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_engine_builder_option", exceptionHandler=ExceptionHandler.class, documentation={"Sets an option for an <code>poly_engine_builder</code> that will apply to constructed engines.", "", "@param engine_builder that is assigned an option.", "@param key_utf8 0 terminated and UTF-8 encoded key for the option.", "@param value_utf8 0 terminated and UTF-8 encoded value for the option.", "@return poly_ok if all works, poly_generic_error if there is a failure.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Engine.html#newBuilder--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_create_engine_builder(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotEngineBuilder engine_builder, @CConst CCharPointer key_utf8, @CConst CCharPointer value_utf8) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(engine_builder, "engine_builder");
        PolyglotNativeAPI.nullCheck((PointerBase)key_utf8, "key_utf8");
        PolyglotNativeAPI.nullCheck((PointerBase)value_utf8, "value_utf8");
        Engine.Builder eb = (Engine.Builder)PolyglotNativeAPI.fetchHandle(engine_builder);
        eb.option(CTypeConversion.utf8ToJavaString((CCharPointer)key_utf8), CTypeConversion.utf8ToJavaString((CCharPointer)value_utf8));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_engine_builder_build", exceptionHandler=ExceptionHandler.class, documentation={"Builds an <code>engine</code> from an <code>engine_builder</code>. The same builder can be used to ", "produce multiple <code>poly_engine</code> instances.", "", "@param engine_builder that is used to build.", "@param result the created engine.", "@return poly_ok if all works, poly_generic_error if there is a failure.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Engine.Builder.html#build--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_engine_builder_build(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotEngineBuilder engine_builder, PolyglotNativeAPITypes.PolyglotEnginePointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(engine_builder, "engine_builder");
        PolyglotNativeAPI.nullCheck(result, "result");
        Engine.Builder engineBuilder = (Engine.Builder)PolyglotNativeAPI.fetchHandle(engine_builder);
        result.write(PolyglotNativeAPI.createHandle(engineBuilder.build()));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_create_engine", exceptionHandler=ExceptionHandler.class, documentation={"Creates a polyglot engine: An execution engine for Graal guest languages that allows to inspect the ", "installed languages and can have multiple execution contexts.", "", "Engine is a unit that holds configuration, instruments, and compiled code for all contexts assigned ", "to this engine.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Engine.html#create--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_create_engine(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotEnginePointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(result, "result");
        PolyglotNativeAPITypes.PolyglotHandle handle = PolyglotNativeAPI.createHandle(Engine.create());
        result.write(handle);
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_engine_close", exceptionHandler=ExceptionHandler.class, documentation={"Closes this engine and frees up allocated native resources. If there are still open context", "instances that were created using this engine and they are currently not being executed then", "they will be closed automatically. If an attempt to close an engine was successful then", "consecutive calls to close have no effect. If a context is cancelled then the currently", "executing thread will throw a {@link PolyglotException}.", "", "@param engine to be closed.", "@param cancel_if_executing if <code>true</code> then currently executing contexts will be cancelled.", "@return poly_ok if all works, poly_generic_error if there is a failure.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Engine.html#close-boolean-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_engine_close(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotEngine engine, boolean cancel_if_executing) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(engine, "engine");
        Engine jEngine = (Engine)PolyglotNativeAPI.fetchHandle(engine);
        jEngine.close(cancel_if_executing);
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_engine_get_languages", exceptionHandler=ExceptionHandler.class, documentation={"Returns an array where each element is a <code>poly_language<code> handle.", "", "To use, make two calls to this method:", "", "   The first passing a size_t pointer to write the count of the languages to (IE: 'size_t poly_language_count')", "   The second passing the value of the written size_t length, and a pointer to a poly_language[poly_language_size]", "<code>", "size_t poly_language_count;", "", "// Get the number of languages", "poly_engine_get_languages(thread, engine, NULL, &poly_language_count);", "", "// Allocate properly sized array of poly_language[]", "poly_language languages_ptr[poly_language_count];", "", "// Write the language handles into the array", "poly_engine_get_languages(thread, engine, &languages_ptr, &num_languages);", "</code>", "", "@param engine for which languages are returned.", "@param language_array array to write <code>poly_language</code>s to or NULL.", "@param size the number of languages in the engine.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Engine.html#getLanguages--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_engine_get_languages(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotEngine engine, PolyglotNativeAPITypes.PolyglotLanguagePointer language_array, PolyglotNativeAPITypes.SizeTPointer size) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(engine, "engine");
        PolyglotNativeAPI.nullCheck(size, "size");
        Engine jEngine = (Engine)PolyglotNativeAPI.fetchHandle(engine);
        UnsignedWord languagesSize = WordFactory.unsigned((int)jEngine.getLanguages().size());
        if (language_array.isNull()) {
            size.write(languagesSize);
        } else {
            size.write(languagesSize);
            List<Language> sortedLanguages = PolyglotNativeAPI.sortedLangs((Engine)PolyglotNativeAPI.fetchHandle(engine));
            for (int i = 0; i < sortedLanguages.size(); ++i) {
                language_array.write(i, PolyglotNativeAPI.createHandle(sortedLanguages.get(i)));
            }
        }
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_create_context_builder", exceptionHandler=ExceptionHandler.class, documentation={"Creates a context with a new engine polyglot engine with a list ", "", "A context holds all of the program data. Each context is by default isolated from all other contexts", "with respect to program data and evaluation semantics.", "", "@param permittedLanguages array of 0 terminated language identifiers in UTF-8 that are permitted.", "@param length of the array of language identifiers.", "@param result the created context.", "@return poly_ok if all works, poly_generic_error if there is a failure.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Context.html#newBuilder-java.lang.String...-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_create_context_builder(PolyglotNativeAPITypes.PolyglotIsolateThread thread, @CConst CCharPointerPointer permitted_languages, UnsignedWord length, PolyglotNativeAPITypes.PolyglotContextBuilderPointer result) {
        PolyglotNativeAPI.resetErrorState();
        if (length.aboveThan(0)) {
            PolyglotNativeAPI.nullCheck((PointerBase)permitted_languages, "permitted_languages");
        }
        PolyglotNativeAPI.nullCheck(result, "result");
        ArrayList<String> jPermittedLangs = new ArrayList<String>();
        int i = 0;
        while (length.aboveThan(i)) {
            jPermittedLangs.add(CTypeConversion.toJavaString((CCharPointer)permitted_languages.read(i)));
            ++i;
        }
        Context.Builder c = Context.newBuilder((String[])jPermittedLangs.toArray(new String[jPermittedLangs.size()]));
        result.write(PolyglotNativeAPI.createHandle(c));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_context_builder_engine", exceptionHandler=ExceptionHandler.class, documentation={"Sets an engine for the context builder.", "", "@param context_builder that is assigned an engine.", "@param engine to assign to this builder.", "@return poly_ok if all works, poly_generic_error if there is a failure.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Context.Builder.html#engine-org.graalvm.polyglot.Engine-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_context_builder_engine(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotContextBuilder context_builder, PolyglotNativeAPITypes.PolyglotEngine engine) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(context_builder, "context_builder");
        PolyglotNativeAPI.nullCheck(engine, "engine");
        Context.Builder contextBuilder = (Context.Builder)PolyglotNativeAPI.fetchHandle(context_builder);
        Engine jEngine = (Engine)PolyglotNativeAPI.fetchHandle(engine);
        contextBuilder.engine(jEngine);
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_context_builder_option", exceptionHandler=ExceptionHandler.class, documentation={"Sets an option on a <code>poly_context_builder</code>.", "", "@param context_builder that is assigned an option.", "@param key_utf8 0 terminated and UTF-8 encoded key for the option.", "@param value_utf8 0 terminated and UTF-8 encoded value for the option.", "@return poly_ok if all works, poly_generic_error if there is a failure.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Context.Builder.html#option-java.lang.String-java.lang.String-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_context_builder_option(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotContextBuilder context_builder, @CConst CCharPointer key_utf8, @CConst CCharPointer value_utf8) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(context_builder, "context_builder");
        PolyglotNativeAPI.nullCheck((PointerBase)key_utf8, "key_utf8");
        PolyglotNativeAPI.nullCheck((PointerBase)value_utf8, "value_utf8");
        Context.Builder contextBuilder = (Context.Builder)PolyglotNativeAPI.fetchHandle(context_builder);
        contextBuilder.option(CTypeConversion.utf8ToJavaString((CCharPointer)key_utf8), CTypeConversion.utf8ToJavaString((CCharPointer)value_utf8));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_context_builder_output", exceptionHandler=ExceptionHandler.class, documentation={"Sets output handlers for a <code>poly_context_builder</code>.", "", "@param context_builder that is modified.", "@param stdout_handler callback used for context_builder output stream. Not used if NULL.", "@param stderr_handler callback used for context_builder error stream. Not used if NULL.", "@param data user-defined data to be passed to stdout_handler and stderr_handler callbacks.", "@return poly_ok if all works, poly_generic_error if there is a failure.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Context.Builder.html#out-java.io.OutputStream-", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Context.Builder.html#err-java.io.OutputStream-", "@since 23.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_context_builder_output(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotContextBuilder context_builder, PolyglotNativeAPITypes.PolyglotOutputHandler stdout_handler, PolyglotNativeAPITypes.PolyglotOutputHandler stderr_handler, VoidPointer data) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(context_builder, "context_builder");
        Context.Builder contextBuilder = (Context.Builder)PolyglotNativeAPI.fetchHandle(context_builder);
        if (stdout_handler.isNonNull()) {
            contextBuilder.out(PolyglotNativeAPI.newOutputStreamFor(stdout_handler, data));
        }
        if (stderr_handler.isNonNull()) {
            contextBuilder.err(PolyglotNativeAPI.newOutputStreamFor(stderr_handler, data));
        }
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    private static OutputStream newOutputStreamFor(final PolyglotNativeAPITypes.PolyglotOutputHandler outputHandler, final VoidPointer data) {
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                this.write(new byte[]{(byte)b});
            }

            @Override
            public void write(byte[] b, int off, int len) {
                Objects.checkFromIndexSize(off, len, b.length);
                if (len == 0) {
                    return;
                }
                try (CTypeConversion.CCharPointerHolder bytes = CTypeConversion.toCBytes((byte[])b);){
                    outputHandler.invoke(bytes.get().addressOf(off), WordFactory.unsigned((int)len), data);
                }
            }
        };
    }

    @CEntryPoint(name="poly_context_builder_allow_all_access", exceptionHandler=ExceptionHandler.class, documentation={"Allows or disallows all access for a <code>poly_context_builder</code>.", "", "@param context_builder that is modified.", "@param allow_all_access bool value that defines all access.", "@return poly_ok if all works, poly_generic_error if there is a failure.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Context.Builder.html#allowAllAccess-boolean-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_context_builder_allow_all_access(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotContextBuilder context_builder, boolean allow_all_access) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(context_builder, "context_builder");
        Context.Builder contextBuilder = (Context.Builder)PolyglotNativeAPI.fetchHandle(context_builder);
        contextBuilder.allowAllAccess(allow_all_access);
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_context_builder_allow_io", exceptionHandler=ExceptionHandler.class, documentation={"Allows or disallows IO for a <code>poly_context_builder</code>.", "", "@param context_builder that is modified.", "@param allow_IO bool value that is passed to the builder.", "@return poly_ok if all works, poly_generic_error if there is a failure.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Context.Builder.html#allowIO-org.graalvm.polyglot.io.IOAccess-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_context_builder_allow_io(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotContextBuilder context_builder, boolean allow_IO) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(context_builder, "context_builder");
        Context.Builder contextBuilder = (Context.Builder)PolyglotNativeAPI.fetchHandle(context_builder);
        contextBuilder.allowIO(allow_IO ? IOAccess.ALL : IOAccess.NONE);
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_context_builder_allow_native_access", exceptionHandler=ExceptionHandler.class, documentation={"Allows or disallows native access for a <code>poly_context_builder</code>.", "", "@param context_builder that is modified.", "@param allow_native_access bool value that is passed to the builder.", "@return poly_ok if all works, poly_generic_error if there is a failure.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Context.Builder.html#allowNativeAccess-boolean-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_context_builder_allow_native_access(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotContextBuilder context_builder, boolean allow_native_access) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(context_builder, "context_builder");
        Context.Builder contextBuilder = (Context.Builder)PolyglotNativeAPI.fetchHandle(context_builder);
        contextBuilder.allowNativeAccess(allow_native_access);
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_context_builder_allow_polyglot_access", exceptionHandler=ExceptionHandler.class, documentation={"Allows or disallows polyglot access for a <code>poly_context_builder</code>.", "", "@param context_builder that is modified.", "@param allow_polyglot_access bool value that is passed to the builder.", "@return poly_ok if all works, poly_generic_error if there is a failure.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Context.Builder.html#allowPolyglotAccess-org.graalvm.polyglot.PolyglotAccess-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_context_builder_allow_polyglot_access(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotContextBuilder context_builder, boolean allow_polyglot_access) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(context_builder, "context_builder");
        Context.Builder contextBuilder = (Context.Builder)PolyglotNativeAPI.fetchHandle(context_builder);
        contextBuilder.allowPolyglotAccess(allow_polyglot_access ? PolyglotAccess.ALL : PolyglotAccess.NONE);
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_context_builder_allow_create_thread", exceptionHandler=ExceptionHandler.class, documentation={"Allows or disallows thread creation for a <code>poly_context_builder</code>.", "", "@param context_builder that is modified.", "@param allow_create_thread bool value that is passed to the builder.", "@return poly_ok if all works, poly_generic_error if there is a failure.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Context.Builder.html#allowCreateThread-boolean-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_context_builder_allow_create_thread(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotContextBuilder context_builder, boolean allow_create_thread) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(context_builder, "context_builder");
        Context.Builder contextBuilder = (Context.Builder)PolyglotNativeAPI.fetchHandle(context_builder);
        contextBuilder.allowCreateThread(allow_create_thread);
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_context_builder_allow_experimental_options", exceptionHandler=ExceptionHandler.class, documentation={"Allows or disallows experimental options for a <code>poly_context_builder</code>.", "", "@param context_builder that is modified.", "@param allow_experimental_options bool value that is passed to the builder.", "@return poly_ok if all works, poly_generic_error if there is a failure.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Context.Builder.html#allowExperimentalOptions-boolean-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_context_builder_allow_experimental_options(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotContextBuilder context_builder, boolean allow_experimental_options) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(context_builder, "context_builder");
        Context.Builder contextBuilder = (Context.Builder)PolyglotNativeAPI.fetchHandle(context_builder);
        contextBuilder.allowExperimentalOptions(allow_experimental_options);
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_context_builder_build", exceptionHandler=ExceptionHandler.class, documentation={"Builds a <code>context</code> from a <code>context_builder</code>. The same builder can be used to ", "produce multiple <code>poly_context</code> instances.", "", "@param context_builder that is used to construct a new context.", "@param result the created context.", "@return poly_ok if all works, poly_generic_error if there is a failure.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Context.Builder.html#build--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_context_builder_build(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotContextBuilder context_builder, PolyglotNativeAPITypes.PolyglotContextPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(context_builder, "context_builder");
        PolyglotNativeAPI.nullCheck(result, "result");
        Context.Builder contextBuilder = (Context.Builder)PolyglotNativeAPI.fetchHandle(context_builder);
        result.write(PolyglotNativeAPI.createHandle(contextBuilder.build()));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_create_context", exceptionHandler=ExceptionHandler.class, documentation={"Creates a context with default configuration.", "", "A context holds all of the program data. Each context is by default isolated from all other contexts", "with respect to program data and evaluation semantics.", "", "@param permitted_languages array of 0 terminated language identifiers in UTF-8 that are permitted, or NULL for supporting all available languages.", "@param length of the array of language identifiers.", "@param result the created context.", "@return poly_ok if all works, poly_generic_error if there is a failure.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Context.html#create-java.lang.String...-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_create_context(PolyglotNativeAPITypes.PolyglotIsolateThread thread, @CConst CCharPointerPointer permitted_languages, UnsignedWord length, PolyglotNativeAPITypes.PolyglotContextPointer result) {
        Context c;
        PolyglotNativeAPI.resetErrorState();
        if (length.aboveThan(0) && permitted_languages.isNull()) {
            throw new IllegalArgumentException("Permitted_languages should not be null when length is not zero.");
        }
        PolyglotNativeAPI.nullCheck(result, "result");
        if (permitted_languages.isNull()) {
            c = Context.create((String[])new String[0]);
        } else {
            ArrayList<String> jPermittedLangs = new ArrayList<String>();
            int i = 0;
            while (length.aboveThan(i)) {
                jPermittedLangs.add(CTypeConversion.toJavaString((CCharPointer)permitted_languages.read(i)));
                ++i;
            }
            c = Context.create((String[])jPermittedLangs.toArray(new String[jPermittedLangs.size()]));
        }
        result.write(PolyglotNativeAPI.createHandle(c));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_context_close", exceptionHandler=ExceptionHandler.class, documentation={"Closes this context and frees up potentially allocated native resources. A ", "context cannot free all native resources allocated automatically. For this reason", "it is necessary to close contexts after use. If a context is canceled then the", "currently executing thread will throw a {@link PolyglotException}. Please note ", "that canceling a single context can negatively affect the performance of other ", "executing contexts constructed with the same engine.", "", "If internal errors occur during closing of the language then they are printed to the ", "configured {@link Builder#err(OutputStream) error output stream}. If a context was ", "closed then all its methods will throw an {@link IllegalStateException} when invoked. ", "If an attempt to close a context was successful then consecutive calls to close have ", "no effect.", "", "@param context to be closed.", "@param cancel_if_executing if <code>true</code> then currently executing context will be cancelled.", "@return poly_ok if all works, poly_generic_error if there is a failure.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Context.html#close-boolean-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_context_close(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotContext context, boolean cancel_if_executing) {
        PolyglotNativeAPI.nullCheck(context, "context");
        PolyglotNativeAPI.resetErrorState();
        Context jContext = (Context)PolyglotNativeAPI.fetchHandle(context);
        jContext.close(cancel_if_executing);
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_context_close_async", exceptionHandler=ExceptionHandler.class, documentation={"Request for this context to be closed asynchronously.", "An attempt to closed this context will later be made via a background thread.", "Note this call will attempt to close a context; however, it is not guaranteed the closure will be successful.", "", "@param context to be closed.", "@return poly_ok if closure request submitted, poly_generic_error if there is a failure.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Context.html#close-boolean-", "@since 22.3"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_context_close_async(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotContext context) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(context, "context");
        Context jContext = (Context)PolyglotNativeAPI.fetchHandle(context);
        closeContextExecutor.execute(() -> jContext.close(true));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_context_eval", exceptionHandler=ExceptionHandler.class, documentation={"Evaluate a source of guest languages inside a context.", "", "@param context in which we evaluate source code.", "@param language_id_utf8 0 terminated and UTF-8 encoded language identifier.", "@param name_utf8 0 terminated and UTF-8 encoded name given to the evaluate source code.", "@param source_utf8 0 terminated and UTF-8 encoded source code to be evaluated.", "@param result <code>poly_value</code> that is the result of the evaluation. You can pass <code>NULL</code> if you just want to evaluate the source and you can ignore the result.", "@return poly_ok if all works, poly_generic_error if there is a failure.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Source.html#newBuilder-java.lang.String-java.lang.CharSequence-java.lang.String-", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Context.html#eval-org.graalvm.polyglot.Source-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_context_eval(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotContext context, @CConst CCharPointer language_id_utf8, @CConst CCharPointer name_utf8, @CConst CCharPointer source_utf8, PolyglotNativeAPITypes.PolyglotValuePointer result) throws Exception {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(context, "context");
        PolyglotNativeAPI.nullCheck((PointerBase)language_id_utf8, "language_id_utf8");
        PolyglotNativeAPI.nullCheck((PointerBase)name_utf8, "name_utf8");
        PolyglotNativeAPI.nullCheck((PointerBase)source_utf8, "source_utf8");
        PolyglotNativeAPI.nullCheck(result, "result");
        Context c = (Context)PolyglotNativeAPI.fetchHandle(context);
        String languageName = CTypeConversion.utf8ToJavaString((CCharPointer)language_id_utf8);
        String jName = CTypeConversion.utf8ToJavaString((CCharPointer)name_utf8);
        String jCode = CTypeConversion.utf8ToJavaString((CCharPointer)source_utf8);
        Source sourceCode = Source.newBuilder((String)languageName, (CharSequence)jCode, (String)jName).build();
        Value evalResult = c.eval(sourceCode);
        if (result.isNonNull()) {
            result.write(PolyglotNativeAPI.createHandle(evalResult));
        }
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_context_get_engine", exceptionHandler=ExceptionHandler.class, documentation={"Returns the engine this context belongs to.", "", "@param context for which we extract the bindings.", "@param result a value whose members correspond to the symbols in the top scope of the `language_id`.", "@return poly_ok if everything is fine, poly_generic_failure if there is an error.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Context.html#getEngine--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_context_get_engine(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotContext context, PolyglotNativeAPITypes.PolyglotValuePointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(context, "context");
        PolyglotNativeAPI.nullCheck(result, "result");
        Context jContext = (Context)PolyglotNativeAPI.fetchHandle(context);
        result.write(PolyglotNativeAPI.createHandle(jContext.getEngine()));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_context_get_bindings", exceptionHandler=ExceptionHandler.class, documentation={"Returns a value that represents the top-most bindings of a language. The top-most bindings of", "the language are a value whose members correspond to each symbol in the top scope.", "", "Languages may allow modifications of members of the returned bindings object at the", "language's discretion. If the language was not yet initialized it", "will be initialized when the bindings are requested.", "", "@param context for which we extract the bindings.", "@param language_id_utf8 0 terminated and UTF-8 encoded language identifier.", "@param result a value whose members correspond to the symbols in the top scope of the `language_id_utf8`.", "@return poly_generic_failure if the language does not exist, if context is already closed, ", "        in case the lazy initialization failed due to a guest language error.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Context.html#getBindings-java.lang.String-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_context_get_bindings(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotContext context, @CConst CCharPointer language_id_utf8, PolyglotNativeAPITypes.PolyglotValuePointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(context, "context");
        PolyglotNativeAPI.nullCheck((PointerBase)language_id_utf8, "language_id_utf8");
        PolyglotNativeAPI.nullCheck(result, "result");
        Context jContext = (Context)PolyglotNativeAPI.fetchHandle(context);
        String jLanguage = CTypeConversion.utf8ToJavaString((CCharPointer)language_id_utf8);
        Value languageBindings = jContext.getBindings(jLanguage);
        result.write(PolyglotNativeAPI.createHandle(languageBindings));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_context_get_polyglot_bindings", exceptionHandler=ExceptionHandler.class, documentation={"Returns polyglot bindings that may be used to exchange symbols between the host and ", "guest languages. All languages have unrestricted access to the polyglot bindings. ", "The returned bindings object always has members and its members are readable, writable and removable.", "", "Guest languages may put and get members through language specific APIs. For example, ", "in JavaScript symbols of the polyglot bindings can be accessed using ", "`Polyglot.import(\"name\")` and set using `Polyglot.export(\"name\", value)`. Please see ", "the individual language reference on how to access these symbols.", "", "@return poly_ok if all works, poly_generic_failure if context is already closed.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Context.html#getPolyglotBindings--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_context_get_polyglot_bindings(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotContext context, PolyglotNativeAPITypes.PolyglotValuePointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(context, "context");
        PolyglotNativeAPI.nullCheck(result, "result");
        Context jContext = (Context)PolyglotNativeAPI.fetchHandle(context);
        result.write(PolyglotNativeAPI.createHandle(jContext.getPolyglotBindings()));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_value_can_execute", exceptionHandler=ExceptionHandler.class, documentation={"Checks whether a polyglot value can be executed.", "", "@param value a polyglot value.", "@param result true if the value can be executed, false otherwise.", "@return poly_ok if all works, poly_generic_error if there is a failure.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Value.html#canExecute--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_value_can_execute(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotValue value, CBoolPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(value, "value");
        PolyglotNativeAPI.nullCheck(result, "result");
        Value jValue = (Value)PolyglotNativeAPI.fetchHandle(value);
        result.write(CTypeConversion.toCBoolean((boolean)jValue.canExecute()));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_value_execute", exceptionHandler=ExceptionHandler.class, documentation={"Executes a value if it can be executed and returns its result. All arguments passed ", "must be polyglot values.", "", "@param value to be executed.", "@param args array of poly_value.", "@param args_size length of the args array.", "@param result <code>poly_value</code> that is the result of the execution. You can pass <code>NULL</code> if you just want to execute the source and you can ignore the result.", "@return poly_ok if all works, poly_generic_error if the underlying context was closed, if a wrong ", "         number of arguments was provided or one of the arguments was not applicable, if this value cannot be executed,", " and if a guest language error occurred during execution.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Value.html#execute-java.lang.Object...-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_value_execute(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotValue value, PolyglotNativeAPITypes.PolyglotValuePointer args, int args_size, PolyglotNativeAPITypes.PolyglotValuePointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(value, "value");
        if (args_size > 0) {
            PolyglotNativeAPI.nullCheck(args, "args");
        }
        Value function = (Value)PolyglotNativeAPI.fetchHandle(value);
        Object[] jArgs = new Object[args_size];
        for (int i = 0; i < args_size; ++i) {
            PolyglotNativeAPITypes.PolyglotValue handle = args.read(i);
            jArgs[i] = PolyglotNativeAPI.fetchHandle(handle);
        }
        Value resultValue = function.execute(jArgs);
        if (result.isNonNull()) {
            result.write(PolyglotNativeAPI.createHandle(resultValue));
        }
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_value_get_member", exceptionHandler=ExceptionHandler.class, documentation={"Returns the member with a given `identifier_utf8` or `null` if the member does not exist.", "", "@param identifier_utf8 0 terminated and UTF-8 encoded member identifier.", "@return poly_ok if all works, poly_generic_failure if the value has no members, the given identifier exists ", "        but is not readable, if a guest language error occurred during execution.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Value.html#getMember-java.lang.String-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_value_get_member(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotValue value, @CConst CCharPointer identifier_utf8, PolyglotNativeAPITypes.PolyglotValuePointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(value, "value");
        PolyglotNativeAPI.nullCheck((PointerBase)identifier_utf8, "identifier_utf8");
        PolyglotNativeAPI.nullCheck(result, "result");
        Value jObject = (Value)PolyglotNativeAPI.fetchHandle(value);
        result.write(PolyglotNativeAPI.createHandle(jObject.getMember(CTypeConversion.utf8ToJavaString((CCharPointer)identifier_utf8))));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_value_put_member", exceptionHandler=ExceptionHandler.class, documentation={"Sets the value of a member with the `identifier_utf8`.", "", "@param identifier_utf8 0 terminated and UTF-8 encoded member identifier.", "@return poly_ok if all works, poly_generic_failure if the context is already closed, if the value does ", "         not have any members, the key does not exist and new members cannot be added, or the existing ", "         member is not modifiable.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Value.html#putMember-java.lang.String-java.lang.Object-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_value_put_member(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotValue value, @CConst CCharPointer identifier_utf8, PolyglotNativeAPITypes.PolyglotValue member) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(value, "value");
        PolyglotNativeAPI.nullCheck((PointerBase)identifier_utf8, "identifier_utf8");
        Value jObject = (Value)PolyglotNativeAPI.fetchHandle(value);
        Value jMember = (Value)PolyglotNativeAPI.fetchHandle(member);
        jObject.putMember(CTypeConversion.utf8ToJavaString((CCharPointer)identifier_utf8), (Object)jMember);
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_value_has_member", exceptionHandler=ExceptionHandler.class, documentation={"Returns `true` if such a member exists for the given `identifier_utf8`. If the value has no members ", "then it returns `false`.", "", "@param identifier_utf8 0 terminated and UTF-8 encoded member identifier.", "@return poly_ok if all works, poly_generic_failure if the underlying context was closed, if guest language error occurred ", "         during execution.", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Value.html#hasMember-java.lang.String-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_value_has_member(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotValue value, @CConst CCharPointer identifier_utf8, CBoolPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(value, "value");
        PolyglotNativeAPI.nullCheck((PointerBase)identifier_utf8, "identifier_utf8");
        PolyglotNativeAPI.nullCheck(result, "result");
        Value jObject = (Value)PolyglotNativeAPI.fetchHandle(value);
        result.write(CTypeConversion.toCBoolean((boolean)jObject.hasMember(CTypeConversion.utf8ToJavaString((CCharPointer)identifier_utf8))));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_create_boolean", exceptionHandler=ExceptionHandler.class, documentation={"Creates a polyglot boolean value from a C boolean.", "", "@return poly_ok if all works, poly_generic_failure if context is null, if the underlying context was closed.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Context.html#asValue-java.lang.Object-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_create_boolean(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotContext context, boolean value, PolyglotNativeAPITypes.PolyglotValuePointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(context, "context");
        PolyglotNativeAPI.nullCheck(result, "result");
        Context ctx = (Context)PolyglotNativeAPI.fetchHandle(context);
        result.write(PolyglotNativeAPI.createHandle(ctx.asValue((Object)value)));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_create_int8", exceptionHandler=ExceptionHandler.class, documentation={"Creates a polyglot integer number from `int8_t`.", "", "@return poly_ok if all works, poly_generic_failure if context is null, if the underlying context was closed.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Context.html#asValue-java.lang.Object-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_create_int8(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotContext context, byte value, PolyglotNativeAPITypes.PolyglotValuePointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(context, "context");
        PolyglotNativeAPI.nullCheck(result, "result");
        Context ctx = (Context)PolyglotNativeAPI.fetchHandle(context);
        result.write(PolyglotNativeAPI.createHandle(ctx.asValue((Object)value)));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_create_int16", exceptionHandler=ExceptionHandler.class, documentation={"Creates a polyglot integer number from `int16_t`.", "", "@return poly_ok if all works, poly_generic_failure if context is null, if the underlying context was closed.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Context.html#asValue-java.lang.Object-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_create_int16(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotContext context, short value, PolyglotNativeAPITypes.PolyglotValuePointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(context, "context");
        PolyglotNativeAPI.nullCheck(result, "result");
        Context ctx = (Context)PolyglotNativeAPI.fetchHandle(context);
        result.write(PolyglotNativeAPI.createHandle(ctx.asValue((Object)value)));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_create_int32", exceptionHandler=ExceptionHandler.class, documentation={"Creates a polyglot integer number from `int32_t`.", "", "@return poly_ok if all works, poly_generic_failure if context is null, if the underlying context was closed.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Context.html#asValue-java.lang.Object-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_create_int32(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotContext context, int value, PolyglotNativeAPITypes.PolyglotValuePointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(context, "context");
        PolyglotNativeAPI.nullCheck(result, "result");
        Context ctx = (Context)PolyglotNativeAPI.fetchHandle(context);
        result.write(PolyglotNativeAPI.createHandle(ctx.asValue((Object)value)));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_create_int64", exceptionHandler=ExceptionHandler.class, documentation={"Creates a polyglot integer number from `int64_t`.", "", "@return poly_ok if all works, poly_generic_failure if context is null, if the underlying context was closed.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Context.html#asValue-java.lang.Object-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_create_int64(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotContext context, long value, PolyglotNativeAPITypes.PolyglotValuePointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(context, "context");
        PolyglotNativeAPI.nullCheck(result, "result");
        Context ctx = (Context)PolyglotNativeAPI.fetchHandle(context);
        result.write(PolyglotNativeAPI.createHandle(ctx.asValue((Object)value)));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_create_uint8", exceptionHandler=ExceptionHandler.class, documentation={"Creates a polyglot integer number from `uint8_t`.", "", "@return poly_ok if all works, poly_generic_failure if context is null, if the underlying context was closed.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Context.html#asValue-java.lang.Object-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_create_uint8(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotContext context, @CUnsigned byte value, PolyglotNativeAPITypes.PolyglotValuePointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(context, "context");
        PolyglotNativeAPI.nullCheck(result, "result");
        Context ctx = (Context)PolyglotNativeAPI.fetchHandle(context);
        result.write(PolyglotNativeAPI.createHandle(ctx.asValue((Object)Byte.toUnsignedInt(value))));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_create_uint16", exceptionHandler=ExceptionHandler.class, documentation={"Creates a polyglot integer number from `uint16_t`.", "", "@return poly_ok if all works, poly_generic_failure if context is null, if the underlying context was closed.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Context.html#asValue-java.lang.Object-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_create_uint16(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotContext context, @CUnsigned short value, PolyglotNativeAPITypes.PolyglotValuePointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(context, "context");
        PolyglotNativeAPI.nullCheck(result, "result");
        Context ctx = (Context)PolyglotNativeAPI.fetchHandle(context);
        result.write(PolyglotNativeAPI.createHandle(ctx.asValue((Object)Short.toUnsignedInt(value))));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_create_uint32", exceptionHandler=ExceptionHandler.class, documentation={"Creates a polyglot integer number from `uint32_t`.", "", "@return poly_ok if all works, poly_generic_failure if context is null, if the underlying context was closed.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Context.html#asValue-java.lang.Object-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_create_uint32(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotContext context, @CUnsigned int value, PolyglotNativeAPITypes.PolyglotValuePointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(context, "context");
        PolyglotNativeAPI.nullCheck(result, "result");
        Context ctx = (Context)PolyglotNativeAPI.fetchHandle(context);
        result.write(PolyglotNativeAPI.createHandle(ctx.asValue((Object)Integer.toUnsignedLong(value))));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_create_float", exceptionHandler=ExceptionHandler.class, documentation={"Creates a polyglot floating point number from C `float`.", "", "@return poly_ok if all works, poly_generic_failure if context is null, if the underlying context was closed.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Context.html#asValue-java.lang.Object-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_create_float(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotContext context, float value, PolyglotNativeAPITypes.PolyglotValuePointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(context, "context");
        PolyglotNativeAPI.nullCheck(result, "result");
        Context ctx = (Context)PolyglotNativeAPI.fetchHandle(context);
        result.write(PolyglotNativeAPI.createHandle(ctx.asValue((Object)Float.valueOf(value))));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_create_double", exceptionHandler=ExceptionHandler.class, documentation={"Creates a polyglot floating point number from C `double`.", "", "@return poly_ok if all works, poly_generic_failure if context is null, if the underlying context was closed.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Context.html#asValue-java.lang.Object-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_create_double(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotContext context, double value, PolyglotNativeAPITypes.PolyglotValuePointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(context, "context");
        PolyglotNativeAPI.nullCheck(result, "result");
        Context ctx = (Context)PolyglotNativeAPI.fetchHandle(context);
        result.write(PolyglotNativeAPI.createHandle(ctx.asValue((Object)value)));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_create_character", exceptionHandler=ExceptionHandler.class, documentation={"Creates a polyglot character from C `char`.", "", "@return poly_ok if all works, poly_generic_failure if context is null, if the underlying context was closed.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Context.html#asValue-java.lang.Object-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_create_character(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotContext context, char character, PolyglotNativeAPITypes.PolyglotValuePointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(context, "context");
        PolyglotNativeAPI.nullCheck(result, "result");
        Context ctx = (Context)PolyglotNativeAPI.fetchHandle(context);
        result.write(PolyglotNativeAPI.createHandle(ctx.asValue((Object)Character.valueOf(character))));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_create_string_utf8", exceptionHandler=ExceptionHandler.class, documentation={"Creates a polyglot string from an UTF-8 encoded string. ", "If `POLY_AUTO_LENGTH` is passed as the `length` argument, then `string_utf8` is decoded until a 0 terminator is found.", "Otherwise, `length` bytes from `string_uft8` are encoded as a polyglot string value.", "", "@param string_utf8 UTF-8 encoded C string, which may or may not be 0 terminated.", "@param length POLY_AUTO_LENGTH if the string is 0 terminated, or otherwise the length of C string.", "@return the polyglot string value.", "@return poly_ok if all works, poly_generic_failure if context is null, if the underlying context was closed.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Context.html#asValue-java.lang.Object-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_create_string_utf8(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotContext context, @CConst CCharPointer string_utf8, UnsignedWord length, PolyglotNativeAPITypes.PolyglotValuePointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(context, "context");
        PolyglotNativeAPI.nullCheck((PointerBase)string_utf8, "string_utf8");
        PolyglotNativeAPI.nullCheck(result, "result");
        Context ctx = (Context)PolyglotNativeAPI.fetchHandle(context);
        if (length.equal(POLY_AUTO_LENGTH)) {
            result.write(PolyglotNativeAPI.createHandle(ctx.asValue((Object)CTypeConversion.utf8ToJavaString((CCharPointer)string_utf8))));
        } else {
            result.write(PolyglotNativeAPI.createHandle(ctx.asValue((Object)CTypeConversion.toJavaString((CCharPointer)string_utf8, (UnsignedWord)length, (Charset)UTF8_CHARSET))));
        }
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_create_null", exceptionHandler=ExceptionHandler.class, documentation={"Creates the polyglot `null` value.", "", "@return poly_ok if all works, poly_generic_failure if context is null, if the underlying context was closed.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Context.html#asValue-java.lang.Object-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_create_null(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotContext context, PolyglotNativeAPITypes.PolyglotValuePointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(context, "context");
        PolyglotNativeAPI.nullCheck(result, "result");
        Context ctx = (Context)PolyglotNativeAPI.fetchHandle(context);
        result.write(PolyglotNativeAPI.createHandle(ctx.asValue(null)));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_create_object", exceptionHandler=ExceptionHandler.class, documentation={"Creates a polyglot object with no members.", "", "@return poly_ok if all works, poly_generic_failure if context is null, if the underlying context was closed.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/proxy/ProxyObject.html#fromMap-java.util.Map-", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Context.html#asValue-java.lang.Object-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_create_object(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotContext context, PolyglotNativeAPITypes.PolyglotValuePointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(context, "context");
        PolyglotNativeAPI.nullCheck(result, "result");
        Context c = (Context)PolyglotNativeAPI.fetchHandle(context);
        ProxyObject proxy = ProxyObject.fromMap(new HashMap());
        result.write(PolyglotNativeAPI.createHandle(c.asValue((Object)proxy)));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_create_array", exceptionHandler=ExceptionHandler.class, documentation={"Creates a polyglot array from the C array of polyglot values.", "", "@param value_array array containing polyglot values", "@param array_length the number of elements in the value_array", "@return poly_ok if all works, poly_generic_failure if context is null, if the underlying context was closed, ", "         if the array does not contain polyglot values.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/proxy/ProxyArray.html#fromList-java.util.List-", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Context.html#asValue-java.lang.Object-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_create_array(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotContext context,  @CConst PolyglotNativeAPITypes.PolyglotValuePointer value_array, long array_length, PolyglotNativeAPITypes.PolyglotValuePointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(context, "context");
        if (array_length > 0L) {
            PolyglotNativeAPI.nullCheck(value_array, "value_array");
        }
        PolyglotNativeAPI.nullCheck(result, "result");
        Context ctx = (Context)PolyglotNativeAPI.fetchHandle(context);
        LinkedList values = new LinkedList();
        for (long i = 0L; i < array_length; ++i) {
            values.add(PolyglotNativeAPI.fetchHandle(value_array.read(i)));
        }
        result.write(PolyglotNativeAPI.createHandle(ctx.asValue((Object)ProxyArray.fromList(values))));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_value_has_array_elements", exceptionHandler=ExceptionHandler.class, documentation={"Check whether a polyglot value has array elements. ", "", "If yes, array elements can be accessed using {@link poly_value_get_array_element}, ", "{@link poly_value_set_array_element}, {@link poly_value_remove_array_element} and the array size ", "can be queried using {@link poly_value_get_array_size}.", "", "@param value value that we are checking.", "@return true if the value has array elements.", "@return poly_ok if all works, poly_generic_failure if the underlying context was closed, if guest language error occurred ", "        during execution.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Value.html#hasArrayElements--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_value_has_array_elements(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotValue value, CBoolPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(value, "value");
        PolyglotNativeAPI.nullCheck(result, "result");
        Value jValue = (Value)PolyglotNativeAPI.fetchHandle(value);
        result.write(CTypeConversion.toCBoolean((boolean)jValue.hasArrayElements()));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_value_get_array_element", exceptionHandler=ExceptionHandler.class, documentation={"Returns an array element from the specified index. ", "", "Polyglot arrays start with index `0`, independent of the guest language. The given array index must ", "be greater or equal 0.", "", "@param value value that has array elements.", "@param index index of the element starting from 0.", "@param result the returned array element.", "@return poly_ok if the operation completed successfully, otherwise an error occurred.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Value.html#getArrayElement-long-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_value_get_array_element(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotValue value, long index, PolyglotNativeAPITypes.PolyglotValuePointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(value, "value");
        PolyglotNativeAPI.nullCheck(result, "result");
        Value jValue = (Value)PolyglotNativeAPI.fetchHandle(value);
        result.write(PolyglotNativeAPI.createHandle(jValue.getArrayElement(index)));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_value_set_array_element", exceptionHandler=ExceptionHandler.class, documentation={"Sets the value at a given index.", "", "Polyglot arrays start with index `0`, independent of the guest language. The given array index must ", "be greater or equal 0.", "", "@param value value that we are checking.", "@param index index of the element starting from 0.", "@param element to be written into the array.", "@param result true if the value has array elements.", "@return poly_ok if the operation completed successfully, otherwise an error occurred.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Value.html#setArrayElement-long-java.lang.Object-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_value_set_array_element(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotValue value, long index, PolyglotNativeAPITypes.PolyglotValue element) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(value, "value");
        PolyglotNativeAPI.nullCheck(element, "element");
        Value jValue = (Value)PolyglotNativeAPI.fetchHandle(value);
        Value jElement = (Value)PolyglotNativeAPI.fetchHandle(element);
        jValue.setArrayElement(index, (Object)jElement);
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_value_remove_array_element", exceptionHandler=ExceptionHandler.class, documentation={"Removes an array element at a given index.", "", "Polyglot arrays start with index `0`, independent of the guest language. The given array index must ", "be greater or equal 0.", "", "@param value value that we are checking.", "@param index index of the element starting from 0.", "@param result true if the underlying array element could be removed, otherwise false.", "@return poly_ok if the operation completed successfully, otherwise an error occurred.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Value.html#removeArrayElement-long-", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_value_remove_array_element(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotValue value, long index, CBoolPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(value, "value");
        PolyglotNativeAPI.nullCheck(result, "result");
        Value jValue = (Value)PolyglotNativeAPI.fetchHandle(value);
        result.write(CTypeConversion.toCBoolean((boolean)jValue.removeArrayElement(index)));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_value_get_array_size", exceptionHandler=ExceptionHandler.class, documentation={"Gets the size of the polyglot value that has array elements.", "", "@param value value that has array elements.", "@param result number of elements in the value.", "@return poly_ok if the operation completed successfully, otherwise an error occurred.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Value.html#getArraySize--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_value_get_array_size(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotValue value, CInt64Pointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(value, "value");
        PolyglotNativeAPI.nullCheck(result, "result");
        Value jValue = (Value)PolyglotNativeAPI.fetchHandle(value);
        result.write(jValue.getArraySize());
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_value_is_null", exceptionHandler=ExceptionHandler.class, documentation={"Returns `true` if this value is `null` like.", "", "@return poly_ok if the operation completed successfully, otherwise an error occurred.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Value.html#isNull--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_value_is_null(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotValue value, CBoolPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(value, "value");
        PolyglotNativeAPI.nullCheck(result, "result");
        Value jValue = (Value)PolyglotNativeAPI.fetchHandle(value);
        result.write(CTypeConversion.toCBoolean((boolean)jValue.isNull()));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_value_is_boolean", exceptionHandler=ExceptionHandler.class, documentation={"Returns `true` if this value represents a boolean value.", "", "@return poly_ok if the operation completed successfully, otherwise an error occurred.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Value.html#isBoolean--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_value_is_boolean(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotValue value, CBoolPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(value, "value");
        PolyglotNativeAPI.nullCheck(result, "result");
        Value jValue = (Value)PolyglotNativeAPI.fetchHandle(value);
        result.write(CTypeConversion.toCBoolean((boolean)jValue.isBoolean()));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_value_is_string", exceptionHandler=ExceptionHandler.class, documentation={"Returns `true` if this value represents a string.", "", "@return poly_ok if all works, poly_generic_failure if the underlying context was closed, if guest language error occurred ", "        during execution.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Value.html#isString--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_value_is_string(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotValue value, CBoolPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(value, "value");
        PolyglotNativeAPI.nullCheck(result, "result");
        Value jValue = (Value)PolyglotNativeAPI.fetchHandle(value);
        result.write(CTypeConversion.toCBoolean((boolean)jValue.isString()));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_value_is_number", exceptionHandler=ExceptionHandler.class, documentation={"Returns `true` if this value represents a number.", "", "@return poly_ok if all works, poly_generic_failure if the underlying context was closed, if guest language error occurred ", "        during execution.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Value.html#isNumber--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_value_is_number(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotValue value, CBoolPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(value, "value");
        PolyglotNativeAPI.nullCheck(result, "result");
        Value jValue = (Value)PolyglotNativeAPI.fetchHandle(value);
        result.write(CTypeConversion.toCBoolean((boolean)jValue.isNumber()));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_value_fits_in_float", exceptionHandler=ExceptionHandler.class, documentation={"Returns `true` if this value is a number and can fit into a C float.", "", "@return poly_ok if all works, poly_generic_failure if the underlying context was closed, if guest language error occurred ", "        during execution.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Value.html#fitsInFloat--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_value_fits_in_float(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotValue value, CBoolPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(value, "value");
        PolyglotNativeAPI.nullCheck(result, "result");
        Value dataObject = (Value)PolyglotNativeAPI.fetchHandle(value);
        result.write(CTypeConversion.toCBoolean((boolean)dataObject.fitsInFloat()));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_value_fits_in_double", exceptionHandler=ExceptionHandler.class, documentation={"Returns `true` if this value is a number and can fit into a C double.", "", "@return poly_ok if all works, poly_generic_failure if the underlying context was closed, if guest language error occurred ", "        during execution.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Value.html#fitsInDouble--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_value_fits_in_double(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotValue value, CBoolPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(value, "value");
        PolyglotNativeAPI.nullCheck(result, "result");
        Value dataObject = (Value)PolyglotNativeAPI.fetchHandle(value);
        result.write(CTypeConversion.toCBoolean((boolean)dataObject.fitsInDouble()));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_value_fits_in_int8", exceptionHandler=ExceptionHandler.class, documentation={"Returns `true` if this value is a number and can fit into `int8_t`.", "", "@return poly_ok if all works, poly_generic_failure if the underlying context was closed, if guest language error occurred ", "        during execution.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Value.html#fitsInByte--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_value_fits_in_int8(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotValue value, CBoolPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(value, "value");
        PolyglotNativeAPI.nullCheck(result, "result");
        Value dataObject = (Value)PolyglotNativeAPI.fetchHandle(value);
        result.write(CTypeConversion.toCBoolean((boolean)dataObject.fitsInByte()));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_value_fits_in_int16", exceptionHandler=ExceptionHandler.class, documentation={"Returns `true` if this value is a number and can fit into `int16_t`.", "", "@return poly_ok if all works, poly_generic_failure if the underlying context was closed, if guest language error occurred ", "        during execution.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Value.html#fitsInInt--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_value_fits_in_int16(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotValue value, CBoolPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(value, "value");
        PolyglotNativeAPI.nullCheck(result, "result");
        Value jValue = (Value)PolyglotNativeAPI.fetchHandle(value);
        boolean jResult = jValue.fitsInInt();
        if (jResult) {
            int intValue = jValue.asInt();
            jResult = intValue >= Short.MIN_VALUE && intValue <= Short.MAX_VALUE;
        }
        result.write(CTypeConversion.toCBoolean((boolean)jResult));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_value_fits_in_int32", exceptionHandler=ExceptionHandler.class, documentation={"Returns `true` if this value is a number and can fit into `int32_t`.", "", "@return poly_ok if all works, poly_generic_failure if the underlying context was closed, if guest language error occurred ", "        during execution.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Value.html#fitsInInt--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_value_fits_in_int32(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotValue value, CBoolPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(value, "value");
        PolyglotNativeAPI.nullCheck(result, "result");
        Value dataObject = (Value)PolyglotNativeAPI.fetchHandle(value);
        result.write(CTypeConversion.toCBoolean((boolean)dataObject.fitsInInt()));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_value_fits_in_int64", exceptionHandler=ExceptionHandler.class, documentation={"Returns `true` if this value is a number and can fit into `int64_t`.", "", "@return poly_ok if all works, poly_generic_failure if the underlying context was closed, if guest language error occurred ", "        during execution.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Value.html#fitsInLong--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_value_fits_in_int64(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotValue value, CBoolPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(value, "value");
        PolyglotNativeAPI.nullCheck(result, "result");
        Value dataObject = (Value)PolyglotNativeAPI.fetchHandle(value);
        result.write(CTypeConversion.toCBoolean((boolean)dataObject.fitsInLong()));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_value_fits_in_uint8", exceptionHandler=ExceptionHandler.class, documentation={"Returns `true` if this value is a number and can fit into `uint8_t`.", "", "@return poly_ok if all works, poly_generic_failure if the underlying context was closed, if guest language error occurred ", "        during execution.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Value.html#fitsInInt--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_value_fits_in_uint8(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotValue value, CBoolPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(value, "value");
        PolyglotNativeAPI.nullCheck(result, "result");
        Value jValue = (Value)PolyglotNativeAPI.fetchHandle(value);
        boolean jResult = jValue.fitsInInt();
        if (jResult) {
            int intValue = jValue.asInt();
            jResult = intValue >= 0 && intValue <= 255;
        }
        result.write(CTypeConversion.toCBoolean((boolean)jResult));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_value_fits_in_uint16", exceptionHandler=ExceptionHandler.class, documentation={"Returns `true` if this value is a number and can fit into `uint16_t`.", "", "@return poly_ok if all works, poly_generic_failure if the underlying context was closed, if guest language error occurred ", "        during execution.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Value.html#fitsInInt--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_value_fits_in_uint16(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotValue value, CBoolPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(value, "value");
        PolyglotNativeAPI.nullCheck(result, "result");
        Value jValue = (Value)PolyglotNativeAPI.fetchHandle(value);
        boolean jResult = jValue.fitsInInt();
        if (jResult) {
            int intValue = jValue.asInt();
            jResult = intValue >= 0 && intValue <= 65535;
        }
        result.write(CTypeConversion.toCBoolean((boolean)jResult));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_value_fits_in_uint32", exceptionHandler=ExceptionHandler.class, documentation={"Returns `true` if this value is a number and can fit into `uint32_t`.", "", "@return poly_ok if all works, poly_generic_failure if the underlying context was closed, if guest language error occurred ", "        during execution.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Value.html#fitsInLong--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_value_fits_in_uint32(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotValue value, CBoolPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(value, "value");
        PolyglotNativeAPI.nullCheck(result, "result");
        Value jValue = (Value)PolyglotNativeAPI.fetchHandle(value);
        boolean jResult = jValue.fitsInLong();
        if (jResult) {
            long intValue = jValue.asLong();
            jResult = intValue >= 0L && intValue <= 0xFFFFFFFFL;
        }
        result.write(CTypeConversion.toCBoolean((boolean)jResult));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_value_as_string_utf8", exceptionHandler=ExceptionHandler.class, documentation={"Writes the Polyglot value's string representation as a 0 terminated and UTF-8 encoded string.", "", "@param buffer Where to write the UTF-8 string representing the polyglot value. Can be NULL.", "@param buffer_size Size of the user-supplied buffer.", "@param result If buffer is NULL, this will contain the byte size of the string, otherwise, it will contain the number of bytes written. Note in either case this length does not contain the 0 terminator written to the end of the buffer", "@return poly_ok if the operation completed successfully, otherwise an error occurred.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Value.html#asString--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_value_as_string_utf8(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotValue value, CCharPointer buffer, UnsignedWord buffer_size, PolyglotNativeAPITypes.SizeTPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(value, "value");
        PolyglotNativeAPI.nullCheck(result, "result");
        Value jValue = (Value)PolyglotNativeAPI.fetchHandle(value);
        PolyglotNativeAPI.writeUTF8String(jValue.asString(), buffer, buffer_size, result);
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_value_to_string_utf8", exceptionHandler=ExceptionHandler.class, documentation={"Writes a <code>toString</code> representation of a <code>poly_value</code> as a 0 terminated and UTF-8 encoded string.", "", "@param buffer Where to write the UTF-8 string representing the toString representation of the polyglot value. Can be NULL.", "@param buffer_size Size of the user-supplied buffer.", "@param result If buffer is NULL, this will contain the byte size of the string, otherwise, it will contain the number of bytes written. Note in either case this length does not contain the 0 terminator written to the end of the buffer", "@return poly_ok if everything went ok, otherwise an error occurred.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Value.html#toString--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_value_to_string_utf8(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotValue value, CCharPointer buffer, UnsignedWord buffer_size, PolyglotNativeAPITypes.SizeTPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(value, "value");
        PolyglotNativeAPI.nullCheck(result, "result");
        Value jValue = (Value)PolyglotNativeAPI.fetchHandle(value);
        PolyglotNativeAPI.writeUTF8String(jValue.toString(), buffer, buffer_size, result);
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_value_as_boolean", exceptionHandler=ExceptionHandler.class, documentation={"Returns a boolean representation of the value.", "", "@return poly_ok if the operation completed successfully, otherwise an error occurred.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Value.html#asBoolean--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_value_as_bool(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotValue value, CBoolPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(value, "value");
        PolyglotNativeAPI.nullCheck(result, "result");
        Value jValue = (Value)PolyglotNativeAPI.fetchHandle(value);
        result.write(CTypeConversion.toCBoolean((boolean)jValue.asBoolean()));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_value_as_int8", exceptionHandler=ExceptionHandler.class, documentation={"Returns a int8_t representation of the value.", "", "@return poly_ok if all works, poly_generic_failure if value is null, if a guest language error occurred during execution, ", "         if the underlying context was closed, if value could not be converted. ", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Value.html#asByte--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_value_as_int8(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotValue value, CInt8Pointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(value, "value");
        PolyglotNativeAPI.nullCheck(result, "result");
        Value valueObject = (Value)PolyglotNativeAPI.fetchHandle(value);
        result.write(valueObject.asByte());
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_value_as_int16", exceptionHandler=ExceptionHandler.class, documentation={"Returns a int32_t representation of the value.", "", "@return poly_ok if all works, poly_generic_failure if value is null, if a guest language error occurred during execution, ", "         if the underlying context was closed, if value could not be converted.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Value.html#asInt--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_value_as_int16(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotValue value, CInt16Pointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(value, "value");
        PolyglotNativeAPI.nullCheck(result, "result");
        Value valueObject = (Value)PolyglotNativeAPI.fetchHandle(value);
        int intValue = valueObject.asInt();
        if (intValue < Short.MIN_VALUE || intValue > Short.MAX_VALUE) {
            throw PolyglotNativeAPI.reportError("Value " + intValue + " does not fit into int_16_t.", PolyglotNativeAPITypes.PolyglotStatus.poly_generic_failure);
        }
        result.write((short)intValue);
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_value_as_int32", exceptionHandler=ExceptionHandler.class, documentation={"Returns a int32_t representation of the value.", "", "@return poly_ok if all works, poly_generic_failure if value is null, if a guest language error occurred during execution, ", "         if the underlying context was closed, if value could not be converted.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Value.html#asInt--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_value_as_int32(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotValue value, CInt32Pointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(value, "value");
        PolyglotNativeAPI.nullCheck(result, "result");
        Value valueObject = (Value)PolyglotNativeAPI.fetchHandle(value);
        result.write(valueObject.asInt());
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_value_as_int64", exceptionHandler=ExceptionHandler.class, documentation={"Returns a int64_t representation of the value.", "", "@return poly_ok if all works, poly_generic_failure if value is null, if a guest language error occurred during execution, ", "         if the underlying context was closed, if value could not be converted.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Value.html#asLong--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_value_as_int64(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotValue value, CInt64Pointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(value, "value");
        PolyglotNativeAPI.nullCheck(result, "result");
        Value valueObject = (Value)PolyglotNativeAPI.fetchHandle(value);
        result.write(valueObject.asLong());
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_value_as_uint8", exceptionHandler=ExceptionHandler.class, documentation={"Returns a uint8_t representation of the value.", "", "@return poly_ok if all works, poly_generic_failure if value is null, if a guest language error occurred during execution, ", "         if the underlying context was closed, if value could not be converted.", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Value.html#asInt--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_value_as_uint8(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotValue value, CUnsignedBytePointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(value, "value");
        PolyglotNativeAPI.nullCheck(result, "result");
        Value valueObject = (Value)PolyglotNativeAPI.fetchHandle(value);
        int intValue = valueObject.asInt();
        if (intValue < 0 || intValue > 255) {
            throw PolyglotNativeAPI.reportError("Value " + Integer.toUnsignedString(intValue) + "does not fit in uint8_t", PolyglotNativeAPITypes.PolyglotStatus.poly_generic_failure);
        }
        result.write((byte)intValue);
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_value_as_uint16", exceptionHandler=ExceptionHandler.class, documentation={"Returns a uint16_t representation of the value.", "", "@return poly_ok if all works, poly_generic_failure if value is null, if a guest language error occurred during execution, ", "         if the underlying context was closed, if value could not be converted.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Value.html#asInt--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_value_as_uint16(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotValue value, CUnsignedShortPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(value, "value");
        PolyglotNativeAPI.nullCheck(result, "result");
        Value valueObject = (Value)PolyglotNativeAPI.fetchHandle(value);
        int intValue = valueObject.asInt();
        if (intValue < 0 || intValue > 65535) {
            throw PolyglotNativeAPI.reportError("Value " + Integer.toUnsignedString(intValue) + "does not fit in uint16_t", PolyglotNativeAPITypes.PolyglotStatus.poly_generic_failure);
        }
        result.write((short)intValue);
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_value_as_uint32", exceptionHandler=ExceptionHandler.class, documentation={"Returns a uint32_t representation of the value.", "", "@return poly_ok if all works, poly_generic_failure if value is null, if a guest language error occurred during execution, ", "        if the underlying context was closed, if value could not be converted.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Value.html#asLong--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_value_as_uint32(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotValue value, CUnsignedIntPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(value, "value");
        PolyglotNativeAPI.nullCheck(result, "result");
        Value valueObject = (Value)PolyglotNativeAPI.fetchHandle(value);
        long longValue = valueObject.asLong();
        if (longValue < 0L || longValue > 0xFFFFFFFFL) {
            throw PolyglotNativeAPI.reportError("Value " + Long.toUnsignedString(longValue) + "does not fit in uint32_t", PolyglotNativeAPITypes.PolyglotStatus.poly_generic_failure);
        }
        result.write((int)longValue);
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_value_as_float", exceptionHandler=ExceptionHandler.class, documentation={"Returns a float representation of the value.", "", "@return poly_ok if all works, poly_generic_failure if value is null, if a guest language error occurred during execution, ", "        if the underlying context was closed, if value could not be converted.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Value.html#asFloat--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_value_as_float(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotValue value, CFloatPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(value, "value");
        PolyglotNativeAPI.nullCheck((PointerBase)result, "result");
        Value dataObject = (Value)PolyglotNativeAPI.fetchHandle(value);
        result.write(dataObject.asFloat());
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_value_as_double", exceptionHandler=ExceptionHandler.class, documentation={"Returns a double representation of the value.", "", "@return poly_ok if the operation completed successfully, otherwise an error occurred.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Value.html#asDouble--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_value_as_double(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotValue value, CDoublePointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(value, "value");
        PolyglotNativeAPI.nullCheck((PointerBase)result, "result");
        Value dataObject = (Value)PolyglotNativeAPI.fetchHandle(value);
        result.write(dataObject.asDouble());
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_language_get_id", exceptionHandler=ExceptionHandler.class, documentation={"Writes the primary identification string of this language as a 0 terminated and UTF-8 encoded string.", "", "The language id is used as the primary way of identifying languages in the polyglot API. (eg. <code>js</code>)", "", "@param buffer Where to write the UTF-8 string representing the language id. Can be NULL.", "@param buffer_size Size of the user-supplied buffer.", "@param result If buffer is NULL, this will contain the byte size of the language, otherwise, it will contain the number of bytes written. Note in either case this length does not contain the 0 terminator written to the end of the buffer", "@return poly_ok if everything went ok, otherwise an error occurred.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Language.html#getId--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_language_get_id(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotLanguage language, CCharPointer buffer, UnsignedWord buffer_size, PolyglotNativeAPITypes.SizeTPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(language, "language");
        PolyglotNativeAPI.nullCheck(result, "result");
        Language jLanguage = (Language)PolyglotNativeAPI.fetchHandle(language);
        PolyglotNativeAPI.writeUTF8String(jLanguage.getId(), buffer, buffer_size, result);
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_get_last_error_info", exceptionHandler=GenericFailureExceptionHandler.class, documentation={"Returns information about last error that occurred on this thread in the poly_extended_error_info structure.", "", "This method must be called right after a failure occurs and can be called only once.", "", "@return information about the last failure on this thread.", "", "@since 19.0"})
    @Uninterruptible(reason="Prevent safepoint checks before pausing recurring callback.")
    public static PolyglotNativeAPITypes.PolyglotStatus poly_get_last_error_info(PolyglotNativeAPITypes.PolyglotIsolateThread thread,  @CConst PolyglotNativeAPITypes.PolyglotExtendedErrorInfoPointer result) {
        ThreadingSupportImpl.pauseRecurringCallback((String)"Prevent recurring callback from throwing another exception.");
        try {
            PolyglotNativeAPITypes.PolyglotStatus polyglotStatus = PolyglotNativeAPI.doGetLastErrorInfo(result);
            return polyglotStatus;
        }
        finally {
            ThreadingSupportImpl.resumeRecurringCallbackAtNextSafepoint();
        }
    }

    @Uninterruptible(reason="Not really, but our caller is.", calleeMustBe=false)
    private static PolyglotNativeAPITypes.PolyglotStatus doGetLastErrorInfo(PolyglotNativeAPITypes.PolyglotExtendedErrorInfoPointer result) {
        return PolyglotNativeAPI.doGetLastErrorInfo0(result);
    }

    private static PolyglotNativeAPITypes.PolyglotStatus doGetLastErrorInfo0(PolyglotNativeAPITypes.PolyglotExtendedErrorInfoPointer result) {
        PolyglotNativeAPI.nullCheck(result, "result");
        ThreadLocalState state = (ThreadLocalState)threadLocals.get();
        if (state == null || state.lastException == null) {
            result.write((PolyglotNativeAPITypes.PolyglotExtendedErrorInfo)WordFactory.nullPointer());
            return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
        }
        assert (state.lastErrorCode != PolyglotNativeAPITypes.PolyglotStatus.poly_ok);
        PolyglotNativeAPI.freeUnmanagedErrorState(state);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println(state.lastException.getMessage());
        pw.println("The full stack trace is:");
        state.lastException.printStackTrace(pw);
        ByteBuffer message = UTF8_CHARSET.encode(sw.toString());
        int messageSize = message.capacity() + 1;
        CCharPointer messageChars = (CCharPointer)UnmanagedMemory.malloc((int)messageSize);
        ByteBuffer messageBuffer = CTypeConversion.asByteBuffer((PointerBase)messageChars, (int)messageSize);
        messageBuffer.put(message).put((byte)0);
        PolyglotNativeAPITypes.PolyglotExtendedErrorInfo info = (PolyglotNativeAPITypes.PolyglotExtendedErrorInfo)UnmanagedMemory.malloc((int)SizeOf.get(PolyglotNativeAPITypes.PolyglotExtendedErrorInfo.class));
        info.setErrorCode(state.lastErrorCode.getCValue());
        info.setErrorMessage(messageChars);
        state.lastExceptionUnmanagedInfo = info;
        result.write(state.lastExceptionUnmanagedInfo);
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_create_function", exceptionHandler=ExceptionHandler.class, documentation={"Creates a polyglot function that calls back into native code.", "", "@param data user defined data to be passed into the function.", "@param callback function that is called from the polyglot engine.", "@return poly_ok if all works, poly_generic_error if there is a failure.", "", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_create_function(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotContext context, PolyglotNativeAPITypes.PolyglotCallback callback, VoidPointer data, PolyglotNativeAPITypes.PolyglotValuePointer value) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(context, "context");
        PolyglotNativeAPI.nullCheck((PointerBase)callback, "callback");
        PolyglotNativeAPI.nullCheck(value, "value");
        Context c = (Context)PolyglotNativeAPI.fetchHandle(context);
        ProxyExecutable executable = arguments -> {
            int frame = PolyglotNativeAPI.getHandles().pushFrame(16);
            try {
                ObjectHandle[] handleArgs = new ObjectHandle[arguments.length];
                for (int i = 0; i < arguments.length; ++i) {
                    handleArgs[i] = PolyglotNativeAPI.createHandle(arguments[i]);
                }
                PolyglotNativeAPITypes.PolyglotCallbackInfo cbInfo = (PolyglotNativeAPITypes.PolyglotCallbackInfo)PolyglotNativeAPI.createHandle(new PolyglotCallbackInfoInternal(handleArgs, data));
                PolyglotNativeAPITypes.PolyglotValue result = callback.invoke((PolyglotNativeAPITypes.PolyglotIsolateThread)CurrentIsolate.getCurrentThread(), cbInfo);
                CallbackException ce = exceptionsTL.get();
                if (ce != null) {
                    exceptionsTL.remove();
                    throw ce;
                }
                Object t = PolyglotNativeAPI.fetchHandle(result);
                return t;
            }
            finally {
                PolyglotNativeAPI.getHandles().popFramesIncluding(frame);
            }
        };
        value.write(PolyglotNativeAPI.createHandle(c.asValue((Object)executable)));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_get_callback_info", exceptionHandler=ExceptionHandler.class, documentation={"Retrieves details about the call within a callback (e.g., the arguments from a given callback info).", "", "@param callback_info from the callback.", "@param argc number of arguments to the callback.", "@param argv poly_value array of arguments for the callback.", "@param the data pointer for the callback.", "", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_get_callback_info(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotCallbackInfo callback_info, PolyglotNativeAPITypes.SizeTPointer argc, PolyglotNativeAPITypes.PolyglotValuePointer argv, WordPointer data) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(callback_info, "callback_info");
        PolyglotNativeAPI.nullCheck(argc, "argc");
        PolyglotNativeAPI.nullCheck((PointerBase)data, "data");
        PolyglotCallbackInfoInternal callbackInfo = (PolyglotCallbackInfoInternal)PolyglotNativeAPI.fetchHandle(callback_info);
        UnsignedWord numberOfArguments = WordFactory.unsigned((int)callbackInfo.arguments.length);
        UnsignedWord bufferSize = argc.read();
        UnsignedWord size = bufferSize.belowThan(numberOfArguments) ? bufferSize : numberOfArguments;
        argc.write(size);
        if (size.aboveThan(0)) {
            PolyglotNativeAPI.nullCheck(argv, "argv");
        }
        int index = 0;
        while (size.aboveThan(index)) {
            ObjectHandle argument = callbackInfo.arguments[index];
            argv.write(index, argument);
            ++index;
        }
        data.write((WordBase)callbackInfo.data);
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_throw_exception", exceptionHandler=ExceptionHandler.class, documentation={"Raises an exception in a C callback.", "", "Invocation of this method does not interrupt control-flow so it is necessary to return from a function after ", "the exception has been raised. If this method is called multiple times only the last exception will be thrown in", "in the guest language.", "", "@param message_utf8 0 terminated and UTF-8 encoded error message.", "", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_throw_exception(PolyglotNativeAPITypes.PolyglotIsolateThread thread, @CConst CCharPointer message_utf8) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck((PointerBase)message_utf8, "message_utf8");
        exceptionsTL.set(new CallbackException(CTypeConversion.utf8ToJavaString((CCharPointer)message_utf8)));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_delete_reference", exceptionHandler=ExceptionHandler.class, documentation={"Deletes a poly_reference. After this point, the reference must not be used anymore.", "", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_delete_reference(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotReference reference) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(reference, "reference");
        objectHandles.destroy((ObjectHandle)reference);
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_create_reference", exceptionHandler=ExceptionHandler.class, documentation={"Creates a poly_reference from a poly_handle. After this point, the reference is alive until poly_delete_reference is called. ", "", "Handles are: poly_engine, poly_engine_builder, poly_context, poly_context_builder, poly_language, poly_value, ", "and poly_callback_info.", "", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_create_reference(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotHandle handle, PolyglotNativeAPITypes.PolyglotReferencePointer reference) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(handle, "handle");
        PolyglotNativeAPI.nullCheck(reference, "reference");
        ObjectHandle ref = objectHandles.create(PolyglotNativeAPI.getHandles().getObject((ObjectHandle)handle));
        reference.write((PolyglotNativeAPITypes.PolyglotReference)ref);
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_open_handle_scope", exceptionHandler=ExceptionHandler.class, documentation={"Opens a handle scope. Until the scope is closed, all objects will belong to the newly created scope.", "", "Handles are: poly_engine, poly_engine_builder, poly_context, poly_context_builder, poly_language, poly_value, ", "and poly_callback_info.", "", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_open_handle_scope(PolyglotNativeAPITypes.PolyglotIsolateThread thread) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.getHandles().pushFrame(16);
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_close_handle_scope", exceptionHandler=ExceptionHandler.class, documentation={"Closes a handle scope. After this point, the handles from the current scope must not be used anymore.", "", "Handles are: poly_engine, poly_engine_builder, poly_context, poly_context_builder, poly_language, poly_value, ", "and poly_callback_info.", "", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_close_handle_scope(PolyglotNativeAPITypes.PolyglotIsolateThread thread) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.getHandles().popFrame();
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_get_last_exception", exceptionHandler=GenericFailureExceptionHandler.class, documentation={"Returns the last exception that occurred on this thread, or does nothing if an exception did not happen.", "", "This method must be called right after an exception occurs (after a method returns poly_pending_exception), ", "and can be called only once.", "", "@param result On success, a handle to the last exception on this thread is put here.", "@return poly_ok if everything went ok, otherwise an error occurred.", "", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_get_last_exception(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotExceptionHandlePointer result) {
        ThreadLocalState state = (ThreadLocalState)threadLocals.get();
        PolyglotNativeAPI.nullCheck(result, "result");
        if (state == null || state.polyglotException == null) {
            result.write((ObjectHandle)ThreadLocalHandles.nullHandle());
        } else {
            result.write(PolyglotNativeAPI.createHandle(state.polyglotException));
            state.polyglotException = null;
        }
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_exception_is_syntax_error", exceptionHandler=ExceptionHandler.class, documentation={"Checks if an exception is caused by a parser or syntax error.", "", "@param exception Handle to the exception object.", "@param result The result of the check.", "@return poly_ok if everything went ok, otherwise an error occurred.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/PolyglotException.html#isSyntaxError--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_exception_is_syntax_error(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotExceptionHandle exception, CBoolPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(exception, "exception");
        PolyglotNativeAPI.nullCheck(result, "result");
        PolyglotException e = (PolyglotException)PolyglotNativeAPI.fetchHandle(exception);
        result.write(CTypeConversion.toCBoolean((boolean)e.isSyntaxError()));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_exception_is_cancelled", exceptionHandler=ExceptionHandler.class, documentation={"Checks if execution has been cancelled.", "", "@param exception Handle to the exception object.", "@param result The result of the check.", "@return poly_ok if everything went ok, otherwise an error occurred.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/PolyglotException.html#isCancelled--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_exception_is_cancelled(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotExceptionHandle exception, CBoolPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(exception, "exception");
        PolyglotNativeAPI.nullCheck(result, "result");
        PolyglotException e = (PolyglotException)PolyglotNativeAPI.fetchHandle(exception);
        result.write(CTypeConversion.toCBoolean((boolean)e.isCancelled()));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_exception_is_internal_error", exceptionHandler=ExceptionHandler.class, documentation={"Checks if this exception was caused by an internal implementation error.", "", "@param exception Handle to the exception object.", "@param result The result of the check.", "@return poly_ok if everything went ok, otherwise an error occurred.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/PolyglotException.html#isInternalError--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_exception_is_internal_error(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotExceptionHandle exception, CBoolPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(exception, "exception");
        PolyglotNativeAPI.nullCheck(result, "result");
        PolyglotException e = (PolyglotException)PolyglotNativeAPI.fetchHandle(exception);
        result.write(CTypeConversion.toCBoolean((boolean)e.isInternalError()));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_exception_is_resource_exhausted", exceptionHandler=ExceptionHandler.class, documentation={"Checks if this exception indicates that a resource limit was exceeded.", "", "@param exception Handle to the exception object.", "@param result The result of the check.", "@return poly_ok if everything went ok, otherwise an error occurred.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/PolyglotException.html#isResourceExhausted--", "@since 23.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_exception_is_resource_exhausted(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotExceptionHandle exception, CBoolPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(exception, "exception");
        PolyglotNativeAPI.nullCheck(result, "result");
        PolyglotException e = (PolyglotException)PolyglotNativeAPI.fetchHandle(exception);
        result.write(CTypeConversion.toCBoolean((boolean)e.isResourceExhausted()));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_exception_is_host_exception", exceptionHandler=ExceptionHandler.class, documentation={"Checks if this exception originates from the Java host language.", "", "@param exception Handle to the exception object.", "@param result The result of the check.", "@return poly_ok if everything went ok, otherwise an error occurred.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/PolyglotException.html#isHostException--", "@since 23.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_exception_is_host_exception(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotExceptionHandle exception, CBoolPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(exception, "exception");
        PolyglotNativeAPI.nullCheck(result, "result");
        PolyglotException e = (PolyglotException)PolyglotNativeAPI.fetchHandle(exception);
        result.write(CTypeConversion.toCBoolean((boolean)e.isHostException()));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_exception_is_guest_exception", exceptionHandler=ExceptionHandler.class, documentation={"Checks if this exception originates from a Graal guest language.", "", "@param exception Handle to the exception object.", "@param result The result of the check.", "@return poly_ok if everything went ok, otherwise an error occurred.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/PolyglotException.html#isGuestException--", "@since 23.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_exception_is_guest_exception(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotExceptionHandle exception, CBoolPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(exception, "exception");
        PolyglotNativeAPI.nullCheck(result, "result");
        PolyglotException e = (PolyglotException)PolyglotNativeAPI.fetchHandle(exception);
        result.write(CTypeConversion.toCBoolean((boolean)e.isGuestException()));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_exception_has_object", exceptionHandler=ExceptionHandler.class, documentation={"Checks if this exception has a guest language exception object attached to it.", "", "@param exception Handle to the exception object.", "@param result The result of the check.", "@return poly_ok if everything went ok, otherwise an error occurred.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/PolyglotException.html#getGuestObject--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_exception_has_object(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotExceptionHandle exception, CBoolPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(exception, "exception");
        PolyglotNativeAPI.nullCheck(result, "result");
        PolyglotException e = (PolyglotException)PolyglotNativeAPI.fetchHandle(exception);
        result.write(CTypeConversion.toCBoolean((e.getGuestObject() != null ? 1 : 0) != 0));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_exception_get_object", exceptionHandler=ExceptionHandler.class, documentation={"Gets the handle to the guest exception object. This object can then be used in other poly methods.", "", "@param exception Handle to the exception object.", "@param result The handle to the guest object if it exists.", "@return poly_ok if everything went ok, otherwise an error occurred.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/PolyglotException.html#getGuestObject--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_exception_get_object(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotExceptionHandle exception, PolyglotNativeAPITypes.PolyglotValuePointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(exception, "exception");
        PolyglotNativeAPI.nullCheck(result, "result");
        PolyglotException e = (PolyglotException)PolyglotNativeAPI.fetchHandle(exception);
        Value guestObject = e.getGuestObject();
        if (guestObject == null) {
            PolyglotNativeAPI.reportError("Attempted to get the guest object of an exception that did not have one.", PolyglotNativeAPITypes.PolyglotStatus.poly_generic_failure);
        } else {
            result.write(PolyglotNativeAPI.createHandle(guestObject));
        }
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_exception_get_stack_trace", exceptionHandler=ExceptionHandler.class, documentation={"Writes the full stack trace as a 0 terminated and UTF-8 encoded string.", "", "@param exception Handle to the exception object.", "@param buffer Where to write the UTF-8 string representing the stack trace. Can be NULL.", "@param buffer_size Size of the user-supplied buffer.", "@param result If buffer is NULL, this will contain the byte size of the trace string, otherwise, it will contain the number of bytes written. Note in either case this length does not contain the 0 terminator written to the end of the buffer", "@return poly_ok if everything went ok, otherwise an error occurred.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/PolyglotException.html#getStackTrace--", "@since 19.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_exception_get_stack_trace(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotExceptionHandle exception, CCharPointer buffer, UnsignedWord buffer_size, PolyglotNativeAPITypes.SizeTPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(exception, "exception");
        PolyglotNativeAPI.nullCheck(result, "result");
        PolyglotException e = (PolyglotException)PolyglotNativeAPI.fetchHandle(exception);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.getPolyglotStackTrace().forEach(trace -> pw.println(trace));
        PolyglotNativeAPI.writeUTF8String(sw.toString(), buffer, buffer_size, result);
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_exception_get_guest_stack_trace", exceptionHandler=ExceptionHandler.class, documentation={"Writes the guest stack trace as a 0 terminated and UTF-8 encoded string.", "", "@param exception Handle to the exception object.", "@param buffer Where to write the UTF-8 string representing the stack trace. Can be NULL.", "@param buffer_size Size of the user-supplied buffer.", "@param result If buffer is NULL, this will contain the byte size of the trace, otherwise, it will contain the number of bytes written. Note in either case this length does not contain the 0 terminator written to the end of the buffer", "@return poly_ok if everything went ok, otherwise an error occurred.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/PolyglotException.html#getPolyglotStackTrace--", "@since 22.3"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_exception_get_guest_stack_trace(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotExceptionHandle exception, CCharPointer buffer, UnsignedWord buffer_size, PolyglotNativeAPITypes.SizeTPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(exception, "exception");
        PolyglotNativeAPI.nullCheck(result, "result");
        PolyglotException e = (PolyglotException)PolyglotNativeAPI.fetchHandle(exception);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Iterable traceElements = e.getPolyglotStackTrace();
        for (PolyglotException.StackFrame trace : traceElements) {
            if (!trace.isGuestFrame()) continue;
            pw.println(trace);
        }
        PolyglotNativeAPI.writeUTF8String(sw.toString(), buffer, buffer_size, result);
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_exception_get_message", exceptionHandler=ExceptionHandler.class, documentation={"Gets the error message as a 0 terminated and UTF-8 encoded string.", "", "@param exception Handle to the exception object.", "@param buffer Where to write the UTF-8 string representing the error message. Can be NULL.", "@param buffer_size Size of the user-supplied buffer.", "@param result If buffer is NULL, this will contain the byte size of the error message string, otherwise, it will contain the number of bytes written. Note in either case this length does not contain the 0 terminator written to the end of the buffer", "@return poly_ok if everything went ok, otherwise an error occurred.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/PolyglotException.html#getMessage--", "@since 22.3"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_exception_get_message(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotExceptionHandle exception, CCharPointer buffer, UnsignedWord buffer_size, PolyglotNativeAPITypes.SizeTPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(exception, "exception");
        PolyglotNativeAPI.nullCheck(result, "result");
        PolyglotException e = (PolyglotException)PolyglotNativeAPI.fetchHandle(exception);
        PolyglotNativeAPI.writeUTF8String(e.getMessage(), buffer, buffer_size, result);
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CEntryPoint(name="poly_register_recurring_callback", exceptionHandler=ExceptionHandler.class, documentation={"Registers (or unregisters) a recurring callback in the current thread to be", "called approximately at the specified interval. The callback's result value is", "ignored. Any previously registered callback is replaced. Passing NULL for the", "the callback function removes a previously registered callback (in which case", "the interval and data parameters are ignored).", "", "@param intervalNanos interval between invocations in nanoseconds.", "@param callback the function that is invoked.", "@param data a custom pointer to be passed to each invocation of the callback.", "@return poly_ok if all works, poly_generic_error if there is a failure.", "", "@since 22.2"})
    @Uninterruptible(reason="Prevent safepoint checks before pausing recurring callback.")
    public static PolyglotNativeAPITypes.PolyglotStatus poly_register_recurring_callback(PolyglotNativeAPITypes.PolyglotIsolateThread thread, long intervalNanos, PolyglotNativeAPITypes.PolyglotCallback callback, VoidPointer data) {
        ThreadingSupportImpl.pauseRecurringCallback((String)"Prevent recurring callback execution before returning.");
        try {
            PolyglotNativeAPITypes.PolyglotStatus polyglotStatus = PolyglotNativeAPI.doRegisterRecurringCallback(intervalNanos, callback, data);
            return polyglotStatus;
        }
        finally {
            ThreadingSupportImpl.resumeRecurringCallbackAtNextSafepoint();
        }
    }

    @Uninterruptible(reason="Not really, but our caller is.", calleeMustBe=false)
    private static PolyglotNativeAPITypes.PolyglotStatus doRegisterRecurringCallback(long intervalNanos, PolyglotNativeAPITypes.PolyglotCallback callback, VoidPointer data) {
        return PolyglotNativeAPI.doRegisterRecurringCallback0(intervalNanos, callback, data);
    }

    private static PolyglotNativeAPITypes.PolyglotStatus doRegisterRecurringCallback0(long intervalNanos, PolyglotNativeAPITypes.PolyglotCallback callback, VoidPointer data) {
        PolyglotNativeAPI.resetErrorState();
        if (!ThreadingSupportImpl.isRecurringCallbackSupported()) {
            return PolyglotNativeAPITypes.PolyglotStatus.poly_generic_failure;
        }
        if (callback.isNull()) {
            Threading.registerRecurringCallback((long)-1L, null, null);
            return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
        }
        PolyglotCallbackInfoInternal info = new PolyglotCallbackInfoInternal(new ObjectHandle[0], data);
        Threading.registerRecurringCallback((long)intervalNanos, (TimeUnit)TimeUnit.NANOSECONDS, access -> {
            int frame = PolyglotNativeAPI.getHandles().pushFrame(16);
            try {
                PolyglotNativeAPITypes.PolyglotCallbackInfo infoHandle = (PolyglotNativeAPITypes.PolyglotCallbackInfo)PolyglotNativeAPI.createHandle(info);
                callback.invoke((PolyglotNativeAPITypes.PolyglotIsolateThread)CurrentIsolate.getCurrentThread(), infoHandle);
                CallbackException ce = exceptionsTL.get();
                if (ce != null) {
                    exceptionsTL.remove();
                    access.throwException((Throwable)ce);
                }
            }
            finally {
                PolyglotNativeAPI.getHandles().popFramesIncluding(frame);
            }
        });
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_perf_data_get_address_of_int64_t", exceptionHandler=ExceptionHandler.class, documentation={"Gets the address of the int64_t value for a performance data entry of type long. Performance data support must be enabled.", "", "@param key_utf8 0 terminated and UTF-8 encoded key that identifies the performance data entry.", "@param result a pointer to which the address of the int64_t value will be written.", "@return poly_ok if everything went ok, otherwise an error occurred.", "", "@since 22.3"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_perf_data_get_address_of_int64_t(PolyglotNativeAPITypes.PolyglotIsolateThread thread, CCharPointer key_utf8, CInt64PointerPointer result) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck((PointerBase)key_utf8, "key_utf8");
        PolyglotNativeAPI.nullCheck(result, "result");
        String key = CTypeConversion.utf8ToJavaString((CCharPointer)key_utf8);
        if (!((PerfDataSupport)ImageSingletons.lookup(PerfDataSupport.class)).hasLong(key)) {
            throw PolyglotNativeAPI.reportError("Key " + key + " is not a valid performance data entry key.", PolyglotNativeAPITypes.PolyglotStatus.poly_generic_failure);
        }
        CInt64Pointer ptr = (CInt64Pointer)((PerfDataSupport)ImageSingletons.lookup(PerfDataSupport.class)).getLong(key);
        result.write(ptr);
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    private static void writeUTF8String(String valueString, CCharPointer buffer, UnsignedWord length, PolyglotNativeAPITypes.SizeTPointer result) {
        result.write(CTypeConversion.toCString((CharSequence)valueString, (Charset)UTF8_CHARSET, (CCharPointer)buffer, (UnsignedWord)length));
    }

    private static List<Language> sortedLangs(Engine engine) {
        return engine.getLanguages().entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    private static void resetErrorState() {
        ThreadLocalState state = PolyglotNativeAPI.ensureLocalsInitialized();
        PolyglotNativeAPI.resetErrorStateAtomically(state);
    }

    @Uninterruptible(reason="An exception thrown by recurring callback can cause inconsistency, leaks or stale pointers.")
    private static void resetErrorStateAtomically(ThreadLocalState state) {
        state.lastErrorCode = PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
        state.lastException = null;
        PolyglotNativeAPI.freeUnmanagedErrorState(state);
    }

    @Uninterruptible(reason="An exception thrown by recurring callback can cause inconsistency, leaks or stale pointers.")
    private static void freeUnmanagedErrorState(ThreadLocalState state) {
        if (state.lastExceptionUnmanagedInfo.isNonNull()) {
            assert (state.lastExceptionUnmanagedInfo.getErrorMessage().isNonNull());
            ((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).free((PointerBase)state.lastExceptionUnmanagedInfo.getErrorMessage());
            ((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).free((PointerBase)state.lastExceptionUnmanagedInfo);
            state.lastExceptionUnmanagedInfo = (PolyglotNativeAPITypes.PolyglotExtendedErrorInfo)WordFactory.nullPointer();
        }
    }

    private static RuntimeException reportError(String message, PolyglotNativeAPITypes.PolyglotStatus errorCode) {
        throw new PolyglotNativeAPIError(errorCode, message);
    }

    private static PolyglotNativeAPITypes.PolyglotHandle createHandle(Object result) {
        return (PolyglotNativeAPITypes.PolyglotHandle)PolyglotNativeAPI.getHandles().create(result);
    }

    private static <T> T fetchHandle(PolyglotNativeAPITypes.PolyglotHandle object) {
        if (object.equal((ComparableWord)ThreadLocalHandles.nullHandle())) {
            return null;
        }
        if (ThreadLocalHandles.isInRange((ObjectHandle)object)) {
            return (T)PolyglotNativeAPI.getHandles().getObject((ObjectHandle)object);
        }
        if (objectHandles.isInRange((ObjectHandle)object)) {
            return (T)objectHandles.get((ObjectHandle)object);
        }
        throw new RuntimeException("Invalid poly_reference or poly_handle.");
    }

    @CEntryPoint(name="poly_context_builder_timezone", exceptionHandler=ExceptionHandler.class, documentation={"Sets timezone for a <code>poly_context_builder</code>.", "", "@param context_builder that is modified.", "@param zone_utf8 id of a timezone to be set via ZoneId.of().", "@return poly_ok if all works, poly_generic_error if there is a failure.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/polyglot/Context.Builder.html#timeZone-java.time.ZoneId-", "@since 23.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_context_builder_timezone(PolyglotNativeAPITypes.PolyglotIsolateThread thread, PolyglotNativeAPITypes.PolyglotContextBuilder context_builder, @CConst CCharPointer zone_utf8) {
        PolyglotNativeAPI.resetErrorState();
        PolyglotNativeAPI.nullCheck(context_builder, "context_builder");
        PolyglotNativeAPI.nullCheck((PointerBase)zone_utf8, "zone_utf8");
        String zoneString = CTypeConversion.utf8ToJavaString((CCharPointer)zone_utf8);
        Context.Builder contextBuilder = (Context.Builder)PolyglotNativeAPI.fetchHandle(context_builder);
        contextBuilder.timeZone(ZoneId.of(zoneString));
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_vmruntime_initialize", exceptionHandler=ExceptionHandler.class, documentation={"Initializes the VM: Runs all startup hooks that were registered during image building.", "", "@return poly_ok if all works, poly_generic_error if there is a failure.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/nativeimage/VMRuntime.html#initialize--", "@since 23.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_vmruntime_initialize(PolyglotNativeAPITypes.PolyglotIsolateThread thread) {
        PolyglotNativeAPI.resetErrorState();
        VMRuntime.initialize();
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    @CEntryPoint(name="poly_vmruntime_shutdown", exceptionHandler=ExceptionHandler.class, documentation={"Shuts down the VM: Runs all shutdown hooks and waits for all finalization to complete.", "", "@return poly_ok if all works, poly_generic_error if there is a failure.", "", "@see https://www.graalvm.org/sdk/javadoc/org/graalvm/nativeimage/VMRuntime.html#shutdown--", "@since 23.0"})
    public static PolyglotNativeAPITypes.PolyglotStatus poly_vmruntime_shutdown(PolyglotNativeAPITypes.PolyglotIsolateThread thread) {
        PolyglotNativeAPI.resetErrorState();
        VMRuntime.shutdown();
        return PolyglotNativeAPITypes.PolyglotStatus.poly_ok;
    }

    private static final class ThreadLocalState {
        ThreadLocalHandles<PolyglotNativeAPITypes.PolyglotHandle> handles;
        Throwable lastException;
        PolyglotNativeAPITypes.PolyglotExtendedErrorInfo lastExceptionUnmanagedInfo;
        PolyglotException polyglotException;
        PolyglotNativeAPITypes.PolyglotStatus lastErrorCode = PolyglotNativeAPITypes.PolyglotStatus.poly_ok;

        private ThreadLocalState() {
        }
    }

    private static class PolyglotCallbackInfoInternal {
        ObjectHandle[] arguments;
        VoidPointer data;

        PolyglotCallbackInfoInternal(ObjectHandle[] arguments, VoidPointer data) {
            this.arguments = arguments;
            this.data = data;
        }
    }

    public static class CallbackException
    extends RuntimeException {
        static final long serialVersionUID = 123123098097526L;

        CallbackException(String message) {
            super(message);
        }
    }

    private static final class GenericFailureExceptionHandler
    implements CEntryPoint.ExceptionHandler {
        private GenericFailureExceptionHandler() {
        }

        @Uninterruptible(reason="exception handler")
        static PolyglotNativeAPITypes.PolyglotStatus handle(Throwable t) {
            return PolyglotNativeAPITypes.PolyglotStatus.poly_generic_failure;
        }
    }

    private static final class ExceptionHandler
    implements CEntryPoint.ExceptionHandler {
        private ExceptionHandler() {
        }

        @Uninterruptible(reason="exception handler")
        static PolyglotNativeAPITypes.PolyglotStatus handle(Throwable t) {
            PolyglotNativeAPITypes.PolyglotStatus errorCode;
            ThreadLocalState state = (ThreadLocalState)threadLocals.get();
            if (state == null) {
                return PolyglotNativeAPITypes.PolyglotStatus.poly_generic_failure;
            }
            PolyglotNativeAPITypes.PolyglotStatus polyglotStatus = errorCode = t instanceof PolyglotNativeAPIError ? ((PolyglotNativeAPIError)t).getCode() : PolyglotNativeAPITypes.PolyglotStatus.poly_generic_failure;
            if (t instanceof PolyglotException) {
                state.polyglotException = (PolyglotException)t;
                errorCode = PolyglotNativeAPITypes.PolyglotStatus.poly_pending_exception;
            }
            state.lastException = t;
            state.lastErrorCode = errorCode;
            return errorCode;
        }
    }
}

