/*
 * Decompiled with CFR 0.152.
 */
package org.redline_rpm.changelog;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.redline_rpm.changelog.ChangelogEntry;
import org.redline_rpm.changelog.ChangelogParseException;
import org.redline_rpm.changelog.DatesOutOfSequenceException;
import org.redline_rpm.changelog.IncompleteChangelogEntryException;
import org.redline_rpm.changelog.InvalidChangelogDateException;
import org.redline_rpm.changelog.NoInitialAsteriskException;
import org.redline_rpm.changelog.ParsingState;

class ChangelogParser {
    static final SimpleDateFormat fmt = new SimpleDateFormat("EEE MMM dd yyyy", Locale.ENGLISH);

    ChangelogParser() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ChangelogEntry> parse(String[] lines) throws ChangelogParseException {
        fmt.setLenient(false);
        int TIME_LEN = 15;
        LinkedList<ChangelogEntry> result = new LinkedList<ChangelogEntry>();
        if (lines.length == 0) {
            return result;
        }
        ParsingState state = ParsingState.NEW;
        Date lastTime = null;
        ChangelogEntry entry = new ChangelogEntry();
        String restOfLine = null;
        StringBuilder descr = new StringBuilder();
        int index = 0;
        String line = lines[index];
        block8: while (true) {
            switch (state) {
                case NEW: {
                    if (line.startsWith("#")) {
                        if (++index >= lines.length) return result;
                        line = lines[index];
                        continue block8;
                    }
                    if (!line.startsWith("*")) {
                        throw new NoInitialAsteriskException();
                    }
                    restOfLine = line.substring(1).trim();
                    state = ParsingState.TIME;
                    break;
                }
                case TIME: {
                    if (restOfLine.length() < 15) {
                        throw new InvalidChangelogDateException(restOfLine);
                    }
                    String timestr = restOfLine.substring(0, 15);
                    try {
                        Date entryTime = fmt.parse(timestr);
                        if (lastTime != null && lastTime.before(entryTime)) {
                            throw new DatesOutOfSequenceException();
                        }
                        entry.setChangeLogTime(entryTime);
                        lastTime = entryTime;
                    }
                    catch (ParseException e) {
                        throw new InvalidChangelogDateException(e.getMessage());
                    }
                    state = ParsingState.NAME;
                    break;
                }
                case NAME: {
                    String name = restOfLine.substring(15).trim();
                    if (name.length() > 0) {
                        entry.setUserMakingChange(name);
                    }
                    state = ParsingState.TEXT;
                    break;
                }
                case TEXT: {
                    if (++index >= lines.length) break block8;
                    line = lines[index];
                    if (line.startsWith("#")) continue block8;
                    if (line.startsWith("*")) {
                        if (descr.length() > 1) {
                            entry.setDescription(descr.toString().substring(0, descr.length() - 1));
                        }
                        if (!entry.isComplete()) throw new IncompleteChangelogEntryException();
                        result.add(entry);
                        entry = new ChangelogEntry();
                        descr = new StringBuilder();
                        state = ParsingState.NEW;
                        break;
                    }
                    descr.append(line).append('\n');
                }
            }
        }
        if (descr.length() > 1) {
            entry.setDescription(descr.toString().substring(0, descr.length() - 1));
        }
        if (entry.isComplete()) {
            result.add(entry);
            return result;
        }
        if (lines.length <= 0) return result;
        throw new IncompleteChangelogEntryException();
    }

    public List<ChangelogEntry> parse(InputStream stream) throws IOException, ChangelogParseException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String line = null;
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#")) continue;
            lines.add(line);
        }
        return this.parse(lines.toArray(new String[0]));
    }
}

