/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.Source;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;

public class Scope
extends JSONBase {
    Scope(JSONObject jsonData) {
        super(jsonData);
    }

    public String getName() {
        return this.jsonData.getString("name");
    }

    public Scope setName(String name) {
        this.jsonData.put("name", name);
        return this;
    }

    public String getPresentationHint() {
        return this.jsonData.optString("presentationHint", null);
    }

    public Scope setPresentationHint(String presentationHint) {
        this.jsonData.putOpt("presentationHint", presentationHint);
        return this;
    }

    public int getVariablesReference() {
        return this.jsonData.getInt("variablesReference");
    }

    public Scope setVariablesReference(int variablesReference) {
        this.jsonData.put("variablesReference", variablesReference);
        return this;
    }

    public Integer getNamedVariables() {
        return this.jsonData.has("namedVariables") ? Integer.valueOf(this.jsonData.getInt("namedVariables")) : null;
    }

    public Scope setNamedVariables(Integer namedVariables) {
        this.jsonData.putOpt("namedVariables", namedVariables);
        return this;
    }

    public Integer getIndexedVariables() {
        return this.jsonData.has("indexedVariables") ? Integer.valueOf(this.jsonData.getInt("indexedVariables")) : null;
    }

    public Scope setIndexedVariables(Integer indexedVariables) {
        this.jsonData.putOpt("indexedVariables", indexedVariables);
        return this;
    }

    public boolean isExpensive() {
        return this.jsonData.getBoolean("expensive");
    }

    public Scope setExpensive(boolean expensive) {
        this.jsonData.put("expensive", expensive);
        return this;
    }

    public Source getSource() {
        return this.jsonData.has("source") ? new Source(this.jsonData.optJSONObject("source")) : null;
    }

    public Scope setSource(Source source) {
        this.jsonData.putOpt("source", source != null ? source.jsonData : null);
        return this;
    }

    public Integer getLine() {
        return this.jsonData.has("line") ? Integer.valueOf(this.jsonData.getInt("line")) : null;
    }

    public Scope setLine(Integer line) {
        this.jsonData.putOpt("line", line);
        return this;
    }

    public Integer getColumn() {
        return this.jsonData.has("column") ? Integer.valueOf(this.jsonData.getInt("column")) : null;
    }

    public Scope setColumn(Integer column) {
        this.jsonData.putOpt("column", column);
        return this;
    }

    public Integer getEndLine() {
        return this.jsonData.has("endLine") ? Integer.valueOf(this.jsonData.getInt("endLine")) : null;
    }

    public Scope setEndLine(Integer endLine) {
        this.jsonData.putOpt("endLine", endLine);
        return this;
    }

    public Integer getEndColumn() {
        return this.jsonData.has("endColumn") ? Integer.valueOf(this.jsonData.getInt("endColumn")) : null;
    }

    public Scope setEndColumn(Integer endColumn) {
        this.jsonData.putOpt("endColumn", endColumn);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Scope other = (Scope)obj;
        if (!Objects.equals(this.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals(this.getPresentationHint(), other.getPresentationHint())) {
            return false;
        }
        if (this.getVariablesReference() != other.getVariablesReference()) {
            return false;
        }
        if (!Objects.equals(this.getNamedVariables(), other.getNamedVariables())) {
            return false;
        }
        if (!Objects.equals(this.getIndexedVariables(), other.getIndexedVariables())) {
            return false;
        }
        if (this.isExpensive() != other.isExpensive()) {
            return false;
        }
        if (!Objects.equals(this.getSource(), other.getSource())) {
            return false;
        }
        if (!Objects.equals(this.getLine(), other.getLine())) {
            return false;
        }
        if (!Objects.equals(this.getColumn(), other.getColumn())) {
            return false;
        }
        if (!Objects.equals(this.getEndLine(), other.getEndLine())) {
            return false;
        }
        return Objects.equals(this.getEndColumn(), other.getEndColumn());
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + Objects.hashCode(this.getName());
        if (this.getPresentationHint() != null) {
            hash = 41 * hash + Objects.hashCode(this.getPresentationHint());
        }
        hash = 41 * hash + Integer.hashCode(this.getVariablesReference());
        if (this.getNamedVariables() != null) {
            hash = 41 * hash + Integer.hashCode(this.getNamedVariables());
        }
        if (this.getIndexedVariables() != null) {
            hash = 41 * hash + Integer.hashCode(this.getIndexedVariables());
        }
        hash = 41 * hash + Boolean.hashCode(this.isExpensive());
        if (this.getSource() != null) {
            hash = 41 * hash + Objects.hashCode(this.getSource());
        }
        if (this.getLine() != null) {
            hash = 41 * hash + Integer.hashCode(this.getLine());
        }
        if (this.getColumn() != null) {
            hash = 41 * hash + Integer.hashCode(this.getColumn());
        }
        if (this.getEndLine() != null) {
            hash = 41 * hash + Integer.hashCode(this.getEndLine());
        }
        if (this.getEndColumn() != null) {
            hash = 41 * hash + Integer.hashCode(this.getEndColumn());
        }
        return hash;
    }

    public static Scope create(String name, Integer variablesReference, Boolean expensive) {
        JSONObject json = new JSONObject();
        json.put("name", name);
        json.put("variablesReference", variablesReference);
        json.put("expensive", expensive);
        return new Scope(json);
    }
}

