/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.Source;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;

public class BreakpointLocationsArguments
extends JSONBase {
    BreakpointLocationsArguments(JSONObject jsonData) {
        super(jsonData);
    }

    public Source getSource() {
        return new Source(this.jsonData.getJSONObject("source"));
    }

    public BreakpointLocationsArguments setSource(Source source) {
        this.jsonData.put("source", source.jsonData);
        return this;
    }

    public int getLine() {
        return this.jsonData.getInt("line");
    }

    public BreakpointLocationsArguments setLine(int line) {
        this.jsonData.put("line", line);
        return this;
    }

    public Integer getColumn() {
        return this.jsonData.has("column") ? Integer.valueOf(this.jsonData.getInt("column")) : null;
    }

    public BreakpointLocationsArguments setColumn(Integer column) {
        this.jsonData.putOpt("column", column);
        return this;
    }

    public Integer getEndLine() {
        return this.jsonData.has("endLine") ? Integer.valueOf(this.jsonData.getInt("endLine")) : null;
    }

    public BreakpointLocationsArguments setEndLine(Integer endLine) {
        this.jsonData.putOpt("endLine", endLine);
        return this;
    }

    public Integer getEndColumn() {
        return this.jsonData.has("endColumn") ? Integer.valueOf(this.jsonData.getInt("endColumn")) : null;
    }

    public BreakpointLocationsArguments setEndColumn(Integer endColumn) {
        this.jsonData.putOpt("endColumn", endColumn);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BreakpointLocationsArguments other = (BreakpointLocationsArguments)obj;
        if (!Objects.equals(this.getSource(), other.getSource())) {
            return false;
        }
        if (this.getLine() != other.getLine()) {
            return false;
        }
        if (!Objects.equals(this.getColumn(), other.getColumn())) {
            return false;
        }
        if (!Objects.equals(this.getEndLine(), other.getEndLine())) {
            return false;
        }
        return Objects.equals(this.getEndColumn(), other.getEndColumn());
    }

    public int hashCode() {
        int hash = 2;
        hash = 23 * hash + Objects.hashCode(this.getSource());
        hash = 23 * hash + Integer.hashCode(this.getLine());
        if (this.getColumn() != null) {
            hash = 23 * hash + Integer.hashCode(this.getColumn());
        }
        if (this.getEndLine() != null) {
            hash = 23 * hash + Integer.hashCode(this.getEndLine());
        }
        if (this.getEndColumn() != null) {
            hash = 23 * hash + Integer.hashCode(this.getEndColumn());
        }
        return hash;
    }

    public static BreakpointLocationsArguments create(Source source, Integer line) {
        JSONObject json = new JSONObject();
        json.put("source", source.jsonData);
        json.put("line", line);
        return new BreakpointLocationsArguments(json);
    }
}

